/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.flim.util;

import net.imglib2.RandomAccess;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.ops.flim.FitParams;
import org.scijava.ops.flim.FitResults;

public class RAHelper<I extends RealType<I>> {
    final RandomAccess<I> transRA;
    final RandomAccess<FloatType> intensityRA;
    final RandomAccess<FloatType> initialParamRA;
    final RandomAccess<FloatType> fittedParamRA;
    final RandomAccess<FloatType> fittedRA;
    final RandomAccess<FloatType> residualsRA;
    final RandomAccess<FloatType> chisqRA;
    final RandomAccess<IntType> retcodeRA;
    final int lifetimeAxis;
    final int raOffset;
    final int bufDataStart;
    final int bufDataEnd;

    public RAHelper(FitParams<I> params, FitResults rslts) {
        this.lifetimeAxis = params.ltAxis;
        this.transRA = params.transMap.randomAccess();
        this.intensityRA = rslts.intensityMap.randomAccess();
        this.initialParamRA = params.paramMap != null && params.paramMap.dimension(this.lifetimeAxis) >= (long)params.nComp ? params.paramMap.randomAccess() : null;
        this.fittedParamRA = params.getParamMap ? rslts.paramMap.randomAccess() : null;
        this.fittedRA = params.getFittedMap ? rslts.fittedMap.randomAccess() : null;
        this.residualsRA = params.getResidualsMap ? rslts.residualsMap.randomAccess() : null;
        this.chisqRA = params.getChisqMap ? rslts.chisqMap.randomAccess() : null;
        this.retcodeRA = params.getReturnCodeMap ? rslts.retCodeMap.randomAccess() : null;
        int prefixLen = Math.min(params.instr == null ? 0 : params.instr.length, params.fitStart);
        this.raOffset = params.fitStart - prefixLen;
        this.bufDataStart = prefixLen;
        this.bufDataEnd = this.bufDataStart + params.fitEnd - params.fitStart;
    }

    public boolean loadData(float[] transBuffer, float[] paramBuffer, FitParams<I> params, int[] xytPos) {
        int p;
        this.intensityRA.setPosition(xytPos);
        this.intensityRA.setPosition(0, this.lifetimeAxis);
        if (((FloatType)this.intensityRA.get()).getRealFloat() < params.iThresh) {
            return false;
        }
        this.transRA.setPosition(xytPos);
        this.transRA.setPosition(this.raOffset, this.lifetimeAxis);
        for (int t = 0; t < transBuffer.length; ++t) {
            transBuffer[t] = ((RealType)this.transRA.get()).getRealFloat();
            this.transRA.fwd(this.lifetimeAxis);
        }
        if (this.initialParamRA != null) {
            this.initialParamRA.setPosition(xytPos);
            for (p = 0; p < paramBuffer.length; ++p) {
                paramBuffer[p] = ((FloatType)this.initialParamRA.get()).getRealFloat();
                this.initialParamRA.fwd(this.lifetimeAxis);
            }
        } else if (params.param != null) {
            for (p = 0; p < paramBuffer.length; ++p) {
                paramBuffer[p] = params.param[p];
            }
        } else {
            for (p = 0; p < paramBuffer.length; ++p) {
                paramBuffer[p] = Float.POSITIVE_INFINITY;
            }
        }
        return true;
    }

    public void commitRslts(FitParams<I> params, FitResults rslts, int[] xytPos) {
        if (params.getReturnCodeMap) {
            this.retcodeRA.setPosition(xytPos);
            ((IntType)this.retcodeRA.get()).set(rslts.retCode);
        }
        if (params.dropBad && rslts.retCode != 0) {
            return;
        }
        if (params.getChisqMap) {
            this.chisqRA.setPosition(xytPos);
            ((FloatType)this.chisqRA.get()).set(rslts.chisq);
        }
        if (params.getParamMap) {
            this.fillRA(this.fittedParamRA, xytPos, rslts.param, 0, rslts.param.length);
        }
        if (params.getFittedMap) {
            this.fillRA(this.fittedRA, xytPos, rslts.fitted, this.bufDataStart, this.bufDataEnd);
        }
        if (params.getResidualsMap) {
            this.fillRA(this.residualsRA, xytPos, rslts.residuals, this.bufDataStart, this.bufDataEnd);
        }
    }

    private void fillRA(RandomAccess<FloatType> ra, int[] xytPos, float[] arr, int start, int end) {
        xytPos[this.lifetimeAxis] = 0;
        ra.setPosition(xytPos);
        for (int i = start; i < end; ++i) {
            ((FloatType)ra.get()).set(arr[i]);
            ra.fwd(this.lifetimeAxis);
        }
    }
}

