/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.aggregator;

import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.RationalFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;

public final class RationalAggregator
extends AggregatorSet<RationalNumber> {
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> AVERAGE = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private int myCount = 0;
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public RationalNumber get() {
                    return this.myNumber.divide(this.myCount);
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    ++this.myCount;
                    this.myNumber = this.myNumber.add(anArg);
                }

                @Override
                public boolean isMergeable() {
                    return false;
                }

                @Override
                public void merge(RationalNumber result) {
                    ProgrammingError.throwForIllegalInvocation();
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    ProgrammingError.throwForIllegalInvocation();
                    return null;
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myCount = 0;
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> CARDINALITY = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private int myCount = 0;

                @Override
                public RationalNumber get() {
                    return RationalNumber.valueOf(this.myCount);
                }

                @Override
                public int intValue() {
                    return this.myCount;
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    if (!PrimitiveScalar.isSmall(PrimitiveMath.ONE, PrimitiveFunction.ABS.invoke(anArg.doubleValue()))) {
                        ++this.myCount;
                    }
                }

                @Override
                public void merge(RationalNumber result) {
                    this.myCount += result.intValue();
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myCount = 0;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> LARGEST = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = RationalFunction.MAX.invoke(this.myNumber, RationalFunction.ABS.invoke(anArg));
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.MAX.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> MAX = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = RationalFunction.MAX.invoke(this.myNumber, anArg);
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.MAX.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> MIN = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.POSITIVE_INFINITY;

                @Override
                public RationalNumber get() {
                    if (RationalNumber.isInfinite(this.myNumber)) {
                        return RationalNumber.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = RationalFunction.MIN.invoke(this.myNumber, anArg);
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.MIN.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.POSITIVE_INFINITY;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> NORM1 = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.add(PrimitiveFunction.ABS.invoke(anArg.doubleValue()));
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> NORM2 = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public RationalNumber get() {
                    return RationalNumber.valueOf(PrimitiveFunction.SQRT.invoke(PrimitiveFunction.ABS.invoke(this.myNumber.doubleValue())));
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    double tmpMod = PrimitiveFunction.ABS.invoke(anArg.doubleValue());
                    this.myNumber = this.myNumber.add(tmpMod * tmpMod);
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.HYPOT.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> PRODUCT = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ONE;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.multiply(anArg);
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.MULTIPLY.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ONE;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> PRODUCT2 = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ONE;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.multiply(anArg.multiply(anArg));
                }

                @Override
                public void merge(RationalNumber result) {
                    this.myNumber = this.myNumber.multiply(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.MULTIPLY.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ONE;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> SMALLEST = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.POSITIVE_INFINITY;

                @Override
                public RationalNumber get() {
                    if (RationalNumber.isInfinite(this.myNumber)) {
                        return RationalNumber.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    if (!RationalNumber.isSmall(PrimitiveMath.ONE, anArg)) {
                        this.myNumber = RationalFunction.MIN.invoke(this.myNumber, RationalFunction.ABS.invoke(anArg));
                    }
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.MIN.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.POSITIVE_INFINITY;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> SUM = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.add(anArg);
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> SUM2 = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.add(anArg.multiply(anArg));
                }

                @Override
                public void merge(RationalNumber result) {
                    this.myNumber = this.myNumber.add(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }
            };
        }
    };
    private static final RationalAggregator SET = new RationalAggregator();

    public static RationalAggregator getSet() {
        return SET;
    }

    private RationalAggregator() {
    }

    @Override
    public AggregatorFunction<RationalNumber> average() {
        return AVERAGE.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> cardinality() {
        return CARDINALITY.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> largest() {
        return LARGEST.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> maximum() {
        return MAX.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> minimum() {
        return MIN.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> norm1() {
        return NORM1.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> norm2() {
        return NORM2.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> product() {
        return PRODUCT.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> product2() {
        return PRODUCT2.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> smallest() {
        return SMALLEST.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> sum() {
        return SUM.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> sum2() {
        return SUM2.get().reset();
    }

    static abstract class RationalAggregatorFunction
    implements AggregatorFunction<RationalNumber> {
        RationalAggregatorFunction() {
        }

        @Override
        public final double doubleValue() {
            return ((RationalNumber)this.get()).doubleValue();
        }

        @Override
        public final void invoke(double anArg) {
            this.invoke(RationalNumber.valueOf(anArg));
        }

        @Override
        public final Scalar<RationalNumber> toScalar() {
            return (Scalar)this.get();
        }
    }
}

