/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.function.multiary.AbstractMultiary;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;

public final class QuadraticFunction<N extends Number>
extends AbstractMultiary<N, QuadraticFunction<N>>
implements MultiaryFunction.Quadratic<N> {
    private final MatrixStore<N> myFactors;

    public static QuadraticFunction<BigDecimal> makeBig(Access2D<? extends Number> factors) {
        return new QuadraticFunction<BigDecimal>((MatrixStore)BigDenseStore.FACTORY.copy(factors));
    }

    public static QuadraticFunction<BigDecimal> makeBig(int arity) {
        return new QuadraticFunction<BigDecimal>((MatrixStore)BigDenseStore.FACTORY.makeZero(arity, arity));
    }

    public static QuadraticFunction<ComplexNumber> makeComplex(Access2D<? extends Number> factors) {
        return new QuadraticFunction<ComplexNumber>((MatrixStore)GenericDenseStore.COMPLEX.copy(factors));
    }

    public static QuadraticFunction<ComplexNumber> makeComplex(int arity) {
        return new QuadraticFunction<ComplexNumber>((MatrixStore)GenericDenseStore.COMPLEX.makeZero(arity, arity));
    }

    public static QuadraticFunction<Double> makePrimitive(Access2D<? extends Number> factors) {
        return new QuadraticFunction<Double>((MatrixStore)PrimitiveDenseStore.FACTORY.copy(factors));
    }

    public static QuadraticFunction<Double> makePrimitive(int arity) {
        return new QuadraticFunction<Double>((MatrixStore)PrimitiveDenseStore.FACTORY.makeZero(arity, arity));
    }

    QuadraticFunction(MatrixStore<N> factors) {
        this.myFactors = factors;
        if (this.myFactors.countRows() != this.myFactors.countColumns()) {
            throw new IllegalArgumentException("Must be sqaure!");
        }
    }

    @Override
    public int arity() {
        return (int)this.myFactors.countColumns();
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        PhysicalStore tmpPreallocated = (PhysicalStore)this.myFactors.physical().makeZero(this.arity(), 1L);
        this.getHessian(point).multiply(point, tmpPreallocated);
        return tmpPreallocated;
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.myFactors.logical().superimpose(0, 0, (MatrixStore<N>)this.myFactors.conjugate()).get();
    }

    @Override
    public N invoke(Access1D<N> arg) {
        Scalar retVal = this.getScalarConstant();
        retVal = (Scalar)retVal.add(this.myFactors.multiplyBoth(arg));
        return retVal.get();
    }

    @Override
    public PhysicalStore<N> quadratic() {
        return (PhysicalStore)this.myFactors;
    }

    @Override
    protected PhysicalStore.Factory<N, ?> factory() {
        return this.myFactors.physical();
    }
}

