/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.RecoverableCondition;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;

abstract class CholeskyDecomposition<N extends Number>
extends InPlaceDecomposition<N>
implements Cholesky<N> {
    private double myMaxDiag = PrimitiveMath.ONE;
    private double myMinDiag = PrimitiveMath.ZERO;
    private boolean mySPD = false;

    protected CholeskyDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public N calculateDeterminant(Access2D<?> matrix) {
        this.decompose(this.wrap(matrix));
        return this.getDeterminant();
    }

    @Override
    public boolean checkAndCompute(MatrixStore<N> matrix) {
        return this.compute(matrix, true);
    }

    @Override
    public final boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> aStore) {
        return this.compute(aStore, false);
    }

    @Override
    public N getDeterminant() {
        AggregatorFunction tmpAggrFunc = this.aggregator().product2();
        this.getInPlace().visitDiagonal(0L, 0L, tmpAggrFunc);
        return tmpAggrFunc.get();
    }

    @Override
    public final MatrixStore<N> getInverse(PhysicalStore<N> preallocated) {
        DecompositionStore tmpBody = this.getInPlace();
        preallocated.substituteForwards(tmpBody, false, false, true);
        preallocated.substituteBackwards(tmpBody, false, true, true);
        return preallocated.logical().hermitian(false).get();
    }

    @Override
    public MatrixStore<N> getL() {
        return this.getInPlace().logical().triangular(false, false).get();
    }

    @Override
    public int getRank() {
        double tolerance = PrimitiveFunction.SQRT.invoke(this.getAlgorithmEpsilon());
        int rank = 0;
        DecompositionStore inPlaceStore = this.getInPlace();
        int limit = this.getMinDim();
        for (int ij = 0; ij < limit; ++ij) {
            if (!(inPlaceStore.doubleValue(ij, ij) > tolerance)) continue;
            ++rank;
        }
        return rank;
    }

    @Override
    public final MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs) {
        return this.getSolution(rhs, this.preallocate(this.getInPlace(), rhs));
    }

    @Override
    public final MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs, PhysicalStore<N> preallocated) {
        rhs.supplyTo(preallocated);
        DecompositionStore tmpBody = this.getInPlace();
        preallocated.substituteForwards(tmpBody, false, false, false);
        preallocated.substituteBackwards(tmpBody, false, true, false);
        return preallocated;
    }

    @Override
    public final MatrixStore<N> invert(Access2D<?> original) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse();
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public final MatrixStore<N> invert(Access2D<?> original, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isFullRank() {
        return this.isSolvable();
    }

    public final boolean isFullSize() {
        return true;
    }

    @Override
    public boolean isSPD() {
        return this.mySPD;
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.allocate(tmpCountRows, tmpCountRows);
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateRHS.countRows(), templateRHS.countColumns());
    }

    @Override
    public void reset() {
        super.reset();
        this.mySPD = false;
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs));
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs), preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    protected boolean checkSolvability() {
        return this.mySPD && this.myMinDiag > this.getAlgorithmEpsilon();
    }

    final boolean compute(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean checkHermitian) {
        this.reset();
        DecompositionStore tmpInPlace = this.setInPlace(matrix);
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        int tmpMinDim = Math.min(tmpRowDim, tmpColDim);
        boolean tmpPositiveDefinite = tmpRowDim == tmpColDim;
        this.myMaxDiag = PrimitiveMath.ZERO;
        this.myMinDiag = Double.POSITIVE_INFINITY;
        BasicArray tmpMultipliers = this.makeArray(tmpRowDim);
        if (tmpPositiveDefinite && checkHermitian) {
            tmpPositiveDefinite &= MatrixUtils.isHermitian(tmpInPlace);
        }
        UnaryFunction tmpSqrtFunc = this.function().sqrt();
        for (int ij = 0; tmpPositiveDefinite && ij < tmpMinDim; ++ij) {
            double tmpVal = tmpInPlace.doubleValue(ij, ij);
            this.myMaxDiag = PrimitiveFunction.MAX.invoke(this.myMaxDiag, tmpVal);
            this.myMinDiag = PrimitiveFunction.MIN.invoke(this.myMinDiag, tmpVal);
            if (tmpVal > PrimitiveMath.ZERO) {
                tmpInPlace.modifyOne(ij, ij, tmpSqrtFunc);
                tmpInPlace.divideAndCopyColumn(ij, ij, tmpMultipliers);
                tmpInPlace.applyCholesky(ij, tmpMultipliers);
                continue;
            }
            tmpPositiveDefinite = false;
        }
        this.mySPD = tmpPositiveDefinite;
        return this.computed(this.mySPD);
    }

    double getAlgorithmEpsilon() {
        return this.myMaxDiag * PrimitiveMath.TEN * this.getDimensionalEpsilon();
    }

    static final class Rational
    extends CholeskyDecomposition<RationalNumber> {
        Rational() {
            super(GenericDenseStore.RATIONAL);
        }
    }

    static final class Quat
    extends CholeskyDecomposition<Quaternion> {
        Quat() {
            super(GenericDenseStore.QUATERNION);
        }
    }

    static final class Primitive
    extends CholeskyDecomposition<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY);
        }
    }

    static final class Complex
    extends CholeskyDecomposition<ComplexNumber> {
        Complex() {
            super(GenericDenseStore.COMPLEX);
        }
    }

    static final class Big
    extends CholeskyDecomposition<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY);
        }
    }
}

