/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.Raw2D;
import org.ojalgo.array.blas.DOT;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.Pivot;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;

final class RawLU
extends RawDecomposition
implements LU<Double> {
    private Pivot myPivot;

    RawLU() {
    }

    @Override
    public Double calculateDeterminant(Access2D<?> matrix) {
        double[][] tmpData = this.reset(matrix, false);
        this.getRawInPlaceStore().fillMatching(matrix);
        this.doDecompose(tmpData);
        return this.getDeterminant();
    }

    @Override
    public boolean computeWithoutPivoting(ElementsSupplier<Double> matrix) {
        double[][] tmpData = this.reset(matrix, false);
        matrix.supplyTo(this.getRawInPlaceStore());
        return this.doDecompose(tmpData);
    }

    @Override
    public boolean decompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        double[][] tmpData = this.reset(matrix, false);
        matrix.supplyTo(this.getRawInPlaceStore());
        return this.doDecompose(tmpData);
    }

    @Override
    public Double getDeterminant() {
        int n;
        int m = this.getRowDim();
        if (m != (n = this.getColDim())) {
            throw new IllegalArgumentException("RawStore must be square.");
        }
        double[][] LU2 = this.getRawInPlaceData();
        double d = this.myPivot.signum();
        for (int j = 0; j < n; ++j) {
            d *= LU2[j][j];
        }
        return d;
    }

    @Override
    public MatrixStore<Double> getInverse() {
        int tmpRowDim = this.getRowDim();
        return this.doGetInverse(this.allocate(tmpRowDim, tmpRowDim));
    }

    @Override
    public MatrixStore<Double> getInverse(PhysicalStore<Double> preallocated) {
        return this.doGetInverse(preallocated);
    }

    @Override
    public MatrixStore<Double> getL() {
        return this.getRawInPlaceStore().logical().triangular(false, true).get();
    }

    @Override
    public int[] getPivotOrder() {
        return this.myPivot.getOrder();
    }

    @Override
    public int getRank() {
        int retVal = 0;
        MatrixStore<Double> tmpU = this.getU();
        int tmpMinDim = (int)Math.min(tmpU.countRows(), tmpU.countColumns());
        AggregatorFunction<Double> tmpLargest = PrimitiveAggregator.LARGEST.get();
        tmpU.visitDiagonal(0L, 0L, tmpLargest);
        double tmpLargestValue = tmpLargest.doubleValue();
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            if (tmpU.isSmall(ij, ij, tmpLargestValue)) continue;
            ++retVal;
        }
        return retVal;
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        PrimitiveDenseStore tmpPreallocated = this.allocate(rhs.countRows(), rhs.countColumns());
        return this.getSolution(rhs, tmpPreallocated);
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        this.collect(rhs).logical().row(this.myPivot.getOrder()).supplyTo((ElementsConsumer<Double>)preallocated);
        return this.doSolve(preallocated);
    }

    @Override
    public MatrixStore<Double> getU() {
        return this.getRawInPlaceStore().logical().triangular(true, false).get();
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] tmpData = this.reset(original, false);
        this.getRawInPlaceStore().fillMatching(original);
        this.doDecompose(tmpData);
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isFullRank() {
        double[][] raw = this.getRawInPlaceData();
        int size = this.getMinDim();
        for (int ij = 0; ij < size; ++ij) {
            if (raw[ij][ij] != PrimitiveMath.ZERO) continue;
            return false;
        }
        return true;
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D template) {
        return this.allocate(template.countRows(), template.countRows());
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateBody.countRows(), templateRHS.countColumns());
    }

    @Override
    public void reset() {
        super.reset();
        this.myPivot = null;
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] tmpData = this.reset(body, false);
        this.getRawInPlaceStore().fillMatching(body);
        this.doDecompose(tmpData);
        if (this.isSolvable()) {
            MatrixStore.PRIMITIVE.makeWrapper(rhs).row(this.myPivot.getOrder()).supplyTo((ElementsConsumer<Double>)preallocated);
            return this.doSolve(preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    private boolean doDecompose(double[][] data) {
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        this.myPivot = new Pivot(tmpRowDim);
        double[] tmpColJ = new double[tmpRowDim];
        for (int j = 0; j < tmpColDim; ++j) {
            double tmpVal;
            int i;
            for (i = 0; i < tmpRowDim; ++i) {
                tmpColJ[i] = data[i][j];
            }
            for (i = 0; i < tmpRowDim; ++i) {
                int n = i;
                double d = tmpColJ[n] - DOT.invoke(data[i], 0, tmpColJ, 0, 0, Math.min(i, j));
                tmpColJ[n] = d;
                data[i][j] = d;
            }
            int p = j;
            for (int i2 = j + 1; i2 < tmpRowDim; ++i2) {
                if (!(PrimitiveFunction.ABS.invoke(tmpColJ[i2]) > PrimitiveFunction.ABS.invoke(tmpColJ[p]))) continue;
                p = i2;
            }
            if (p != j) {
                Raw2D.exchangeRows(data, j, p);
                this.myPivot.change(j, p);
            }
            if (j >= tmpRowDim || (tmpVal = data[j][j]) == PrimitiveMath.ZERO) continue;
            for (int i3 = j + 1; i3 < tmpRowDim; ++i3) {
                double[] dArray = data[i3];
                int n = j;
                dArray[n] = dArray[n] / tmpVal;
            }
        }
        return this.computed(true);
    }

    private MatrixStore<Double> doGetInverse(PhysicalStore<Double> preallocated) {
        int[] tmpPivotOrder = this.myPivot.getOrder();
        int tmpRowDim = this.getRowDim();
        for (int i = 0; i < tmpRowDim; ++i) {
            preallocated.set((long)i, (long)tmpPivotOrder[i], PrimitiveMath.ONE);
        }
        RawStore tmpBody = this.getRawInPlaceStore();
        preallocated.substituteForwards(tmpBody, true, false, !this.myPivot.isModified());
        preallocated.substituteBackwards(tmpBody, false, false, false);
        return preallocated;
    }

    private MatrixStore<Double> doSolve(PhysicalStore<Double> preallocated) {
        RawStore tmpBody = this.getRawInPlaceStore();
        preallocated.substituteForwards(tmpBody, true, false, false);
        preallocated.substituteBackwards(tmpBody, false, false, false);
        return preallocated;
    }

    @Override
    protected boolean checkSolvability() {
        return this.getRowDim() == this.getColDim() && this.isFullRank();
    }
}

