/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.io.Serializable;
import java.util.List;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Factory2D;
import org.ojalgo.access.Mutate2D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.matrix.store.ColumnsSupplier;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.RowsSupplier;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.matrix.transformation.TransformationMatrix;
import org.ojalgo.scalar.Scalar;

public interface PhysicalStore<N extends Number>
extends MatrixStore<N>,
Access2D.IndexOf,
ElementsConsumer<N>,
Mutate2D.Exchangeable,
TransformationMatrix.Transformable<N> {
    public List<N> asList();

    public void substituteBackwards(Access2D<N> var1, boolean var2, boolean var3, boolean var4);

    public void substituteForwards(Access2D<N> var1, boolean var2, boolean var3, boolean var4);

    public void transformLeft(Householder<N> var1, int var2);

    public void transformLeft(Rotation<N> var1);

    public void transformRight(Householder<N> var1, int var2);

    public void transformRight(Rotation<N> var1);

    public static interface Factory<N extends Number, I extends PhysicalStore<N>>
    extends Factory2D<I>,
    Serializable {
        public AggregatorSet<N> aggregator();

        public DenseArray.Factory<N> array();

        public MatrixStore.Factory<N> builder();

        public I conjugate(Access2D<?> var1);

        public FunctionSet<N> function();

        default public ColumnsSupplier<N> makeColumnsSupplier(int numberOfRows) {
            return new ColumnsSupplier(this, numberOfRows);
        }

        public Householder<N> makeHouseholder(int var1);

        public Rotation<N> makeRotation(int var1, int var2, double var3, double var5);

        public Rotation<N> makeRotation(int var1, int var2, N var3, N var4);

        default public RowsSupplier<N> makeRowsSupplier(int numberOfColumns) {
            return new RowsSupplier(this, numberOfColumns);
        }

        public Scalar.Factory<N> scalar();

        public I transpose(Access2D<?> var1);
    }
}

