/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.indexer;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.tools.Diagnostic;
import org.scijava.ops.indexer.OpImplData;
import org.scijava.ops.indexer.OpParameter;
import org.scijava.ops.indexer.ProcessingUtils;

class OpClassImplData
extends OpImplData {
    public OpClassImplData(TypeElement source, ExecutableElement fMethod, String doc, String fMethodDoc, ProcessingEnvironment env) {
        super(source, doc, env);
        this.parseFunctionalMethod(fMethod, fMethodDoc);
    }

    private void parseFunctionalMethod(ExecutableElement fMethod, String fMethodDoc) {
        if (fMethodDoc == null || fMethodDoc.isEmpty()) {
            this.printError(fMethod.getEnclosingElement(), " has a functional method without javadoc!");
            return;
        }
        String[] sections = ProcessingUtils.blockSeparator.split(fMethodDoc);
        Iterator<? extends VariableElement> paramTypes = fMethod.getParameters().iterator();
        int expNoParams = fMethod.getParameters().size();
        int expNoReturns = fMethod.getReturnType() instanceof NoType ? 0 : 1;
        int noParams = 0;
        int noReturns = 0;
        block10: for (String section : sections) {
            String[] elements = ProcessingUtils.tagElementSeparator.split(section, 2);
            switch (elements[0]) {
                case "@param": {
                    ++noParams;
                    String[] foo = ProcessingUtils.tagElementSeparator.split(elements[1], 2);
                    String name = foo[0];
                    String description = foo[1];
                    if (paramTypes.hasNext()) {
                        VariableElement pType = paramTypes.next();
                        String type = pType.asType().toString();
                        this.params.add(new OpParameter(name, type, ProcessingUtils.ioType(description), description, ProcessingUtils.isNullable(pType, description)));
                        continue block10;
                    }
                    throw new IllegalArgumentException("Op " + this.source + " has " + noParams + " @param tags, but the functional method only has " + expNoParams + " parameters!");
                }
                case "@return": {
                    ++noReturns;
                    String name = "output";
                    String description = elements[1];
                    String type = fMethod.getReturnType().toString();
                    this.params.add(new OpParameter(name, type, OpParameter.IO_TYPE.OUTPUT, description, false));
                    continue block10;
                }
                case "@author": {
                    this.addAuthor(ProcessingUtils.tagElementSeparator.split(section, 2)[1]);
                }
            }
        }
        if (noParams != expNoParams) {
            throw new IllegalArgumentException("Op " + this.source + " has " + noParams + " @param tags, but the functional method " + fMethod + " only has " + expNoParams + " parameters!");
        }
        if (noReturns != expNoReturns) {
            throw new IllegalArgumentException("Op " + this.source + " has " + noReturns + " @return tags, but the functional method only has " + expNoReturns + " returns!");
        }
    }

    @Override
    void parseAdditionalTags(Element source, List<String[]> additionalTags) {
    }

    @Override
    protected String formulateSource(Element source) {
        Object srcString = source.toString();
        Element parent = source.getEnclosingElement();
        while (parent.getKind() == ElementKind.CLASS) {
            int badPeriod = ((String)srcString).lastIndexOf(46);
            srcString = ((String)srcString).substring(0, badPeriod) + "$" + ((String)srcString).substring(badPeriod + 1);
            parent = parent.getEnclosingElement();
        }
        return "javaClass:/" + URLEncoder.encode((String)srcString, StandardCharsets.UTF_8);
    }

    private void printError(Element source, String msg) {
        this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, source + msg);
    }
}

