/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.indexer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.scijava.ops.indexer.InvalidOpImplException;
import org.scijava.ops.indexer.OpParameter;
import org.scijava.ops.indexer.ProcessingUtils;

abstract class OpImplData {
    protected final Map<String, Object> tags = new HashMap<String, Object>();
    protected final List<String> names = new ArrayList<String>();
    protected final List<OpParameter> params = new ArrayList<OpParameter>();
    protected String source;
    protected String version;
    protected double priority = 0.0;
    protected String description = "";
    protected final List<String> authors = new ArrayList<String>();
    protected final List<String> hints = new ArrayList<String>();
    protected final ProcessingEnvironment env;

    public OpImplData(Element source, String doc, ProcessingEnvironment env) {
        this.env = env;
        this.source = this.formulateSource(source);
        this.version = env.getOptions().getOrDefault("scijava.ops.opVersion", "UNKNOWN");
        List<String[]> tags = ProcessingUtils.blockSeparator.splitAsStream(doc).map(section -> ProcessingUtils.tagElementSeparator.split((CharSequence)section, 2)).collect(Collectors.toList());
        List<String[]> remaining = this.parseUniversalTags(tags);
        this.parseAdditionalTags(source, remaining);
        this.validateOpImpl();
    }

    private void validateOpImpl() {
        if (Objects.isNull(this.names) || this.names.isEmpty()) {
            throw new InvalidOpImplException("Invalid Op defined in : " + this.source + ". Op names cannot be empty!");
        }
        int outputs = 0;
        for (OpParameter p : this.params) {
            if (!p.ioType.equals((Object)OpParameter.IO_TYPE.OUTPUT)) continue;
            ++outputs;
        }
        if (outputs > 1) {
            throw new InvalidOpImplException("Invalid Op defined in : " + this.source + ". Ops cannot have more than one output!");
        }
    }

    private List<String[]> parseUniversalTags(List<String[]> tags) {
        ArrayList<String[]> remainingTags = new ArrayList<String[]>();
        for (CharSequence[] charSequenceArray : tags) {
            if (!charSequenceArray[0].startsWith("@")) {
                if (!this.description.isBlank()) continue;
                this.description = String.join((CharSequence)" ", charSequenceArray);
                continue;
            }
            if (charSequenceArray[0].equals("@author")) {
                this.addAuthor((String)charSequenceArray[1]);
                continue;
            }
            if (((String)charSequenceArray[0]).equals("@implNote")) {
                this.parseImplNote((String)charSequenceArray[1]);
                continue;
            }
            remainingTags.add((String[])charSequenceArray);
        }
        return remainingTags;
    }

    abstract void parseAdditionalTags(Element var1, List<String[]> var2);

    abstract String formulateSource(Element var1);

    private void parseImplNote(String implTag) {
        String[] implElements = ProcessingUtils.tagElementSeparator.split(implTag);
        if (implElements.length > 1) {
            for (int i = 1; i < implElements.length; ++i) {
                String[] kv = implElements[i].split("=", 2);
                if (kv.length != 2) continue;
                String value = kv[1].replaceAll("^[,\"']+|[,\"']+$", "");
                if ("priority".equals(kv[0])) {
                    this.priority = Double.parseDouble(value);
                    continue;
                }
                if ("names".equals(kv[0]) || "name".equals(kv[0])) {
                    this.names.addAll(Arrays.asList(value.split("\\s*,\\s*")));
                    continue;
                }
                if ("hints".equals(kv[0])) {
                    this.hints.addAll(Arrays.asList(value.split("\\s*,\\s*")));
                    continue;
                }
                if (value.contains(",")) {
                    this.tags.put(kv[0], value.split(","));
                    continue;
                }
                this.tags.put(kv[0], value);
            }
        }
    }

    protected void addAuthor(String author) {
        if (!this.authors.contains(author)) {
            this.authors.add(author);
        }
    }

    public Map<String, Object> dumpData() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("source", this.source);
        map.put("version", this.version);
        map.put("names", this.names.toArray(String[]::new));
        map.put("description", this.description);
        map.put("priority", this.priority);
        map.put("authors", this.authors.toArray(String[]::new));
        map.put("hints", this.hints.toArray(String[]::new));
        List foo = this.params.stream().map(OpParameter::data).collect(Collectors.toList());
        map.put("parameters", foo.toArray(Map[]::new));
        map.put("tags", this.tags);
        return Collections.singletonMap("op", map);
    }
}

