/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.indexer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.scijava.ops.indexer.OpClassImplData;
import org.scijava.ops.indexer.OpFieldImplData;
import org.scijava.ops.indexer.OpImplData;
import org.scijava.ops.indexer.OpMethodImplData;
import org.scijava.ops.indexer.ProcessingUtils;
import org.yaml.snakeyaml.Yaml;

public class OpImplNoteParser
extends AbstractProcessor {
    public static final String OP_VERSION = "scijava.ops.opVersion";
    private static final String PARSE_OPS = "scijava.ops.parse";
    private final Yaml yaml = new Yaml();
    private static final EnumSet<ElementKind> elementKindsToInspect = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM);

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Processing Ops written using the implNote syntax...");
        Map<String, String> options = this.processingEnv.getOptions();
        if ("true".equals(options.get(PARSE_OPS))) {
            ArrayList<OpImplData> data = new ArrayList<OpImplData>();
            HashSet<Element> alreadyProcessed = new HashSet<Element>();
            for (TypeElement typeElement : annotations) {
                for (Element element : roundEnvironment.getElementsAnnotatedWith(typeElement)) {
                    this.generateJavadoc(element, data, alreadyProcessed);
                }
            }
            for (Element element : roundEnvironment.getRootElements()) {
                this.generateJavadoc(element, data, alreadyProcessed);
            }
            if (!roundEnvironment.getRootElements().isEmpty() && !data.isEmpty()) {
                try {
                    this.outputYamlDoc(data);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return false;
    }

    private void generateJavadoc(Element element, List<OpImplData> data, Set<Element> alreadyProcessed) {
        if (!alreadyProcessed.add(element)) {
            return;
        }
        if (!elementKindsToInspect.contains((Object)element.getKind())) {
            return;
        }
        TypeElement classElement = (TypeElement)element;
        Optional<OpImplData> clsData = this.elementToImplData(classElement);
        clsData.ifPresent(data::add);
        for (Element element2 : classElement.getEnclosedElements()) {
            this.elementToImplData(element2).ifPresent(data::add);
        }
    }

    private void outputYamlDoc(List<OpImplData> collectedData) throws IOException {
        List data = collectedData.stream().map(OpImplData::dumpData).collect(Collectors.toList());
        String doc = this.yaml.dump(data);
        FileObject resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "ops.yaml", new Element[0]);
        try (OutputStream os = resource.openOutputStream();){
            os.write(doc.getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> supportedOptions = new HashSet<String>();
        supportedOptions.add(PARSE_OPS);
        supportedOptions.add(OP_VERSION);
        return supportedOptions;
    }

    private Optional<OpImplData> elementToImplData(Element element) {
        String javadoc = this.processingEnv.getElementUtils().getDocComment(element);
        if (javadoc != null && javadoc.contains("implNote op")) {
            try {
                if (element.getKind() == ElementKind.CLASS) {
                    TypeElement typeElement = (TypeElement)element;
                    ExecutableElement fMethod = ProcessingUtils.findFunctionalMethod(this.processingEnv, typeElement);
                    String fMethodDoc = this.processingEnv.getElementUtils().getDocComment(fMethod);
                    return Optional.of(new OpClassImplData(typeElement, fMethod, javadoc, fMethodDoc, this.processingEnv));
                }
                if (element.getKind() == ElementKind.METHOD) {
                    return Optional.of(new OpMethodImplData((ExecutableElement)element, javadoc, this.processingEnv));
                }
                if (element.getKind() == ElementKind.FIELD) {
                    return Optional.of(new OpFieldImplData(element, javadoc, this.processingEnv));
                }
            }
            catch (Exception e) {
                ProcessingUtils.printProcessingException(element, e, this.processingEnv);
            }
        }
        return Optional.empty();
    }
}

