/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.indexer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.scijava.ops.indexer.OpParameter;

final class ProcessingUtils {
    public static final Pattern blockSeparator = Pattern.compile("^\\s*(?=@\\S)", 8);
    public static final Pattern tagElementSeparator = Pattern.compile("\\s*[,\\s]+(?=(?:[^'\"]*['\"][^'\"]*['\"])*[^'\"]*$)");

    private ProcessingUtils() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static OpParameter.IO_TYPE ioType(String paramDesc) {
        if (paramDesc.trim().endsWith("(container)")) {
            return OpParameter.IO_TYPE.CONTAINER;
        }
        if (paramDesc.trim().endsWith("(mutable)")) {
            return OpParameter.IO_TYPE.MUTABLE;
        }
        return OpParameter.IO_TYPE.INPUT;
    }

    public static boolean isNullable(VariableElement element, String paramDesc) {
        boolean elementIsNullable = element.getAnnotationMirrors().stream().anyMatch(a -> a.toString().contains("Nullable"));
        boolean descIsNullable = ProcessingUtils.isNullable(paramDesc);
        return elementIsNullable || descIsNullable;
    }

    public static boolean isNullable(String paramDesc) {
        return paramDesc.trim().endsWith("(nullable)");
    }

    public static void printProcessingException(Element source, Throwable t, ProcessingEnvironment env) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Exception parsing source " + source + ": " + sw);
    }

    public static ExecutableElement findFunctionalMethod(ProcessingEnvironment env, TypeElement source) {
        ExecutableElement fMethod = ProcessingUtils.findAbstractFunctionalMethod(env, source);
        if (fMethod != null) {
            for (Element element : env.getElementUtils().getAllMembers(source)) {
                boolean isFIFace;
                if (!element.getKind().equals((Object)ElementKind.METHOD)) continue;
                ExecutableElement ex = (ExecutableElement)element;
                boolean bl = isFIFace = ((FunctionalInterface[])source.getAnnotationsByType(FunctionalInterface.class)).length > 0;
                if (!isFIFace && ex.getAnnotation(Override.class) == null || !ex.getSimpleName().equals(fMethod.getSimpleName())) continue;
                return (ExecutableElement)element;
            }
        }
        throw new IllegalArgumentException("Op " + source + " does not declare a functional method!");
    }

    /*
     * WARNING - void declaration
     */
    private static ExecutableElement findAbstractFunctionalMethod(ProcessingEnvironment env, TypeElement source) {
        if (source.getAnnotationMirrors().stream().anyMatch(a -> a.toString().contains("FunctionalInterface"))) {
            int abstractMethodCount = 0;
            Object var3_4 = null;
            for (Element element : source.getEnclosedElements()) {
                if (element.getKind() != ElementKind.METHOD || !element.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                ExecutableElement executableElement = (ExecutableElement)element;
                ++abstractMethodCount;
            }
            if (abstractMethodCount == 1) {
                void var3_5;
                return var3_5;
            }
        }
        for (TypeMirror typeMirror : source.getInterfaces()) {
            ExecutableElement executableElement;
            Element iFace = env.getTypeUtils().asElement(typeMirror);
            if (!(iFace instanceof TypeElement) || (executableElement = ProcessingUtils.findAbstractFunctionalMethod(env, (TypeElement)iFace)) == null) continue;
            return executableElement;
        }
        Element superCls = env.getTypeUtils().asElement(source.getSuperclass());
        if (superCls instanceof TypeElement) {
            return ProcessingUtils.findAbstractFunctionalMethod(env, (TypeElement)superCls);
        }
        return null;
    }
}

