/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.types;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Set;
import org.scijava.common3.Classes;
import org.scijava.common3.GenericTyped;
import org.scijava.types.Proxyable;

public abstract class Nil<T>
implements GenericTyped,
Proxyable<T> {
    private final TypeToken<?> typeToken;
    private final Object callbacks;

    public Nil() {
        this.typeToken = new TypeToken<T>(this.getClass()){};
        this.callbacks = this;
    }

    public Nil(Object callbacks) {
        this.typeToken = new TypeToken<T>(this.getClass()){};
        this.callbacks = this.callbacks(callbacks);
    }

    private Nil(Class<T> rawType) {
        this.typeToken = TypeToken.of(rawType);
        this.callbacks = this;
    }

    private Nil(Type type) {
        this.typeToken = TypeToken.of((Type)type);
        this.callbacks = this;
    }

    private Nil(Type type, Object callbacks) {
        this.typeToken = TypeToken.of((Type)type);
        this.callbacks = this.callbacks(callbacks);
    }

    public static <T> Nil<T> of(Class<T> rawType) {
        return new Nil<T>((Class)rawType){};
    }

    public static Nil<?> of(Type type) {
        return new Nil<Object>(type){};
    }

    public static Nil<?> of(Type type, Object callbacks) {
        return new Nil<Object>(type, callbacks){};
    }

    public String toString() {
        return this.typeToken.toString();
    }

    @Override
    public Type type() {
        return this.typeToken.getType();
    }

    @Override
    public T proxy() {
        ClassLoader loader = Classes.classLoader();
        Set ifaceSet = this.typeToken.getTypes().interfaces().rawTypes();
        boolean appendGT = !ifaceSet.contains(GenericTyped.class);
        int ifaceCount = ifaceSet.size() + (appendGT ? 1 : 0);
        Class[] interfaces = new Class[ifaceCount];
        ifaceSet.toArray(interfaces);
        if (appendGT) {
            interfaces[ifaceCount - 1] = GenericTyped.class;
        }
        Object proxy = Proxy.newProxyInstance(loader, interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Method m = Nil.this.callbacks.getClass().getMethod(method.getName(), method.getParameterTypes());
                    return m.invoke(Nil.this.callbacks, args);
                }
                catch (NoSuchMethodException exc) {
                    return Classes.nullValue(method.getReturnType());
                }
            }
        });
        return (T)proxy;
    }

    private Object callbacks(Object o) {
        return o instanceof Nil ? ((Nil)o).callbacks : o;
    }
}

