/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.cal;

import ij.ImagePlus;
import ij.measure.Calibration;
import sc.fiji.i5d.Image5D;

public class Calibration5D
extends Calibration {
    protected int nDimensions = 5;
    protected String[] dimensionLabels = new String[this.nDimensions];

    public Calibration5D(Image5D imp) {
        super((ImagePlus)imp);
        this.dimensionLabels[0] = "x";
        this.dimensionLabels[1] = "y";
        if (this.nDimensions >= 2) {
            this.dimensionLabels[2] = "ch";
        }
        if (this.nDimensions >= 3) {
            this.dimensionLabels[3] = "z";
        }
        if (this.nDimensions >= 4) {
            this.dimensionLabels[4] = "t";
        }
    }

    public Calibration5D() {
        this(null);
    }

    public String getDimensionLabel(int dimension) {
        if (dimension < 0 || dimension >= this.nDimensions) {
            throw new IllegalArgumentException("Invalid Dimension: " + dimension);
        }
        return this.dimensionLabels[dimension];
    }

    public Calibration copy() {
        Calibration5D copy = new Calibration5D();
        copy.pixelWidth = this.pixelWidth;
        copy.pixelHeight = this.pixelHeight;
        copy.pixelDepth = this.pixelDepth;
        copy.frameInterval = this.frameInterval;
        copy.xOrigin = this.xOrigin;
        copy.yOrigin = this.yOrigin;
        copy.zOrigin = this.zOrigin;
        copy.info = this.info;
        copy.setUnit(this.getUnit());
        copy.setValueUnit(this.getValueUnit());
        copy.nDimensions = this.nDimensions;
        copy.dimensionLabels = new String[this.nDimensions];
        for (int i = 0; i < this.nDimensions; ++i) {
            this.dimensionLabels[i] = this.getDimensionLabel(i);
        }
        return copy;
    }
}

