/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.maxTKendallTau;

import java.util.Collections;
import java.util.Random;
import java.util.function.Function;
import net.imglib2.Dimensions;
import net.imglib2.IterableInterval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.collections.IntArray;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.ops.image.coloc.ColocUtil;
import org.scijava.ops.image.coloc.IntArraySorter;
import org.scijava.ops.image.coloc.MergeSort;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class MTKT<T extends RealType<T>, U extends RealType<U>>
implements Functions.Arity3<RandomAccessibleInterval<T>, RandomAccessibleInterval<U>, Long, Double> {
    @OpDependency(name="image.histogram")
    private Function<Iterable<T>, Histogram1d<T>> histogramOpT;
    @OpDependency(name="image.histogram")
    private Function<Iterable<U>, Histogram1d<U>> histogramOpU;
    @OpDependency(name="threshold.otsu")
    private Computers.Arity1<Histogram1d<T>, T> thresholdOpT;
    @OpDependency(name="threshold.otsu")
    private Computers.Arity1<Histogram1d<U>, U> thresholdOpU;

    public Double apply(RandomAccessibleInterval<T> image1, RandomAccessibleInterval<U> image2, @Nullable Long seed) {
        if (!Intervals.equalDimensions(image1, image2)) {
            throw new IllegalArgumentException("Image dimensions do not match");
        }
        long n1 = Intervals.numElements(image1);
        if (n1 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Image dimensions too large: " + n1);
        }
        int n = (int)n1;
        if (seed == null) {
            seed = -1993333951L;
        }
        double thresh1 = this.thresholdT(image1);
        double thresh2 = this.thresholdU(image2);
        double[][] rank = MTKT.rankTransformation(image1, image2, thresh1, thresh2, n, seed);
        double maxtau = MTKT.calculateMaxKendallTau(rank, thresh1, thresh2, n);
        return maxtau;
    }

    double thresholdT(RandomAccessibleInterval<T> image) {
        Histogram1d<T> histogram = this.histogramOpT.apply((Iterable<IterableInterval>)Views.iterable(image));
        RealType result = (RealType)((RealType)Util.getTypeFromInterval(image)).createVariable();
        this.thresholdOpT.compute(histogram, (Object)result);
        return result.getRealDouble();
    }

    double thresholdU(RandomAccessibleInterval<U> image) {
        Histogram1d<U> histogram = this.histogramOpU.apply((Iterable<U>)Views.iterable(image));
        RealType result = (RealType)((RealType)Util.getTypeFromInterval(image)).createVariable();
        this.thresholdOpU.compute(histogram, (Object)result);
        return result.getRealDouble();
    }

    static <T extends RealType<T>, U extends RealType<U>> double[][] rankTransformation(RandomAccessibleInterval<T> image1, RandomAccessibleInterval<U> image2, double thres1, double thres2, int n, long seed) {
        int[] rankIndex1 = MTKT.rankSamples(image1, seed);
        int[] rankIndex2 = MTKT.rankSamples(image2, seed);
        IntArray validIndex = new IntArray(new int[n]);
        validIndex.setSize(0);
        for (int i = 0; i < n; ++i) {
            if (!((double)rankIndex1[i] >= thres1) || !((double)rankIndex2[i] >= thres2)) continue;
            validIndex.addValue(i);
        }
        int rn = validIndex.size();
        double[][] finalRanks = new double[rn][2];
        for (int i = 0; i < rn; ++i) {
            int index = validIndex.getValue(i);
            finalRanks[i][0] = rankIndex1[index];
            finalRanks[i][1] = rankIndex2[index];
        }
        return finalRanks;
    }

    private static <V extends RealType<V>> int[] rankSamples(RandomAccessibleInterval<V> image, long seed) {
        long elementCount = Intervals.numElements(image);
        if (elementCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Image dimensions too large: " + elementCount);
        }
        int n = (int)elementCount;
        int[] rankIndex = new int[n];
        for (int i = 0; i < n; ++i) {
            rankIndex[i] = i;
        }
        Random r = new Random(seed);
        ColocUtil.shuffle(rankIndex, r);
        RealType a = (RealType)((RealType)Util.getTypeFromInterval(image)).createVariable();
        RandomAccess ra = image.randomAccess();
        Collections.sort(new IntArray(rankIndex), (indexA, indexB) -> {
            IntervalIndexer.indexToPosition((long)indexA.intValue(), (Dimensions)image, (Positionable)ra);
            a.set((Type)((RealType)ra.get()));
            IntervalIndexer.indexToPosition((long)indexB.intValue(), (Dimensions)image, (Positionable)ra);
            RealType b = (RealType)ra.get();
            return a.compareTo((Object)b);
        });
        return rankIndex;
    }

    static double calculateMaxKendallTau(double[][] rank, double thresholdRank1, double thresholdRank2, int n) {
        int rn = rank.length;
        double step = 1.0 + 1.0 / Math.log(Math.log(n));
        double tempOff1 = 1.0;
        IntArray activeIndex = new IntArray();
        double maxNormalTau = Double.MIN_VALUE;
        while (tempOff1 * step + thresholdRank1 < (double)n) {
            tempOff1 *= step;
            double tempOff2 = 1.0;
            while (tempOff2 * step + thresholdRank2 < (double)n) {
                double normalTau;
                tempOff2 *= step;
                activeIndex.setSize(0);
                for (int i = 0; i < rn; ++i) {
                    if (!(rank[i][0] >= (double)n - tempOff1) || !(rank[i][1] >= (double)n - tempOff2)) continue;
                    activeIndex.addValue(i);
                }
                int an = activeIndex.size();
                if (an > 1) {
                    double kendallTau = MTKT.calculateKendallTau(rank, activeIndex);
                    double sdTau = Math.sqrt(2.0 * (double)(2 * an + 5) / 9.0 / (double)an / (double)(an - 1));
                    normalTau = kendallTau / sdTau;
                } else {
                    normalTau = Double.MIN_VALUE;
                }
                if (!(normalTau > maxNormalTau)) continue;
                maxNormalTau = normalTau;
            }
        }
        return maxNormalTau;
    }

    static double calculateKendallTau(double[][] rank, IntArray activeIndex) {
        int an = activeIndex.size();
        int indicator = 0;
        double[][] partRank = new double[2][an];
        for (Integer i : activeIndex) {
            partRank[0][indicator] = rank[i][0];
            partRank[1][indicator] = rank[i][1];
            ++indicator;
        }
        double[] partRank1 = partRank[0];
        double[] partRank2 = partRank[1];
        int[] index = new int[an];
        for (int i = 0; i < an; ++i) {
            index[i] = i;
        }
        IntArraySorter.sort(index, (a, b) -> Double.compare(partRank1[a], partRank1[b]));
        MergeSort mergeSort = new MergeSort(index, (a, b) -> Double.compare(partRank2[a], partRank2[b]));
        long n0 = (long)an * (long)(an - 1) / 2L;
        long S = mergeSort.sort();
        return (double)(n0 - 2L * S) / (double)n0;
    }
}

