/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter;

import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class FFTMethodsLinearFFTFilterC<I extends RealType<I>, O extends RealType<O>, K extends RealType<K>, C extends ComplexType<C>>
implements Computers.Arity7<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, Boolean, Boolean, Computers.Arity2<RandomAccessibleInterval<C>, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>>, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>, RandomAccessibleInterval<O>> {
    @OpDependency(name="filter.fft")
    private Computers.Arity1<RandomAccessibleInterval<I>, RandomAccessibleInterval<C>> fftInOp;
    @OpDependency(name="filter.fft")
    private Computers.Arity1<RandomAccessibleInterval<K>, RandomAccessibleInterval<C>> fftKernelOp;
    @OpDependency(name="filter.ifft")
    private Computers.Arity1<RandomAccessibleInterval<C>, RandomAccessibleInterval<O>> ifftOp;
    @OpDependency(name="filter.createFFTOutput")
    private Functions.Arity3<Dimensions, C, Boolean, RandomAccessibleInterval<C>> createOp;

    public void compute(RandomAccessibleInterval<I> in, RandomAccessibleInterval<K> kernel, Boolean performInputFFT, Boolean performKernelFFT, Computers.Arity2<RandomAccessibleInterval<C>, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>> frequencyOp, @Nullable RandomAccessibleInterval<C> fftInput, @Nullable RandomAccessibleInterval<C> fftKernel, RandomAccessibleInterval<O> out) {
        ComplexType fftType = (ComplexType)Util.getTypeFromInterval(fftInput);
        RandomAccessibleInterval inputFFT = fftInput;
        RandomAccessibleInterval kernelFFT = fftKernel;
        if (inputFFT == null) {
            inputFFT = (RandomAccessibleInterval)this.createOp.apply(in, (Object)fftType, (Object)true);
        }
        if (kernelFFT == null) {
            kernelFFT = (RandomAccessibleInterval)this.createOp.apply(in, (Object)fftType, (Object)true);
        }
        if (performInputFFT.booleanValue()) {
            this.fftInOp.compute(in, (Object)inputFFT);
        }
        if (performKernelFFT.booleanValue()) {
            this.fftKernelOp.compute(kernel, (Object)kernelFFT);
        }
        frequencyOp.compute((Object)inputFFT, (Object)kernelFFT, (Object)inputFFT);
        this.ifftOp.compute((Object)inputFFT, out);
    }
}

