/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.fftSize;

public final class NextSmoothNumber {
    private NextSmoothNumber() {
    }

    public static int nextSmooth(int x) {
        int result = -1;
        int z = 50;
        while (result == -1) {
            result = NextSmoothNumber.nextSmooth(7, x, z);
            x += z;
        }
        return result;
    }

    public static int nextSmooth(int y, int x, int z) {
        double delta = 1.0E-6;
        double[] a = new double[z];
        NextSmoothNumber.handlePrime(2, x, a);
        NextSmoothNumber.handlePrime(3, x, a);
        NextSmoothNumber.handlePrime(5, x, a);
        NextSmoothNumber.handlePrime(7, x, a);
        double log = Math.log(x);
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] >= log - delta)) continue;
            return x + i;
        }
        return -1;
    }

    private static void handlePrime(int p, int x, double[] a) {
        double log = Math.log(p);
        for (int power = p; power <= x + a.length; power *= p) {
            int j = x % power;
            if (j > 0) {
                j = power - j;
            }
            while (j < a.length) {
                int n = j;
                a[n] = a[n] + log;
                j += power;
            }
        }
    }

    private static int log2(int x) {
        int j = 0;
        int k = 1;
        while (k < x) {
            ++j;
            k *= 2;
        }
        return j;
    }
}

