/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.sigma;

import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.function.Computers;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class DefaultSigmaFilter<T extends RealType<T>, V extends RealType<V>>
implements Computers.Arity5<RandomAccessibleInterval<T>, Shape, Double, Double, OutOfBoundsFactory<T, RandomAccessibleInterval<T>>, RandomAccessibleInterval<V>> {
    @OpDependency(name="stats.variance")
    private Computers.Arity1<Iterable<T>, DoubleType> varianceOp;
    @OpDependency(name="map.neighborhood")
    private Computers.Arity3<RandomAccessibleInterval<T>, Shape, Computers.Arity2<Iterable<T>, T, V>, RandomAccessibleInterval<V>> mapper;
    final Computers.Arity4<Iterable<T>, T, Double, Double, V> op = new Computers.Arity4<Iterable<T>, T, Double, Double, V>(){

        public void compute(Iterable<T> neighborhood, T center, Double range, Double minPixelFraction, V output) {
            DoubleType varianceResult = new DoubleType();
            DefaultSigmaFilter.this.varianceOp.compute(neighborhood, (Object)varianceResult);
            double varianceValue = varianceResult.getRealDouble() * range;
            double centerValue = center.getRealDouble();
            double sumAll = 0.0;
            double sumWithin = 0.0;
            long countAll = 0L;
            long countWithin = 0L;
            for (RealType neighbor : neighborhood) {
                double pixelValue = neighbor.getRealDouble();
                double diff = centerValue - pixelValue;
                sumAll += pixelValue;
                ++countAll;
                if (diff > varianceValue || diff < -varianceValue) continue;
                sumWithin += pixelValue;
                ++countWithin;
            }
            if (countWithin < (long)((int)(minPixelFraction * (double)countAll))) {
                output.setReal(sumAll / (double)countAll);
            } else {
                output.setReal(sumWithin / (double)countWithin);
            }
        }
    };

    public void compute(RandomAccessibleInterval<T> input, Shape inputNeighborhoodShape, Double range, Double minPixelFraction, @Nullable OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory, RandomAccessibleInterval<V> output) {
        if (outOfBoundsFactory == null) {
            outOfBoundsFactory = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
        }
        if (range <= 0.0) {
            throw new IllegalArgumentException("range must be positive!");
        }
        Computers.Arity2 mappedOp = (in1, in2, out) -> this.op.compute(in1, in2, (Object)range, (Object)minPixelFraction, out);
        IntervalView extended = Views.interval((RandomAccessible)Views.extend(input, (OutOfBoundsFactory)outOfBoundsFactory), input);
        this.mapper.compute((Object)extended, (Object)inputNeighborhoodShape, (Object)mappedOp, output);
    }
}

