/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom2d;

import java.util.List;
import java.util.function.Function;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;
import org.scijava.ops.image.geom.GeomUtils;
import org.scijava.ops.spi.OpDependency;

public class DefaultFeretsDiameterForAngle
implements Computers.Arity2<Polygon2D, Double, DoubleType> {
    @OpDependency(name="geom.convexHull")
    private Function<Polygon2D, Polygon2D> function;

    public void compute(Polygon2D input, Double angle, DoubleType feretsDiameter) {
        List<RealLocalizable> points = GeomUtils.vertices(this.function.apply(input));
        double angleRad = -angle.doubleValue() * Math.PI / 180.0;
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        for (RealLocalizable p : points) {
            double tmpX = p.getDoublePosition(0) * Math.cos(angleRad) - p.getDoublePosition(1) * Math.sin(angleRad);
            minX = tmpX < minX ? tmpX : minX;
            maxX = tmpX > maxX ? tmpX : maxX;
        }
        feretsDiameter.set(Math.abs(maxX - minX));
    }
}

