/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom3d;

import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.IterableRegion;
import net.imglib2.type.BooleanType;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.scijava.ops.spi.OpDependency;

public class DefaultInertiaTensor3D<B extends BooleanType<B>>
implements Function<IterableRegion<B>, RealMatrix> {
    @OpDependency(name="geom.centroid")
    private Function<IterableRegion<B>, RealLocalizable> centroid;

    @Override
    public RealMatrix apply(IterableRegion<B> input) {
        if (input.numDimensions() != 3) {
            throw new IllegalArgumentException("Only three-dimensional inputs allowed!");
        }
        BlockRealMatrix output = new BlockRealMatrix(3, 3);
        Cursor c = input.inside().localizingCursor();
        double[] pos = new double[3];
        double[] computedCentroid = new double[3];
        this.centroid.apply(input).localize(computedCentroid);
        double mX = computedCentroid[0];
        double mY = computedCentroid[1];
        double mZ = computedCentroid[2];
        while (c.hasNext()) {
            c.fwd();
            c.localize(pos);
            output.setEntry(0, 0, output.getEntry(0, 0) + (pos[0] - mX) * (pos[0] - mX));
            output.setEntry(1, 1, output.getEntry(1, 1) + (pos[1] - mX) * (pos[1] - mY));
            output.setEntry(2, 2, output.getEntry(2, 2) + (pos[2] - mX) * (pos[2] - mZ));
            output.setEntry(0, 1, output.getEntry(0, 1) + (pos[0] - mY) * (pos[1] - mY));
            output.setEntry(1, 0, output.getEntry(0, 1));
            output.setEntry(0, 2, output.getEntry(0, 2) + (pos[0] - mY) * (pos[2] - mZ));
            output.setEntry(2, 0, output.getEntry(0, 2));
            output.setEntry(1, 2, output.getEntry(1, 2) + (pos[1] - mZ) * (pos[2] - mZ));
            output.setEntry(2, 1, output.getEntry(1, 2));
        }
        double size = input.inside().size();
        output.setEntry(0, 0, output.getEntry(0, 0) / size);
        output.setEntry(0, 1, output.getEntry(0, 1) / size);
        output.setEntry(0, 2, output.getEntry(0, 2) / size);
        output.setEntry(1, 0, output.getEntry(1, 0) / size);
        output.setEntry(1, 1, output.getEntry(1, 1) / size);
        output.setEntry(1, 2, output.getEntry(1, 2) / size);
        output.setEntry(2, 0, output.getEntry(2, 0) / size);
        output.setEntry(2, 1, output.getEntry(2, 1) / size);
        output.setEntry(2, 2, output.getEntry(2, 2) / size);
        return output;
    }
}

