/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import net.imglib2.type.numeric.RealType;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.scijava.function.Computers;
import org.scijava.ops.spi.Nullable;

public final class DefaultPNorm<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity2<I, Boolean, O> {
    private static final NormalDistribution NORMAL_DISTRIBUTION = new NormalDistribution();

    public void compute(I q, @Nullable Boolean lowerTail, O o) {
        if (lowerTail == null) {
            lowerTail = true;
        }
        double normDistValue = NORMAL_DISTRIBUTION.cumulativeProbability(q.getRealDouble());
        if (!lowerTail.booleanValue()) {
            normDistValue = 1.0 - normDistValue;
        }
        o.setReal(normDistValue);
    }
}

