/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.minimum;

import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.image.threshold.AbstractComputeThresholdHistogram;
import org.scijava.ops.image.threshold.Thresholds;

public class ComputeMinimumThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T> {
    @Override
    public long computeBin(Histogram1d<T> hist) {
        long[] histogram = hist.toLongArray();
        return ComputeMinimumThreshold.computeBin(histogram);
    }

    public static long computeBin(long[] histogram) {
        if (histogram.length < 2) {
            return 0L;
        }
        int iter = 0;
        int max = -1;
        double[] iHisto = new double[histogram.length];
        for (int i = 0; i < histogram.length; ++i) {
            iHisto[i] = histogram[i];
            if (histogram[i] <= 0L) continue;
            max = i;
        }
        double[] tHisto = new double[iHisto.length];
        while (!Thresholds.bimodalTest(iHisto)) {
            for (int i = 1; i < histogram.length - 1; ++i) {
                tHisto[i] = (iHisto[i - 1] + iHisto[i] + iHisto[i + 1]) / 3.0;
            }
            tHisto[0] = (iHisto[0] + iHisto[1]) / 3.0;
            tHisto[histogram.length - 1] = (iHisto[histogram.length - 2] + iHisto[histogram.length - 1]) / 3.0;
            System.arraycopy(tHisto, 0, iHisto, 0, iHisto.length);
            if (++iter <= 10000) continue;
            throw new IllegalStateException("Minimum Threshold not found after 10000 iterations.");
        }
        double[] y = iHisto;
        for (int k = 1; k < max; ++k) {
            if (!(y[k - 1] > y[k]) || !(y[k + 1] >= y[k])) continue;
            return k;
        }
        return -1L;
    }
}

