/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.project.project;

import java.util.Iterator;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.util.Intervals;
import org.scijava.function.Computers;

public class DefaultProjectParallel<T, V>
implements Computers.Arity3<RandomAccessibleInterval<T>, Computers.Arity1<Iterable<T>, V>, Integer, RandomAccessibleInterval<V>> {
    public void compute(RandomAccessibleInterval<T> input, Computers.Arity1<Iterable<T>, V> op, Integer dim, RandomAccessibleInterval<V> output) {
        if (input.numDimensions() != output.numDimensions() + 1) {
            throw new IllegalArgumentException("ERROR: input image must have one dimension more than output image!");
        }
        if (input.numDimensions() <= dim) {
            throw new IllegalArgumentException("ERROR: input image must contain dimension " + dim);
        }
        LoopBuilder.setImages(output, (RandomAccessibleInterval)Intervals.positions(output)).multiThreaded().forEachChunk(chunk -> {
            RandomAccess chunkRA = input.randomAccess();
            chunk.forEachPixel((pixel, position) -> {
                for (int d = 0; d < input.numDimensions(); ++d) {
                    if (d == dim) continue;
                    chunkRA.setPosition(position.getIntPosition(d - (d > dim ? 1 : 0)), d);
                }
                op.compute((Object)new DimensionIterable(input.dimension(dim.intValue()), dim, chunkRA), pixel);
            });
            return null;
        });
    }

    final class DimensionIterable
    implements Iterable<T> {
        private final long size;
        private final int dim;
        private final RandomAccess<T> access;

        public DimensionIterable(long size, int dim, RandomAccess<T> access) {
            this.size = size;
            this.dim = dim;
            this.access = access;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                int k = -1;

                @Override
                public boolean hasNext() {
                    return (long)this.k < DimensionIterable.this.size - 1L;
                }

                @Override
                public T next() {
                    ++this.k;
                    DimensionIterable.this.access.setPosition(this.k, DimensionIterable.this.dim);
                    return DimensionIterable.this.access.get();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported");
                }
            };
        }
    }
}

