/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.graphics.internals;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.graphics.AxisIntervalCalculationStyle;
import org.renjin.graphics.ClippingMode;
import org.renjin.graphics.Color;
import org.renjin.graphics.ColorPalette;
import org.renjin.graphics.GraphicsDevice;
import org.renjin.graphics.LineType;
import org.renjin.graphics.geom.Margins;
import org.renjin.graphics.geom.Rectangle;
import org.renjin.graphics.internals.Devices;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class Par {
    static final Parameter[] ParTable = new Parameter[]{new Parameter("adj"){}, new Parameter("ann"){}, new NonInlineParameter("ask"){}, new Parameter("bg"){}, new Parameter("bty"){}, new Parameter("cex"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return new DoubleArrayVector(dd.getParameters().getCexBase());
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.getParameters().setCexBase(this.toDouble(exp2));
        }
    }, new Parameter("cex.axis"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return new DoubleArrayVector(dd.getParameters().getAxisAnnotationStyle().getFontSizeFactor());
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.getParameters().getAxisAnnotationStyle().setFontSizeFactor(this.toDouble(exp2));
        }
    }, new Parameter("cex.lab"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return new DoubleArrayVector(dd.getParameters().getXyLabelStyle().getFontSizeFactor());
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.getParameters().getXyLabelStyle().setFontSizeFactor(this.toDouble(exp2));
        }
    }, new Parameter("cex.main"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return new DoubleArrayVector(dd.getParameters().getMainTitleStyle().getFontSizeFactor());
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.getParameters().getMainTitleStyle().setFontSizeFactor(this.toDouble(exp2));
        }
    }, new Parameter("cex.sub"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return new DoubleArrayVector(dd.getParameters().getSubTitleStyle().getFontSizeFactor());
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.getParameters().getSubTitleStyle().setFontSizeFactor(this.toDouble(exp2));
        }
    }, new ReadOnlyParameter("cin"){}, new Parameter("col"){}, new Parameter("col.axis"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getParameters().getAxisAnnotationStyle().getColor().toExp();
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.getParameters().getAxisAnnotationStyle().setColor(this.toColor(context, dd, exp2));
        }
    }, new Parameter("col.lab"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getParameters().getXyLabelStyle().getColor().toExp();
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.getParameters().getXyLabelStyle().setColor(this.toColor(context, dd, exp2));
        }
    }, new Parameter("col.main"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getParameters().getMainTitleStyle().getColor().toExp();
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.getParameters().getMainTitleStyle().setColor(this.toColor(context, dd, exp2));
        }
    }, new Parameter("col.sub"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getParameters().getSubTitleStyle().getColor().toExp();
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.getParameters().getSubTitleStyle().setColor(this.toColor(context, dd, exp2));
        }
    }, new ReadOnlyParameter("cra"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getDefaultCharacterSize().toVector();
        }
    }, new Parameter("crt"){}, new ReadOnlyParameter("csi"){}, new Parameter("csy"){}, new ReadOnlyParameter("cxy"){}, new ReadOnlyParameter("din"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getDeviceSizeInInches().toVector();
        }
    }, new Parameter("err"){}, new Parameter("family"){}, new Parameter("fg"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return StringVector.valueOf(dd.getParameters().getForeground().toString());
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            Color color = this.toColor(context, dd, exp2);
            dd.getParameters().setForeground(color);
            dd.getParameters().setColor(color);
        }

        @Override
        public void specifyInline(Context context, GraphicsDevice dd, SEXP exp2) {
            Color color = this.toColor(context, dd, exp2);
            dd.getParameters().setForeground(color);
        }
    }, new NonInlineParameter("fig"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getFigureRegion().toVector();
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.setFigureRegion(Rectangle.from(exp2));
        }
    }, new NonInlineParameter("fin"){}, new Parameter("font"){}, new Parameter("font.axis"){}, new Parameter("font.lab"){}, new Parameter("font.main"){}, new Parameter("font.sub"){}, new Parameter("lab"){}, new Parameter("las"){}, new Parameter("lend"){}, new NonInlineParameter("lheight"){}, new Parameter("ljoin"){}, new Parameter("lmitre"){}, new Parameter("lty"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getParameters().getLineType().toExpression();
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.getParameters().setLineType(LineType.valueOf(exp2));
        }
    }, new Parameter("lwd"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return new DoubleArrayVector(dd.getParameters().getLineWidth());
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            if (exp2 instanceof Vector && exp2.length() >= 1) {
                dd.getParameters().setLineWidth(((Vector)exp2).getElementAsDouble(0));
            }
            throw new EvalException("invalid lwd parameter: " + exp2.toString(), new Object[0]);
        }
    }, new NonInlineParameter("mai"){}, new NonInlineParameter("mar"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getInnerMargins().toVector();
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.setInnerMargins(Margins.fromExp(exp2));
        }
    }, new NonInlineParameter("mex"){}, new NonInlineParameter("mfcol"){}, new NonInlineParameter("mfg"){}, new NonInlineParameter("mfrow"){}, new Parameter("mgp"){}, new Parameter("mkh"){}, new NonInlineParameter("new"){}, new NonInlineParameter("oma"){}, new NonInlineParameter("omd"){}, new NonInlineParameter("omi"){}, new Parameter("pch"){}, new NonInlineParameter("pin"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getPlotDimensions().toVector();
        }
    }, new NonInlineParameter("plt"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getPlotRegion().toVector();
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.setPlotRegion(Rectangle.from(exp2));
        }
    }, new NonInlineParameter("ps"){}, new NonInlineParameter("pty"){}, new Parameter("smo"){}, new Parameter("srt"){}, new Parameter("tck"){}, new Parameter("tcl"){}, new NonInlineParameter("usr"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getUserCoordinates().toVector();
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.setUserCoordinates(Rectangle.from(exp2));
        }
    }, new Parameter("xaxp"){}, new Parameter("xaxs"){}, new Parameter("xaxt"){}, new NonInlineParameter("xlog"){}, new Parameter("xpd"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getParameters().getClippingMode().toExp();
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.getParameters().setClippingMode(ClippingMode.fromExp(exp2));
        }
    }, new Parameter("yaxp"){}, new Parameter("yaxs"){

        @Override
        public SEXP query(GraphicsDevice dd) {
            return dd.getParameters().getYAxisStyle().getCalculationStyle().toExp();
        }

        @Override
        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            dd.getParameters().getYAxisStyle().setCalculationStyle(AxisIntervalCalculationStyle.fromExp(exp2));
        }
    }, new Parameter("yaxt"){}, new NonInlineParameter("ylog"){}, new ObsoleteParameter("gamma"){}, new ObsoleteParameter("type"){}, new ObsoleteParameter("tmag"){}, new GraphicalArg("asp"){}, new GraphicalArg("main"){}, new GraphicalArg("sub"){}, new GraphicalArg("xlab"){}, new GraphicalArg("ylab"){}, new GraphicalArg("xlim"){}, new GraphicalArg("ylim"){}};

    @Internal
    public static SEXP par(@Current Context context, ListVector args2) {
        ListVector.NamedBuilder result = new ListVector.NamedBuilder();
        GraphicsDevice dd = Devices.GEcurrentDevice(context);
        for (NamedValue namedValue : args2.namedValues()) {
            if (namedValue.hasName()) {
                Parameter parameter = Par.findParameter(namedValue.getName());
                result.add(namedValue.getName(), parameter.query(dd));
                parameter.specify(context, dd, namedValue.getValue());
                continue;
            }
            if (namedValue.getValue() instanceof StringVector) {
                StringVector vector2 = (StringVector)namedValue.getValue();
                String parName = vector2.getElementAsString(0);
                result.add(namedValue.getName(), Par.findParameter(parName).query(dd));
                continue;
            }
            result.add("", (SEXP)Null.INSTANCE);
        }
        return result.build();
    }

    private static Parameter findParameter(String name) {
        for (Parameter param : ParTable) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        throw new EvalException("no parameter found by name " + name, new Object[0]);
    }

    private static abstract class GraphicalArg
    extends Parameter {
        protected GraphicalArg(String name) {
            super(name);
        }
    }

    private static abstract class ObsoleteParameter
    extends Parameter {
        protected ObsoleteParameter(String name) {
            super(name);
        }
    }

    private static abstract class NonInlineParameter
    extends Parameter {
        protected NonInlineParameter(String name) {
            super(name);
        }
    }

    private static abstract class ReadOnlyParameter
    extends Parameter {
        protected ReadOnlyParameter(String name) {
            super(name);
        }

        @Override
        public final void specify(Context context, GraphicsDevice dd, SEXP exp2) {
        }

        @Override
        public final void specifyInline(Context context, GraphicsDevice dd, SEXP exp2) {
        }
    }

    private static abstract class Parameter {
        private final String name;

        protected Parameter(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }

        public SEXP query(GraphicsDevice dd) {
            throw new EvalException("implement me: " + this.getName(), new Object[0]);
        }

        public void specify(Context context, GraphicsDevice dd, SEXP exp2) {
            throw new EvalException("implement me" + this.getName(), new Object[0]);
        }

        public void specifyInline(Context context, GraphicsDevice dd, SEXP exp2) {
            this.specify(context, dd, null);
        }

        protected final Color toColor(Context context, GraphicsDevice dd, SEXP exp2) {
            if (!(exp2 instanceof Vector) || exp2.length() < 1) {
                throw new EvalException("invalid rgb specification: " + exp2.toString(), new Object[0]);
            }
            return Color.fromExp(context.getSession().getSingleton(ColorPalette.class), dd.getParameters().getBackground(), (Vector)exp2, 0);
        }

        protected final double toDouble(SEXP exp2) {
            if (!(exp2 instanceof Vector) || exp2.length() < 1) {
                throw new EvalException("invalid par value for '%s'", this.getName());
            }
            return ((Vector)exp2).getElementAsDouble(0);
        }
    }
}

