/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math.complex.Complex;
import org.renjin.eval.EvalException;
import org.renjin.primitives.Deparse;
import org.renjin.sexp.AbstractVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.HasNamedValues;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.ListBuilder;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;
import org.renjin.util.NamesBuilder;

public class ListVector
extends AbstractVector
implements Iterable<SEXP>,
HasNamedValues {
    public static final String TYPE_NAME = "list";
    public static final ListVector EMPTY = new ListVector(new SEXP[0]);
    public static final Vector.Type VECTOR_TYPE = new ListType();
    private final SEXP[] values;

    public ListVector(List<? extends SEXP> values, AttributeMap attributes2) {
        super(Null.INSTANCE, attributes2);
        this.values = this.toArray(values);
    }

    private SEXP[] toArray(List<? extends SEXP> list2) {
        return list2.toArray(new SEXP[list2.size()]);
    }

    public ListVector(List<? extends SEXP> values) {
        this(values, AttributeMap.EMPTY);
    }

    public ListVector(SEXP[] values, SEXP tag, AttributeMap attributes2) {
        super(tag, attributes2);
        this.values = Arrays.copyOf(values, values.length);
        assert (this.checkDims()) : "dim do not match length of object";
    }

    public ListVector(SEXP[] values, AttributeMap attributes2) {
        this(values, (SEXP)Null.INSTANCE, attributes2);
        assert (this.checkDims()) : "dim do not match length of object";
    }

    public ListVector(SEXP ... values) {
        this(values, AttributeMap.EMPTY);
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public final boolean isWiderThan(Vector vector2) {
        return this.getVectorType().isWiderThan(vector2);
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Iterator<SEXP> iterator() {
        return Iterators.forArray((Object[])this.values);
    }

    @Override
    public int length() {
        return this.values.length;
    }

    @Override
    public int indexOf(Vector vector2, int vectorIndex, int startIndex) {
        for (int i = 0; i != this.values.length; ++i) {
            SEXP element = this.values[i];
            if (!(element instanceof AtomicVector && element.length() == 1 ? ((AtomicVector)element).indexOf(vector2, vectorIndex, 0) != -1 : element.equals(vector2.getElementAsSEXP(vectorIndex)))) continue;
            return i;
        }
        return -1;
    }

    public int indexOfName(String name) {
        AtomicVector names2 = this.attributes.getNamesOrNull();
        if (names2 instanceof StringVector) {
            for (int i = 0; i != names2.length(); ++i) {
                if (!((StringVector)names2).getElementAsString(i).equals(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public SEXP get(int index) {
        return this.values[index];
    }

    public SEXP get(String name) {
        int index = this.indexOfName(name);
        if (index == -1) {
            return Null.INSTANCE;
        }
        return this.values[index];
    }

    @Override
    public Vector.Type getVectorType() {
        return VECTOR_TYPE;
    }

    public SEXP getElementAsSEXP(int index) {
        return this.values[index];
    }

    @Override
    public double getElementAsDouble(int index) {
        SEXP value = this.values[index];
        if (value.length() == 1 && value instanceof AtomicVector) {
            return ((AtomicVector)value).getElementAsDouble(0);
        }
        throw new EvalException("(list) object cannot be coerced to type 'double'", new Object[0]);
    }

    public double getElementAsDouble(String name) {
        return this.getElementAsDouble(this.getIndexByName(name));
    }

    public ListVector getElementAsList(String name) {
        return (ListVector)this.getElementAsSEXP(this.getIndexByName(name));
    }

    public Vector getElementAsVector(String name) {
        return (Vector)this.getElementAsSEXP(this.getIndexByName(name));
    }

    @Override
    public int getElementAsInt(int index) {
        SEXP value = this.values[index];
        if (value.length() == 1 && value instanceof AtomicVector) {
            return ((AtomicVector)value).getElementAsInt(0);
        }
        throw new EvalException("(list) object cannot be coerced to type 'int'", new Object[0]);
    }

    public int getElementAsInt(String name) {
        return this.getElementAsInt(this.getIndexByName(name));
    }

    @Override
    public String getElementAsString(int index) {
        SEXP value = this.values[index];
        if (value.length() == 1 && value instanceof AtomicVector) {
            return ((AtomicVector)value).getElementAsString(0);
        }
        return Deparse.deparseExp(null, value);
    }

    @Override
    public Object getElementAsObject(int index) {
        SEXP value = this.values[index];
        if (value.length() == 1 && value instanceof AtomicVector) {
            return ((AtomicVector)value).getElementAsObject(0);
        }
        return Deparse.deparseExp(null, value);
    }

    @Override
    public Logical getElementAsLogical(int index) {
        SEXP value = this.values[index];
        if (value.length() == 1 && value instanceof AtomicVector) {
            return ((AtomicVector)value).getElementAsLogical(0);
        }
        throw new EvalException("(list) object cannot be coerced to type 'logical'", new Object[0]);
    }

    @Override
    public int getElementAsRawLogical(int index) {
        SEXP value = this.values[index];
        if (value.length() == 1 && value instanceof AtomicVector) {
            return ((AtomicVector)value).getElementAsRawLogical(0);
        }
        throw new EvalException("(list) object cannot be coerced to type 'logical'", new Object[0]);
    }

    @Override
    public Complex getElementAsComplex(int index) {
        SEXP value = this.values[index];
        if (value.length() == 1 && value instanceof AtomicVector) {
            return ((AtomicVector)value).getElementAsComplex(0);
        }
        throw new EvalException("(list) object cannot be coerced to type 'complex'", new Object[0]);
    }

    public SEXP[] toArrayUnsafe() {
        return this.values;
    }

    @Override
    public boolean contains(Vector vector2, int vectorIndex) {
        Object match2 = vector2.getElementAsSEXP(vectorIndex);
        for (int i = 0; i != this.length(); ++i) {
            if (!this.values[i].equals(match2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isElementNA(int index) {
        SEXP value = this.values[index];
        if (value.length() == 1 && value instanceof AtomicVector) {
            return ((AtomicVector)value).isElementNA(0);
        }
        return false;
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    public int maxElementLength() {
        int max2 = 0;
        for (SEXP element : this) {
            if (element.length() <= max2) continue;
            max2 = element.length();
        }
        return max2;
    }

    public int minElementLength() {
        int min2 = Integer.MAX_VALUE;
        for (SEXP element : this) {
            if (element.length() >= min2) continue;
            min2 = element.length();
        }
        return min2;
    }

    @Override
    public Iterable<NamedValue> namedValues() {
        return new Iterable<NamedValue>(){

            @Override
            public Iterator<NamedValue> iterator() {
                return new UnmodifiableIterator<NamedValue>(){
                    private int index = 0;

                    public boolean hasNext() {
                        return this.index < ListVector.this.length();
                    }

                    public NamedValue next() {
                        NameValuePair pair = new NameValuePair(ListVector.this.getName(this.index), ListVector.this.getElementAsSEXP(this.index));
                        ++this.index;
                        return pair;
                    }
                };
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListVector listExp = (ListVector)o;
        return Arrays.equals(this.values, listExp.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("list(");
        for (int i = 0; i < Math.min(this.length(), 20); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            if (!Strings.isNullOrEmpty((String)this.getName(i))) {
                sb.append(this.getName(i)).append(" = ");
            }
            sb.append(this.getElementAsSEXP(i));
        }
        if (this.length() > 20) {
            sb.append(", ...").append(this.length()).append(" elements total");
        }
        sb.append(")");
        return sb.toString();
    }

    public static Builder newBuilder() {
        return new Builder(0, 0);
    }

    public static Builder buildFromClone(ListVector toClone) {
        return new Builder(toClone);
    }

    public static NamedBuilder buildNamedFromClone(ListVector toClone) {
        return new NamedBuilder(toClone);
    }

    @Override
    public Builder newCopyBuilder() {
        return new Builder(this);
    }

    @Override
    public Vector.Builder newBuilderWithInitialSize(int initialSize) {
        return new Builder(initialSize, initialSize);
    }

    @Override
    public Builder newBuilderWithInitialCapacity(int initialCapacity) {
        return new Builder(0, initialCapacity);
    }

    public static NamedBuilder newNamedBuilder() {
        return new NamedBuilder();
    }

    public NamedBuilder newCopyNamedBuilder() {
        return new NamedBuilder(this);
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new ListVector(this.values, attributes2);
    }

    private static class NameValuePair
    implements NamedValue {
        private final String name;
        private final SEXP value;

        public NameValuePair(String name, SEXP value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public boolean hasName() {
            return !Strings.isNullOrEmpty((String)this.name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public SEXP getValue() {
            return this.value;
        }
    }

    private static class ListType
    extends Vector.Type {
        public ListType() {
            super(7);
        }

        @Override
        public Builder newBuilder() {
            return new Builder(0, 0);
        }

        @Override
        public Builder newBuilderWithInitialSize(int initialSize) {
            return new Builder(initialSize);
        }

        @Override
        public Builder newBuilderWithInitialCapacity(int initialCapacity) {
            return new Builder(0, initialCapacity);
        }

        @Override
        public int compareElements(Vector vector1, int index1, Vector vector2, int index2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean elementsEqual(Vector vector1, int index1, Vector vector2, int index2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Vector getElementAsVector(Vector vector2, int index) {
            return new ListVector(new SEXP[]{vector2.getElementAsSEXP(index)});
        }
    }

    public static class NamedBuilder
    extends Builder
    implements ListBuilder {
        private final NamesBuilder names;

        public NamedBuilder() {
            this.names = NamesBuilder.withInitialCapacity(10);
        }

        public NamedBuilder(int initialSize, int initialCapacity) {
            super(initialSize, initialCapacity);
            this.names = NamesBuilder.withInitialCapacity(initialCapacity);
        }

        protected NamedBuilder(ListVector toClone) {
            super(toClone);
            this.names = NamesBuilder.clonedFrom(toClone);
        }

        public NamedBuilder(int initialLength) {
            super(initialLength);
            this.names = NamesBuilder.withInitialLength(initialLength);
        }

        @Override
        public NamedBuilder add(String name, SEXP value) {
            this.add(value);
            this.names.set(this.length() - 1, name);
            return this;
        }

        public NamedBuilder add(String name, Vector.Builder builder) {
            return this.add(name, (SEXP)builder.build());
        }

        @Override
        public NamedBuilder add(Symbol name, SEXP value) {
            return this.add(name.getPrintName(), value);
        }

        public NamedBuilder add(String name, int value) {
            return this.add(name, (SEXP)new IntArrayVector(value));
        }

        public NamedBuilder add(String name, double value) {
            return this.add(name, (SEXP)new DoubleArrayVector(value));
        }

        @Override
        public NamedBuilder add(SEXP value) {
            super.add(value);
            return this;
        }

        @Override
        public int getIndexByName(String nameToReplace) {
            return this.names.getIndexByName(nameToReplace);
        }

        public NamedBuilder add(String name, String value) {
            return this.add(name, (SEXP)new StringArrayVector(value));
        }

        public NamedBuilder add(String name, boolean value) {
            return this.add(name, (SEXP)new LogicalArrayVector(value));
        }

        public NamedBuilder add(String name, Logical value) {
            return this.add(name, (SEXP)new LogicalArrayVector(value));
        }

        public NamedBuilder addAll(ListVector list2) {
            for (int i = 0; i != list2.length(); ++i) {
                this.add(list2.getName(i), list2.get(i));
            }
            return this;
        }

        @Override
        public NamedBuilder set(int index, SEXP value) {
            super.set(index, value);
            return this;
        }

        @Override
        public NamedBuilder remove(int index) {
            super.remove(index);
            this.names.remove(index);
            return this;
        }

        @Override
        protected AttributeMap buildAttributes() {
            if (this.names.haveNames()) {
                this.setAttribute(Symbols.NAMES, (SEXP)this.names.build(this.length()));
            }
            return super.buildAttributes();
        }
    }

    public static class Builder
    extends AbstractVector.AbstractBuilder<SEXP> {
        private final List<SEXP> values;

        public Builder() {
            this(0, 0);
        }

        public Builder(int initialSize, int initialCapacity) {
            this.values = new ArrayList<SEXP>(initialCapacity);
            for (int i = 0; i != initialSize; ++i) {
                this.values.add(Null.INSTANCE);
            }
        }

        protected Builder(ListVector toClone) {
            this.values = Lists.newArrayList((Iterable)toClone);
            this.copyAttributesFrom(toClone);
        }

        public Builder(int initialLength) {
            this.values = Lists.newArrayListWithCapacity((int)initialLength);
            for (int i = 0; i != initialLength; ++i) {
                this.add(Null.INSTANCE);
            }
        }

        protected Builder remove(int index) {
            this.values.remove(index);
            return this;
        }

        @Override
        public Builder add(SEXP value) {
            this.values.add(value);
            return this;
        }

        @Override
        public Builder set(int index, SEXP value) {
            while (this.values.size() <= index) {
                this.add(Null.INSTANCE);
            }
            this.values.set(index, value);
            return this;
        }

        @Override
        public Builder setNA(int index) {
            return this.set(index, Null.INSTANCE);
        }

        public Builder setFrom(int destinationIndex, SEXP source, int sourceIndex) {
            return this.set(destinationIndex, (SEXP)source.getElementAsSEXP(sourceIndex));
        }

        @Override
        public int length() {
            return this.values.size();
        }

        public Builder replace(int i, SEXP value) {
            this.values.set(i, value);
            return this;
        }

        protected List<SEXP> getValues() {
            return this.values;
        }

        @Override
        public ListVector build() {
            return new ListVector(this.values, this.buildAttributes());
        }

        @Override
        public Builder add(Number value) {
            if (value instanceof Integer || value instanceof Byte || value instanceof Byte || value instanceof Short) {
                this.add(new IntArrayVector(value.intValue()));
            } else {
                this.add(new DoubleArrayVector(value.doubleValue()));
            }
            return this;
        }
    }
}

