/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.classification;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import weka.classifiers.Classifier;

class ClassifierSerialization {
    ClassifierSerialization() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] objectToBytes(Object object) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object bytesToObject(byte[] bytes) {
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            return new ObjectInputStream(stream).readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonElement wekaToJson(Classifier classifier) {
        return new JsonPrimitive(Base64.getEncoder().encodeToString(ClassifierSerialization.objectToBytes(classifier)));
    }

    public static Classifier jsonToWeka(JsonElement jsonElement) {
        return (Classifier)ClassifierSerialization.bytesToObject(Base64.getDecoder().decode(jsonElement.getAsString()));
    }
}

