/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.integral;

import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.function.RealTypeConverter;
import mpicbg.imglib.function.VoidConverter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.RealType;

public class ScaleAreaAveraging2d<T extends RealType<T>, R extends RealType<R>>
implements OutputAlgorithm<R> {
    protected Image<R> scaled;
    protected Image<T> integralImg;
    protected String error;
    protected final int[] size;
    final R targetType;
    final Converter<T, R> converter;

    public ScaleAreaAveraging2d(Image<T> integralImg, R targetType, int[] size) {
        this.size = size;
        this.targetType = targetType;
        this.integralImg = integralImg;
        this.converter = targetType.getClass().isInstance(integralImg.createType()) ? new VoidConverter<R>() : new RealTypeConverter<T, R>();
    }

    public ScaleAreaAveraging2d(Image<T> integralImg, R targetType, Converter<T, R> converter, int[] size) {
        this.size = size;
        this.targetType = targetType;
        this.integralImg = integralImg;
        this.converter = converter;
    }

    public void setOutputDimensions(int width, int height) {
        this.size[0] = width;
        this.size[1] = height;
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public boolean process() {
        ImageFactory<R> imgFactory = new ImageFactory<R>(this.targetType, this.integralImg.getContainerFactory());
        this.scaled = imgFactory.createImage(this.size);
        LocalizableCursor<R> cursor = this.scaled.createLocalizableCursor();
        LocalizableByDimCursor<T> c2 = this.integralImg.createLocalizableByDimCursor();
        RealType sum = (RealType)this.integralImg.createType();
        RealType area = (RealType)this.integralImg.createType();
        if (ScaleAreaAveraging2d.isIntegerDivision(this.integralImg, this.scaled)) {
            int stepSizeX = (this.integralImg.getDimension(0) - 1) / this.size[0];
            int stepSizeY = (this.integralImg.getDimension(1) - 1) / this.size[1];
            area.setReal(stepSizeX * stepSizeY);
            while (cursor.hasNext()) {
                cursor.fwd();
                ScaleAreaAveraging2d.computeSum(cursor.getPosition(0) * stepSizeX, cursor.getPosition(1) * stepSizeY, stepSizeX, stepSizeY, c2, sum);
                sum.div(area);
                this.converter.convert(sum, cursor.getType());
            }
        } else {
            double stepSizeX = ((double)this.integralImg.getDimension(0) - 1.0) / (double)this.size[0];
            double stepSizeY = ((double)this.integralImg.getDimension(1) - 1.0) / (double)this.size[1];
            while (cursor.hasNext()) {
                cursor.fwd();
                int px = cursor.getPosition(0);
                int py = cursor.getPosition(1);
                double tmp1 = (double)px * stepSizeX + 0.5;
                int startX = (int)tmp1;
                int vX = (int)(tmp1 + stepSizeX) - startX;
                double tmp2 = (double)py * stepSizeY + 0.5;
                int startY = (int)tmp2;
                int vY = (int)(tmp2 + stepSizeY) - startY;
                area.setReal(vX * vY);
                ScaleAreaAveraging2d.computeSum(startX, startY, vX, vY, c2, sum);
                sum.div(area);
                this.converter.convert(sum, cursor.getType());
            }
        }
        return true;
    }

    private static final <T extends RealType<T>> void computeSum(int startX, int startY, int vX, int vY, LocalizableByDimCursor<T> c2, T sum) {
        c2.setPosition(startX, 0);
        c2.setPosition(startY, 1);
        sum.set(c2.getType());
        c2.move(vX, 0);
        sum.sub((NumericType)((NumericType)c2.getType()));
        c2.move(vY, 1);
        sum.add((NumericType)((NumericType)c2.getType()));
        c2.move(-vX, 0);
        sum.sub((NumericType)((NumericType)c2.getType()));
    }

    protected static final boolean isIntegerDivision(Image<?> integralImg, Image<?> scaled) {
        for (int d = 0; d < scaled.getNumDimensions(); ++d) {
            if (0 == (integralImg.getDimension(d) - 1) % scaled.getDimension(d)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.error;
    }

    @Override
    public Image<R> getResult() {
        return this.scaled;
    }
}

