/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.logic.BitType;
import mpicbg.imglib.type.numeric.RealType;

public class PickImagePeaks<T extends RealType<T>>
implements OutputAlgorithm<BitType>,
Benchmark {
    private final Image<T> image;
    private long pTime;
    private Image<BitType> peakImage;
    private ContainerFactory peakContainerFactory;
    private final ArrayList<int[]> peakLocList;
    private final double[] suppressAxis;
    private double suppressSum;
    private boolean allowBorderPeak = false;

    public PickImagePeaks(Image<T> inputImage) {
        this.image = inputImage;
        this.pTime = 0L;
        this.peakContainerFactory = null;
        this.peakLocList = new ArrayList();
        this.peakImage = null;
        this.suppressAxis = new double[inputImage.getDimensions().length];
        Arrays.fill(this.suppressAxis, 0.0);
        this.suppressSum = 0.0;
    }

    private void doSuppression() {
        if (this.peakLocList.size() > 0 && this.suppressSum >= 1.0) {
            ArrayList<Peak> suppressionList = new ArrayList<Peak>();
            LocalizableByDimCursor<T> imCursor = this.image.createLocalizableByDimCursor();
            for (int[] pos : this.peakLocList) {
                imCursor.setPosition(pos);
                RealType type = (RealType)((RealType)imCursor.getType()).copy();
                suppressionList.add(new Peak(this, pos, type));
            }
            Collections.sort(suppressionList);
            this.peakLocList.clear();
            for (Peak p : suppressionList) {
                boolean isOK = true;
                for (int[] pos : this.peakLocList) {
                    if (!(p.distanceFactor(pos) < 1.0)) continue;
                    isOK = false;
                    break;
                }
                if (!isOK) continue;
                this.peakLocList.add(p.getPosition());
            }
        }
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public boolean process() {
        long sTime = System.currentTimeMillis();
        LocalizableCursor<T> cursor = this.image.createLocalizableCursor();
        LocalizableByDimCursor<T> localCursor = this.image.createLocalizableByDimCursor();
        int[] dimensions = this.image.getDimensions();
        int[] pos = new int[dimensions.length];
        int[] checkPos = new int[pos.length];
        ImageFactory<BitType> peakFactory = new ImageFactory<BitType>(new BitType(), this.peakContainerFactory == null ? new ArrayContainerFactory() : this.peakContainerFactory);
        this.peakImage = peakFactory.createImage(dimensions);
        Image<BitType> imImage = peakFactory.createImage(dimensions);
        LocalizableCursor<BitType> imImagePullCursor = imImage.createLocalizableCursor();
        LocalizableByDimCursor<BitType> imImagePushCursor = this.allowBorderPeak ? imImage.createLocalizableByDimCursor(new OutOfBoundsStrategyValueFactory<BitType>(new BitType(true))) : imImage.createLocalizableByDimCursor();
        LocalizableByDimCursor<BitType> peakImageCursor = this.peakImage.createLocalizableByDimCursor();
        this.peakLocList.clear();
        for (int d = 0; d < pos.length; ++d) {
            cursor.reset();
            while (cursor.hasNext()) {
                cursor.fwd();
                cursor.getPosition(pos);
                imImagePushCursor.setPosition(pos);
                System.arraycopy(pos, 0, checkPos, 0, pos.length);
                int n = d;
                checkPos[n] = checkPos[n] - 1;
                if (checkPos[d] < 0) {
                    ((BitType)imImagePushCursor.getType()).set(false);
                    continue;
                }
                localCursor.setPosition(checkPos);
                RealType t0 = (RealType)cursor.getType();
                RealType tc = (RealType)localCursor.getType();
                ((BitType)imImagePushCursor.getType()).set(tc.compareTo(t0) >= 0);
            }
            imImagePullCursor.reset();
            while (imImagePullCursor.hasNext()) {
                imImagePullCursor.fwd();
                imImagePullCursor.getPosition(pos);
                peakImageCursor.setPosition(pos);
                System.arraycopy(pos, 0, checkPos, 0, pos.length);
                int n = d;
                checkPos[n] = checkPos[n] + 1;
                if (!this.allowBorderPeak && checkPos[d] >= dimensions[d]) {
                    ((BitType)peakImageCursor.getType()).set(false);
                    continue;
                }
                if (d != 0 && !((BitType)peakImageCursor.getType()).get()) continue;
                imImagePushCursor.setPosition(checkPos);
                ((BitType)peakImageCursor.getType()).set(!((BitType)imImagePullCursor.getType()).get() && ((BitType)imImagePushCursor.getType()).get());
            }
        }
        this.pTime = System.currentTimeMillis() - sTime;
        return true;
    }

    @Override
    public long getProcessingTime() {
        return this.pTime;
    }

    @Override
    public Image<BitType> getResult() {
        return this.peakImage;
    }

    public ArrayList<int[]> getPeakList() {
        if (this.peakLocList.isEmpty() && this.peakImage != null) {
            LocalizableCursor<BitType> pkCursor = this.peakImage.createLocalizableCursor();
            this.peakLocList.clear();
            while (pkCursor.hasNext()) {
                pkCursor.fwd();
                if (!((BitType)pkCursor.getType()).get()) continue;
                this.peakLocList.add(pkCursor.getPosition());
            }
            this.doSuppression();
        }
        return this.peakLocList;
    }

    public void setSuppression(double r) {
        Arrays.fill(this.suppressAxis, r);
        this.suppressSum = (double)this.suppressAxis.length * r;
    }

    public void setAllowBorderPeak(boolean allowBorderPeak) {
        this.allowBorderPeak = allowBorderPeak;
    }

    public void setSuppression(double[] r) {
        System.arraycopy(r, 0, this.suppressAxis, 0, this.suppressAxis.length);
        this.suppressSum = 0.0;
        for (double a : r) {
            this.suppressSum += a;
        }
    }

    private static class Peak
    implements Comparable<Peak> {
        private final T peakVal;
        private final int[] pos;
        final /* synthetic */ PickImagePeaks this$0;

        public Peak(int[] inPos, T val) {
            this.this$0 = var1_1;
            this.peakVal = val;
            this.pos = inPos;
        }

        @Override
        public int compareTo(Peak inPeak) {
            if (this.peakVal.compareTo(inPeak.peakVal) == 1) {
                return -1;
            }
            if (this.peakVal.compareTo(inPeak.peakVal) == 0) {
                return 0;
            }
            return 1;
        }

        public int[] getPosition() {
            return this.pos;
        }

        public double distanceFactor(int[] inPos) {
            double val = 0.0;
            for (int i = 0; i < this.pos.length; ++i) {
                val += Math.pow(((double)this.pos[i] - (double)inPos[i]) / this.this$0.suppressAxis[i], 2.0);
            }
            val = Math.sqrt(val);
            return val;
        }
    }
}

