/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.cell;

import mpicbg.imglib.container.ContainerImpl;
import mpicbg.imglib.container.PixelGridContainerImpl;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;
import mpicbg.imglib.type.Type;

public class Cell<T extends Type<T>, A extends ArrayDataAccess<A>> {
    protected final int[] offset;
    protected final int[] step;
    protected final int[] dim;
    protected final int cellId;
    protected final int numDimensions;
    protected final int numPixels;
    protected final int numEntities;
    protected final A data;

    public Cell(A creator, int cellId, int[] dim, int[] offset, int entitiesPerPixel) {
        this.offset = offset;
        this.cellId = cellId;
        this.numDimensions = dim.length;
        this.dim = dim;
        this.numPixels = ContainerImpl.getNumPixels(dim);
        this.numEntities = PixelGridContainerImpl.getNumEntities(dim, entitiesPerPixel);
        this.step = new int[this.numDimensions];
        this.data = (ArrayDataAccess)creator.createArray(this.numEntities);
        Array.createAllocationSteps(dim, this.step);
    }

    public A getData() {
        return this.data;
    }

    protected void close() {
        this.data.close();
    }

    public int getNumPixels() {
        return this.numPixels;
    }

    public int getNumEntities() {
        return this.numEntities;
    }

    public void getDimensions(int[] dim) {
        for (int d = 0; d < this.numDimensions; ++d) {
            dim[d] = this.dim[d];
        }
    }

    public void getSteps(int[] step) {
        for (int d = 0; d < this.numDimensions; ++d) {
            step[d] = this.step[d];
        }
    }

    public int getCellId() {
        return this.cellId;
    }

    public void getOffset(int[] offset) {
        for (int i = 0; i < this.numDimensions; ++i) {
            offset[i] = this.offset[i];
        }
    }

    public final int getPosGlobal(int[] l) {
        int i = l[0] - this.offset[0];
        for (int d = 1; d < this.dim.length; ++d) {
            i += (l[d] - this.offset[d]) * this.step[d];
        }
        return i;
    }
}

