/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.CursorImpl;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class ArrayCursor<T extends Type<T>>
extends CursorImpl<T>
implements Cursor<T> {
    protected final T type;
    protected final Array<T, ?> container;
    protected final int maxIndex;

    public ArrayCursor(Array<T, ?> container, Image<T> image, T type) {
        super(container, image);
        this.type = type;
        this.container = container;
        this.maxIndex = container.getNumPixels() - 1;
        this.reset();
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        return this.type.getIndex() < this.maxIndex;
    }

    @Override
    public void fwd(long steps) {
        this.type.incIndex((int)steps);
    }

    @Override
    public void fwd() {
        this.type.incIndex();
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.type.updateIndex(this.maxIndex + 1);
    }

    @Override
    public void reset() {
        this.type.updateIndex(-1);
        this.type.updateContainer(this);
        this.isClosed = false;
    }

    public Array<T, ?> getStorageContainer() {
        return this.container;
    }

    @Override
    public int getStorageIndex() {
        return 0;
    }

    public String toString() {
        return this.type.toString();
    }
}

