/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.ifft;

import java.util.concurrent.ExecutorService;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.inplace.AbstractUnaryInplaceOp;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.fft2.FFTMethods;
import net.imglib2.type.numeric.ComplexType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;

@Plugin(type=Ops.Filter.IFFT.class)
public class IFFTMethodsOpI<C extends ComplexType<C>>
extends AbstractUnaryInplaceOp<RandomAccessibleInterval<C>>
implements Ops.Filter.IFFT,
Contingent {
    @Parameter
    ThreadService ts;

    @Override
    public void mutate(RandomAccessibleInterval<C> inout) {
        for (int d = inout.numDimensions() - 1; d >= 0; --d) {
            FFTMethods.complexToComplex(inout, (int)d, (boolean)false, (boolean)true, (ExecutorService)this.ts.getExecutorService());
        }
    }

    @Override
    public boolean conforms() {
        long[] paddedDimensions = new long[((RandomAccessibleInterval)this.in()).numDimensions()];
        boolean fastSizeConforms = false;
        FFTMethods.dimensionsComplexToComplexFast((Dimensions)((Dimensions)this.in()), (long[])paddedDimensions);
        if (FFTMethods.dimensionsEqual((Interval)((Interval)this.in()), (long[])paddedDimensions)) {
            fastSizeConforms = true;
        }
        boolean smallSizeConforms = false;
        FFTMethods.dimensionsComplexToComplexSmall((Dimensions)((Dimensions)this.in()), (long[])paddedDimensions);
        if (FFTMethods.dimensionsEqual((Interval)((Interval)this.in()), (long[])paddedDimensions)) {
            smallSizeConforms = true;
        }
        return fastSizeConforms || smallSizeConforms;
    }
}

