/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import Jama.Matrix;
import ij3d.Utils;

class VectorString3D {
    private double[] x;
    private double[] y;
    private double[] z;
    private double[] vx;
    private double[] vy;
    private double[] vz;
    private double[] rvx;
    private double[] rvy;
    private double[] rvz;
    private int length = 0;
    private double delta = 0.0;
    private double[][] dep;

    public VectorString3D(double[] x, double[] y, double[] z) {
        if (x.length != y.length || x.length != z.length) {
            throw new RuntimeException("x,y,z must have the same length.");
        }
        this.length = x.length;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void addDependent(double[] a) throws Exception {
        if (a.length != this.length) {
            throw new Exception("Dependent array must be of the same size as thevalue returned by length()");
        }
        if (null == this.dep) {
            this.dep = new double[1][];
            this.dep[0] = a;
        } else {
            double[][] dep2 = new double[this.dep.length + 1][];
            for (int i = 0; i < this.dep.length; ++i) {
                dep2[i] = this.dep[i];
            }
            dep2[this.dep.length] = a;
            this.dep = dep2;
        }
    }

    public double[] getDependent(int i) {
        return this.dep[i];
    }

    public double getAverageDelta() {
        double d = 0.0;
        for (int i = this.length - 1; i > 0; --i) {
            d += Math.sqrt(Math.pow(this.x[i] - this.x[i - 1], 2.0) + Math.pow(this.y[i] - this.y[i - 1], 2.0) + Math.pow(this.z[i] - this.z[i - 1], 2.0));
        }
        return d / (double)this.length;
    }

    public void resample(double delta) {
        if (Math.abs(delta - this.delta) < 1.0E-7) {
            return;
        }
        this.delta = delta;
        this.resample();
    }

    public final int length() {
        return this.length;
    }

    public double[] getPoints(int dim) {
        switch (dim) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        return null;
    }

    private boolean isClosed() {
        return false;
    }

    private final void recalculate(double[] w, int length, double sum_) {
        double sum = 0.0;
        for (int q = 0; q < length; ++q) {
            w[q] = w[q] / sum_;
            sum += w[q];
        }
        double error = 1.0 - sum;
        if (error < 0.0) {
            error = -error;
        }
        if (error < 0.005) {
            w[0] = w[0] + (1.0 - sum);
        } else if (sum > 1.0) {
            this.recalculate(w, length, sum);
        }
    }

    private void resample() {
        int last_i;
        double dist_ahead;
        int next_ahead;
        int MAX_AHEAD = 6;
        double MAX_DISTANCE = 2.5 * this.delta;
        ResamplingData r = new ResamplingData(this.length, this.dep);
        Vector vector = new Vector();
        r.setDeps(0, this.dep, new int[]{0}, new double[]{1.0}, 1);
        r.setP(0, this.x[0], this.y[0], this.z[0]);
        int i = 1;
        int j = 1;
        int prev_i = i;
        double[] w = new double[6];
        double[] distances = new double[6];
        Vector[] ve = new Vector[6];
        for (next_ahead = 0; next_ahead < 6; ++next_ahead) {
            ve[next_ahead] = new Vector();
        }
        int[] ahead = new int[6];
        try {
            while (prev_i <= i && prev_i <= i && (this.isClosed() || i != this.length - 1)) {
                int u;
                next_ahead = 0;
                for (int t = 0; t < 6; ++t) {
                    int s = i + t;
                    if (s >= this.length) {
                        if (!this.isClosed()) break;
                        s -= this.length;
                    }
                    if (!((dist_ahead = r.distance(j - 1, this.x[s], this.y[s], this.z[s])) < MAX_DISTANCE)) continue;
                    ahead[next_ahead] = s;
                    distances[next_ahead] = dist_ahead;
                    ++next_ahead;
                }
                if (0 == next_ahead) {
                    vector.set(this.x[i] - r.x(j - 1), this.y[i] - r.y(j - 1), this.z[i] - r.z(j - 1));
                    double dist1 = vector.length();
                    vector.setLength(this.delta);
                    vector.put(j, r);
                    if (null != this.dep) {
                        r.setDeps(j, this.dep, new int[]{i}, new double[]{1.0}, 1);
                    }
                    if (dist1 <= this.delta) {
                        for (u = i; u < this.length; ++u) {
                            double dist2 = Math.sqrt(Math.pow(this.x[u] - r.x(j - 1), 2.0) + Math.pow(this.y[u] - r.y(j - 1), 2.0) + Math.pow(this.z[u] - r.z(j - 1), 2.0));
                            if (!(dist2 > this.delta)) continue;
                            prev_i = i;
                            i = u;
                            break;
                        }
                    }
                } else {
                    w[0] = distances[0] / MAX_DISTANCE;
                    double largest = w[0];
                    for (u = 1; u < next_ahead; ++u) {
                        w[u] = 1.0 - distances[u] / MAX_DISTANCE;
                        if (!(w[u] > largest)) continue;
                        largest = w[u];
                    }
                    double sum = 0.0;
                    for (u = 0; u < next_ahead; ++u) {
                        w[u] = w[u] / largest;
                        sum += w[u];
                    }
                    if (sum < 1.0) {
                        w[0] = w[0] + (1.0 - sum);
                    } else {
                        this.recalculate(w, next_ahead, sum);
                    }
                    vector.set(0.0, 0.0, 0.0);
                    for (u = 0; u < next_ahead; ++u) {
                        int iu = i + u;
                        if (iu >= this.length) {
                            iu -= this.length;
                        }
                        ve[u].set(this.x[iu] - r.x(j - 1), this.y[iu] - r.y(j - 1), this.z[iu] - r.z(j - 1));
                        ve[u].setLength(w[u] * this.delta);
                        vector.add(ve[u], u == next_ahead - 1);
                    }
                    if (Math.abs(vector.length() - this.delta) > 1.0E-8) {
                        vector.setLength(this.delta);
                    }
                    vector.put(j, r);
                    if (null != this.dep) {
                        r.setDeps(j, this.dep, ahead, w, next_ahead);
                    }
                    int ii = i;
                    for (int k = 0; k < next_ahead; ++k) {
                        if (!(distances[k] > this.delta)) continue;
                        ii = ahead[k];
                        break;
                    }
                    prev_i = i;
                    if (i == ii) {
                        i = ahead[next_ahead - 1] + 1;
                        if (i >= this.length) {
                            i = this.isClosed() ? (i -= this.length) : this.length - 1;
                        }
                    } else {
                        i = ii;
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Some data: x,y,z .length = " + this.x.length + "," + this.y.length + "," + this.z.length + "\nj=" + j + ", i=" + i + ", prev_i=" + prev_i);
        }
        dist_ahead = r.distance(j - 1, this.x[this.length - 1], this.y[this.length - 1], this.z[this.length - 1]);
        int n = last_i = this.isClosed() ? 0 : this.length - 1;
        if (dist_ahead > this.delta * 1.2) {
            while (dist_ahead > this.delta * 1.2) {
                vector.set(this.x[last_i] - r.x(j - 1), this.y[last_i] - r.y(j - 1), this.z[last_i] - r.z(j - 1));
                vector.setLength(this.delta);
                vector.put(j, r);
                dist_ahead = r.distance(++j - 1, this.x[last_i], this.y[last_i], this.z[last_i]);
            }
        }
        r.put(this, j);
    }

    static /* synthetic */ double[] access$002(VectorString3D x0, double[] x1) {
        x0.x = x1;
        return x1;
    }

    static /* synthetic */ double[] access$102(VectorString3D x0, double[] x1) {
        x0.y = x1;
        return x1;
    }

    static /* synthetic */ double[] access$202(VectorString3D x0, double[] x1) {
        x0.z = x1;
        return x1;
    }

    static /* synthetic */ double[] access$302(VectorString3D x0, double[] x1) {
        x0.vx = x1;
        return x1;
    }

    static /* synthetic */ double[] access$402(VectorString3D x0, double[] x1) {
        x0.vy = x1;
        return x1;
    }

    static /* synthetic */ double[] access$502(VectorString3D x0, double[] x1) {
        x0.vz = x1;
        return x1;
    }

    static /* synthetic */ double[][] access$702(VectorString3D x0, double[][] x1) {
        x0.dep = x1;
        return x1;
    }

    private static class Vector {
        private double x;
        private double y;
        private double z;
        private double length;

        Vector() {
        }

        Vector(double x, double y, double z) {
            this.set(x, y, z);
        }

        Vector(Vector v) {
            this.x = v.x;
            this.y = v.y;
            this.z = v.z;
            this.length = v.length;
        }

        public final Object clone() {
            return new Vector(this);
        }

        final void set(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.length = this.computeLength();
        }

        final void normalize() {
            if (0.0 == this.length) {
                return;
            }
            if (Math.abs(1.0 - this.length) < 1.0E-8) {
                return;
            }
            this.x /= this.length;
            this.y /= this.length;
            this.z /= this.length;
            this.length = this.computeLength();
        }

        final double computeLength() {
            return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        final double length() {
            return this.length;
        }

        final void scale(double factor) {
            this.x *= factor;
            this.y *= factor;
            this.z *= factor;
            this.length = this.computeLength();
        }

        final void add(Vector v, boolean compute_length) {
            this.x += v.x;
            this.y += v.y;
            this.z += v.z;
            if (compute_length) {
                this.length = this.computeLength();
            }
        }

        final void setLength(double len) {
            this.normalize();
            this.scale(len);
        }

        final void put(int i, ResamplingData r) {
            r.setPV(i, r.x(i - 1) + this.x, r.y(i - 1) + this.y, r.z(i - 1) + this.z, this.x, this.y, this.z);
        }

        final void put(double[] d) {
            d[0] = this.x;
            d[1] = this.y;
            d[2] = this.z;
        }

        final void put(double[][] d, int col) {
            d[0][col] = this.x;
            d[1][col] = this.y;
            d[2][col] = this.z;
        }

        final void put(int i, double[] x, double[] y, double[] z) {
            x[i] = this.x;
            y[i] = this.y;
            z[i] = this.z;
        }

        final Vector getCrossProduct(Vector v) {
            return new Vector(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
        }

        final void setCrossProduct(Vector v, Vector w) {
            this.x = v.y * w.z - v.z * w.y;
            this.y = v.z * w.x - v.x * w.z;
            this.z = v.x * w.y - v.y * w.x;
        }

        final void changeRef(Vector v_delta, Vector v_i1, Vector v_new1) {
            Vector a2 = new Vector(v_new1);
            a2.normalize();
            Vector a1 = a2.getCrossProduct(v_i1);
            a1.normalize();
            Vector a3 = a2.getCrossProduct(a1);
            double[][] m1 = new double[3][3];
            a1.put(m1, 0);
            a2.put(m1, 1);
            a3.put(m1, 2);
            Matrix mat1 = new Matrix(m1);
            Vector b2 = new Vector(v_delta);
            b2.normalize();
            Vector b3 = a1.getCrossProduct(b2);
            double[][] m2 = new double[3][3];
            a1.put(m2, 0);
            b2.put(m2, 1);
            b3.put(m2, 2);
            Matrix mat2 = new Matrix(m2).transpose();
            Matrix R = mat1.times(mat2);
            Matrix mthis = new Matrix(new double[]{this.x, this.y, this.z}, 1);
            Matrix v_rot = R.transpose().times(mthis.transpose());
            double[][] arr = v_rot.getArray();
            this.x = arr[0][0];
            this.y = arr[1][0];
            this.z = arr[2][0];
        }
    }

    private static class ResamplingData {
        private double[] rx;
        private double[] ry;
        private double[] rz;
        private double[] vx;
        private double[] vy;
        private double[] vz;
        private double[][] dep;

        ResamplingData(int length, double[][] dep) {
            this.rx = new double[length];
            this.ry = new double[length];
            this.rz = new double[length];
            this.vx = new double[length];
            this.vy = new double[length];
            this.vz = new double[length];
            if (null != dep) {
                this.dep = new double[dep.length][length];
            }
        }

        final void setP(int i, double xval, double yval, double zval) {
            if (i >= this.rx.length) {
                this.resize(i + 10);
            }
            this.rx[i] = xval;
            this.ry[i] = yval;
            this.rz[i] = zval;
        }

        final void setV(int i, double xval, double yval, double zval) {
            if (i >= this.rx.length) {
                this.resize(i + 10);
            }
            this.vx[i] = xval;
            this.vy[i] = yval;
            this.vz[i] = zval;
        }

        final void setPV(int i, double rxval, double ryval, double rzval, double xval, double yval, double zval) {
            if (i >= this.rx.length) {
                this.resize(i + 10);
            }
            this.rx[i] = rxval;
            this.ry[i] = ryval;
            this.rz[i] = rzval;
            this.vx[i] = xval;
            this.vy[i] = yval;
            this.vz[i] = zval;
        }

        final void resize(int new_length) {
            this.rx = Utils.copy(this.rx, new_length);
            this.ry = Utils.copy(this.ry, new_length);
            this.rz = Utils.copy(this.rz, new_length);
            this.vx = Utils.copy(this.vx, new_length);
            this.vy = Utils.copy(this.vy, new_length);
            this.vz = Utils.copy(this.vz, new_length);
            if (null != this.dep) {
                double[][] dep2 = new double[this.dep.length][];
                for (int i = 0; i < this.dep.length; ++i) {
                    dep2[i] = Utils.copy(this.dep[i], new_length);
                }
                this.dep = dep2;
            }
        }

        final double x(int i) {
            return this.rx[i];
        }

        final double y(int i) {
            return this.ry[i];
        }

        final double z(int i) {
            return this.rz[i];
        }

        final double distance(int i, double x, double y, double z) {
            return Math.sqrt(Math.pow(x - this.rx[i], 2.0) + Math.pow(y - this.ry[i], 2.0) + Math.pow(z - this.rz[i], 2.0));
        }

        final void put(VectorString3D vs, int length) {
            VectorString3D.access$002(vs, Utils.copy(this.rx, length));
            VectorString3D.access$102(vs, Utils.copy(this.ry, length));
            VectorString3D.access$202(vs, Utils.copy(this.rz, length));
            VectorString3D.access$302(vs, Utils.copy(this.vx, length));
            VectorString3D.access$402(vs, Utils.copy(this.vy, length));
            VectorString3D.access$502(vs, Utils.copy(this.vz, length));
            vs.length = length;
            if (null != this.dep) {
                VectorString3D.access$702(vs, new double[this.dep.length][]);
                for (int i = 0; i < this.dep.length; ++i) {
                    ((VectorString3D)vs).dep[i] = Utils.copy(this.dep[i], length);
                }
            }
        }

        final void setDeps(int i, double[][] src_dep, int[] ahead, double[] weight, int len) {
            if (null == this.dep) {
                return;
            }
            if (i >= this.rx.length) {
                this.resize(i + 10);
            }
            for (int k = 0; k < this.dep.length; ++k) {
                for (int j = 0; j < len; ++j) {
                    double[] dArray = this.dep[k];
                    int n = i;
                    dArray[n] = dArray[n] + src_dep[k][ahead[j]] * weight[j];
                }
            }
        }
    }
}

