/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.io.DirectoryChooser;
import ij.io.OpenDialog;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class OctreeDialog {
    private String imagePath;
    private String imageDir;
    private String name;
    private boolean dirEmpty = false;
    private boolean canceled = false;

    public void showDialog() {
        GenericDialog gd = new GenericDialog("Add large volume");
        gd.addStringField("Name:", "", 10);
        gd.addMessage("Please specify the path to the image which you\nwant to display.\nIf you specify a directory with precomputed data\nbelow, you can leave this field empty");
        Panel p = new Panel(new FlowLayout());
        final TextField imagePathTF = new TextField(30);
        p.add(imagePathTF);
        Button b = new Button("...");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDialog od = new OpenDialog("Image path", null);
                String dir = od.getDirectory();
                String file = od.getFileName();
                if (dir != null && file != null) {
                    File f = new File(od.getDirectory(), od.getFileName());
                    imagePathTF.setText(f.getAbsolutePath());
                }
            }
        });
        p.add(b);
        gd.addPanel(p);
        gd.addMessage("For displaying large volumes, much data has to be\nprecomputed. Please specify an empty directory where\nthis data can be stored. If data for this image was\nprecomputed before, please specify the directory\ncontaining it here.");
        p = new Panel(new FlowLayout());
        final TextField imageDirTF = new TextField(30);
        p.add(imageDirTF);
        b = new Button("...");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryChooser dc = new DirectoryChooser("Data directory");
                String dir = dc.getDirectory();
                if (dir != null) {
                    imageDirTF.setText(dir);
                }
            }
        });
        p.add(b);
        gd.addPanel(p);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.canceled = true;
            return;
        }
        this.name = gd.getNextString();
        this.imagePath = imagePathTF.getText();
        this.imageDir = imageDirTF.getText();
    }

    public boolean checkUserInput() {
        if (this.canceled) {
            return false;
        }
        File f = new File(this.imageDir);
        if (!f.exists() && !f.mkdir()) {
            IJ.error((String)(this.imageDir + " does not exist and can't be created."));
            return false;
        }
        if (!f.isDirectory()) {
            IJ.error((String)(this.imageDir + " is not a directory."));
            return false;
        }
        this.dirEmpty = f.list().length == 0;
        f = new File(this.imagePath);
        if (!f.exists() && this.dirEmpty) {
            IJ.error((String)("Found an empty directory and " + this.imagePath + " does not exist"));
            return false;
        }
        if (!f.isFile() && this.dirEmpty) {
            IJ.error((String)("Found an empty directory and " + this.imagePath + " is not a valid file."));
            return false;
        }
        return true;
    }

    public boolean shouldCreateData() {
        return this.dirEmpty;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public String getImageDir() {
        return this.imageDir;
    }

    public String getName() {
        return this.name;
    }
}

