/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.FilterBuffer2;
import edu.mines.jtk.util.ArrayMath;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FilterBuffer2Test
extends TestCase {
    private static final float TOLERANCE = 1.1920929E-4f;

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(FilterBuffer2Test.class);
        TestRunner.run((Test)suite);
    }

    public void testLaplacian() {
        FilterBuffer2.Extrapolation[] exs;
        for (FilterBuffer2.Extrapolation ex : exs = new FilterBuffer2.Extrapolation[]{FilterBuffer2.Extrapolation.ZERO_VALUE, FilterBuffer2.Extrapolation.ZERO_SLOPE}) {
            float[][] xi = FilterBuffer2Test.impulsesInput();
            float[][] xc = FilterBuffer2Test.constantInput();
            float[][] xr = FilterBuffer2Test.randomInput();
            float[][][] xs = new float[][][]{xi, xc, xr};
            for (int itest = 0; itest < 3; ++itest) {
                float[][] x1 = xs[itest];
                float[][] x2 = ArrayMath.copy(x1);
                float[][] y1 = x1;
                float[][] y2 = x2;
                FilterBuffer2Test.computeLaplacian1(ex, x1, y1);
                FilterBuffer2Test.computeLaplacian2(ex, x2, y2);
                FilterBuffer2Test.assertEquals(y1, y2);
            }
        }
    }

    private static float[][] impulsesInput() {
        int n1 = 5;
        int n2 = 5;
        float[][] x = ArrayMath.zerofloat(n1, n2);
        x[n2 / 2][n1 / 2] = 1.0f;
        x[0][0] = 1.0f;
        x[0][n1 - 1] = 1.0f;
        x[n2 - 1][0] = 1.0f;
        x[n2 - 1][n1 - 1] = 1.0f;
        return x;
    }

    private static float[][] constantInput() {
        int n1 = 5;
        int n2 = 5;
        return ArrayMath.fillfloat(1.0f, n1, n2);
    }

    private static float[][] randomInput() {
        int n1 = 5;
        int n2 = 5;
        return ArrayMath.randfloat(n1, n2);
    }

    private static void computeLaplacian1(FilterBuffer2.Extrapolation ex, float[][] x, float[][] y) {
        int n1 = x[0].length;
        int n2 = x.length;
        FilterBuffer2 fbx = new FilterBuffer2(1, 1, 1, 1, x);
        fbx.setExtrapolation(ex);
        for (int i2 = 0; i2 < n2; ++i2) {
            float[] xm = fbx.get(i2 - 1);
            float[] x0 = fbx.get(i2);
            float[] xp = fbx.get(i2 + 1);
            float[] y0 = y[i2];
            int i1 = 0;
            int j1 = 1;
            while (i1 < n1) {
                y0[i1] = xm[j1] + xp[j1] + x0[j1 - 1] + x0[j1 + 1] - 4.0f * x0[j1];
                ++i1;
                ++j1;
            }
        }
    }

    private static void computeLaplacian2(FilterBuffer2.Extrapolation ex, float[][] x, float[][] y) {
        int n1 = x[0].length;
        int n2 = x.length;
        FilterBuffer2 fbx = new FilterBuffer2(1, 1, 1, 1, x);
        FilterBuffer2 fby = new FilterBuffer2(1, 1, 1, 1, y);
        fbx.setExtrapolation(ex);
        fby.setExtrapolation(ex);
        fbx.setMode(FilterBuffer2.Mode.INPUT);
        fby.setMode(FilterBuffer2.Mode.OUTPUT);
        for (int i2 = 0; i2 <= n2; ++i2) {
            float[] xm = fbx.get(i2 - 1);
            float[] x0 = fbx.get(i2);
            float[] ym = fby.get(i2 - 1);
            float[] y0 = fby.get(i2);
            int j1 = 1;
            for (int i1 = 0; i1 <= n1; ++i1) {
                float d1 = x0[j1] - x0[j1 - 1];
                float d2 = x0[j1] - xm[j1];
                int n = j1;
                y0[n] = y0[n] - (d1 + d2);
                int n3 = j1 - 1;
                y0[n3] = y0[n3] + d1;
                int n4 = j1++;
                ym[n4] = ym[n4] + d2;
            }
        }
        fby.flush();
    }

    private static void exampleBilaplacian() {
        int n1 = 5;
        int n2 = 5;
        float[][] x = ArrayMath.zerofloat(n1, n2);
        x[n2 / 2][n1 / 2] = 1.0f;
        ArrayMath.dump(x);
        float[][] y = x;
        FilterBuffer2 fbx = new FilterBuffer2(1, 1, 1, 1, x);
        FilterBuffer2 fby = new FilterBuffer2(1, 1, 1, 1, y);
        fbx.setExtrapolation(FilterBuffer2.Extrapolation.ZERO_SLOPE);
        fbx.setMode(FilterBuffer2.Mode.INPUT);
        fby.setMode(FilterBuffer2.Mode.OUTPUT);
        for (int i2 = 0; i2 < n2; ++i2) {
            float[] x2m = fbx.get(i2 - 1);
            float[] x20 = fbx.get(i2);
            float[] x2p = fbx.get(i2 + 1);
            float[] y2m = fby.get(i2 - 1);
            float[] y20 = fby.get(i2);
            float[] y2p = fby.get(i2 + 1);
            int j1 = 1;
            for (int i1 = 0; i1 < n1; ++i1) {
                float t = 0.0f;
                t += x2m[j1];
                t += x2p[j1];
                t += x20[j1 - 1];
                t += x20[j1 + 1];
                int n = j1;
                y20[n] = y20[n] - (t -= x20[j1] * 4.0f) * 4.0f;
                int n3 = j1 + 1;
                y20[n3] = y20[n3] + t;
                int n4 = j1 - 1;
                y20[n4] = y20[n4] + t;
                int n5 = j1;
                y2p[n5] = y2p[n5] + t;
                int n6 = j1++;
                y2m[n6] = y2m[n6] + t;
            }
        }
        fby.flush();
        ArrayMath.dump(y);
    }

    private static void trace(String s) {
        System.out.println(s);
    }

    private static void assertEquals(float[] a, float[] b) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            FilterBuffer2Test.assertEquals((float)a[i], (float)b[i], (float)1.1920929E-4f);
        }
    }

    private static void assertEquals(float[][] a, float[][] b) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            FilterBuffer2Test.assertEquals(a[i], b[i]);
        }
    }
}

