/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Vector3;

public class Plane {
    private double _a;
    private double _b;
    private double _c;
    private double _d;

    public Plane(double a, double b, double c, double d) {
        this.set(a, b, c, d);
    }

    public Plane(Point3 p, Vector3 n) {
        this.set(n.x, n.y, n.z, -(n.x * p.x + n.y * p.y + n.z * p.z));
    }

    public Plane(Plane p) {
        this._a = p._a;
        this._b = p._b;
        this._c = p._c;
        this._d = p._d;
    }

    public void set(double a, double b, double c, double d) {
        this._a = a;
        this._b = b;
        this._c = c;
        this._d = d;
        this.normalize();
    }

    public double getA() {
        return this._a;
    }

    public double getB() {
        return this._b;
    }

    public double getC() {
        return this._c;
    }

    public double getD() {
        return this._d;
    }

    public Vector3 getNormal() {
        return new Vector3(this._a, this._b, this._c);
    }

    public double distanceTo(double x, double y, double z) {
        return this._a * x + this._b * y + this._c * z + this._d;
    }

    public double distanceTo(Point3 p) {
        return this.distanceTo(p.x, p.y, p.z);
    }

    public void transform(Matrix44 m) {
        this.transformWithInverse(m.inverse());
    }

    public void transformWithInverse(Matrix44 mi) {
        double[] m = mi.m;
        double a = m[0] * this._a + m[1] * this._b + m[2] * this._c + m[3] * this._d;
        double b = m[4] * this._a + m[5] * this._b + m[6] * this._c + m[7] * this._d;
        double c = m[8] * this._a + m[9] * this._b + m[10] * this._c + m[11] * this._d;
        double d = m[12] * this._a + m[13] * this._b + m[14] * this._c + m[15] * this._d;
        this.set(a, b, c, d);
    }

    public String toString() {
        return "(" + this._a + "," + this._b + "," + this._c + "," + this._d + ")";
    }

    private void normalize() {
        double s = 1.0 / Math.sqrt(this._a * this._a + this._b * this._b + this._c * this._c);
        this._a *= s;
        this._b *= s;
        this._c *= s;
        this._d *= s;
    }
}

