/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij.export;

import bdv.ij.export.SpimRegistrationSequence;
import bdv.ij.export.imgloader.FusionImageLoader;
import bdv.spimdata.SequenceDescriptionMinimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.real.FloatType;

@Deprecated
public class FusionResult {
    private final SequenceDescriptionMinimal desc;
    private final ViewRegistrations regs;

    public static FusionResult create(SpimRegistrationSequence spimseq, String filepath, String filepattern, int numSlices, double sliceValueMin, double sliceValueMax, Map<Integer, AffineTransform3D> perTimePointFusionTransforms) {
        ArrayList<Integer> channels = new ArrayList<Integer>();
        for (BasicViewSetup setup : spimseq.getSequenceDescription().getViewSetupsOrdered()) {
            int channel = ((Channel)setup.getAttribute(Channel.class)).getId();
            if (channels.contains(channel)) continue;
            channels.add(channel);
        }
        TimePoints timepoints = spimseq.getSequenceDescription().getTimePoints();
        return new FusionResult(filepath, filepattern, channels, timepoints, numSlices, sliceValueMin, sliceValueMax, perTimePointFusionTransforms);
    }

    public FusionResult(String filepath, String filepattern, TimePoints timepoints, int numSlices, double sliceValueMin, double sliceValueMax, Map<Integer, AffineTransform3D> perTimePointFusionTransforms) {
        HashMap<Integer, Integer> setupIdToChannelId = new HashMap<Integer, Integer>();
        setupIdToChannelId.put(0, 0);
        FusionImageLoader<FloatType> fusionLoader = new FusionImageLoader<FloatType>(filepath + "/" + filepattern, setupIdToChannelId, numSlices, new FusionImageLoader.Gray32ImagePlusLoader(), sliceValueMin, sliceValueMax);
        boolean setupId = false;
        String name = "fused";
        int timepointId = ((TimePoint)timepoints.getTimePointsOrdered().get(0)).getId();
        Dimensions size = fusionLoader.getSetupImgLoader(0).getImageSize(timepointId);
        VoxelDimensions voxelSize = fusionLoader.getSetupImgLoader(0).getVoxelSize(timepointId);
        BasicViewSetup setup = new BasicViewSetup(0, "fused", size, voxelSize);
        this.desc = new SequenceDescriptionMinimal(timepoints, (Map)Entity.idMap(Arrays.asList(setup)), fusionLoader, null);
        ArrayList<ViewRegistration> registrations = new ArrayList<ViewRegistration>();
        for (TimePoint timepoint : timepoints.getTimePointsOrdered()) {
            registrations.add(new ViewRegistration(timepoint.getId(), 0, perTimePointFusionTransforms.get(timepoint.getId())));
        }
        this.regs = new ViewRegistrations(registrations);
    }

    public FusionResult(String filepath, String filepattern, List<Integer> channels, TimePoints timepoints, int numSlices, double sliceValueMin, double sliceValueMax, Map<Integer, AffineTransform3D> perTimePointFusionTransforms) {
        HashMap<Integer, Integer> setupIdToChannelId = new HashMap<Integer, Integer>();
        for (int setupId = 0; setupId < channels.size(); ++setupId) {
            setupIdToChannelId.put(setupId, channels.get(setupId));
        }
        FusionImageLoader<FloatType> fusionLoader = new FusionImageLoader<FloatType>(filepath + "/" + filepattern, setupIdToChannelId, numSlices, new FusionImageLoader.Gray32ImagePlusLoader(), sliceValueMin, sliceValueMax);
        ArrayList<BasicViewSetup> setups = new ArrayList<BasicViewSetup>();
        for (int setupId = 0; setupId < channels.size(); ++setupId) {
            String name = "fused c " + channels.get(setupId);
            int timepointId = ((TimePoint)timepoints.getTimePointsOrdered().get(0)).getId();
            Dimensions size = fusionLoader.getSetupImgLoader(setupId).getImageSize(timepointId);
            VoxelDimensions voxelSize = fusionLoader.getSetupImgLoader(setupId).getVoxelSize(timepointId);
            BasicViewSetup setup = new BasicViewSetup(setupId, name, size, voxelSize);
            setup.setAttribute((Entity)new Channel(channels.get(setupId).intValue()));
            setups.add(setup);
        }
        this.desc = new SequenceDescriptionMinimal(timepoints, (Map)Entity.idMap(setups), fusionLoader, null);
        ArrayList<ViewRegistration> registrations = new ArrayList<ViewRegistration>();
        for (TimePoint timepoint : timepoints.getTimePointsOrdered()) {
            for (BasicViewSetup setup : setups) {
                registrations.add(new ViewRegistration(timepoint.getId(), setup.getId(), perTimePointFusionTransforms.get(timepoint.getId())));
            }
        }
        this.regs = new ViewRegistrations(registrations);
    }

    public SequenceDescriptionMinimal getSequenceDescription() {
        return this.desc;
    }

    public ViewRegistrations getViewRegistrations() {
        return this.regs;
    }
}

