/*
 * Decompiled with CFR 0.152.
 */
package org.siox.example;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.JScrollPane;
import org.siox.SioxSegmentator;
import org.siox.example.ImagePane;
import org.siox.example.JRuler;

public class ScrollDisplay
extends JScrollPane {
    public static final int NO_RULER = -1;
    public static final int EMPTY_RULER = 0;
    public static final int METRIC_RULER = 1;
    public static final int INCH_RULER = 2;
    public static final int PIXEL_RULER = 3;
    private final ImagePane imagePane;
    protected final SioxSegmentator siox;
    private final int[] imgData;
    private final float[] confMatrix;
    private JRuler colJRuler;
    private JRuler rowJRuler;
    private JRuler innerColJRuler;
    private JRuler innerRowJRuler;
    private int rulerMode = -1;

    public ScrollDisplay(BufferedImage image) {
        super(22, 32);
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        BufferedImage img = new BufferedImage(imgWidth, imgHeight, 2);
        img.getGraphics().drawImage(image, 0, 0, null);
        this.imagePane = new ImagePane(img);
        this.setViewportView(this.imagePane);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ScrollDisplay.this.validateRulers();
                ScrollDisplay.this.imagePane.repaint();
            }
        });
        this.siox = new SioxSegmentator(imgWidth, imgHeight, null);
        this.confMatrix = new float[imgWidth * imgHeight];
        this.imgData = new int[imgWidth * imgHeight];
        img.getRGB(0, 0, imgWidth, imgHeight, this.imgData, 0, imgWidth);
        Arrays.fill(this.confMatrix, 0.0f);
    }

    public boolean setRuler(int type) {
        this.rulerMode = type;
        Dimension iSize = new Dimension(this.imagePane.getImageWidth(), this.imagePane.getImageHeight());
        this.getViewport().setPreferredSize(iSize);
        if (type == -1) {
            boolean changed = this.colJRuler != null;
            this.colJRuler = null;
            this.setColumnHeaderView(null);
            this.rowJRuler = null;
            this.setRowHeaderView(null);
            this.imagePane.setTopIcon(null);
            this.imagePane.setLeftIcon(null);
            return changed;
        }
        int outerType = this.imagePane.getZoomScale() < 0.0 ? 0 : type;
        JRuler cols = this.colJRuler;
        JRuler rows = this.rowJRuler;
        JRuler iCols = this.innerColJRuler;
        JRuler iRows = this.innerRowJRuler;
        if (cols == null || rows == null || iCols == null || iRows == null) {
            JRuler c = new JRuler(this, 0, outerType, 1000);
            JRuler ic = new JRuler(this, 0, type, 1000);
            JRuler r = new JRuler(this, 1, outerType, 1000);
            JRuler ir = new JRuler(this, 1, type, 1000);
            this.colJRuler = c;
            this.setColumnHeaderView(this.colJRuler);
            this.rowJRuler = r;
            this.setRowHeaderView(this.rowJRuler);
            this.innerColJRuler = ic;
            this.imagePane.setTopIcon(this.innerColJRuler);
            this.innerRowJRuler = ir;
            this.imagePane.setLeftIcon(this.innerRowJRuler);
            this.validateRulers();
            return true;
        }
        this.validateRulers();
        return false;
    }

    public void applySelection(float confidenceVal) {
        Area area = this.imagePane.getSelectionArea();
        if (area != null) {
            this.setConf(area, confidenceVal);
            this.imagePane.updateImage(this.imgData, this.confMatrix);
        }
    }

    public void setConf(float confVal) {
        Arrays.fill(this.confMatrix, confVal);
    }

    public void setConf(Area area, float confVal) {
        Rectangle r = area.getBounds();
        int w = this.imagePane.getImageWidth();
        int h = this.imagePane.getImageHeight();
        int x0 = Math.max(0, r.x);
        int y0 = Math.max(0, r.y);
        int xTo = Math.min(w - 1, r.x + r.width);
        int yTo = Math.min(h - 1, r.y + r.height);
        for (int y = y0; y < yTo; ++y) {
            for (int x = x0; x < xTo; ++x) {
                if (!area.contains(x, y)) continue;
                this.confMatrix[y * w + x] = confVal;
            }
        }
        this.imagePane.updateImage(this.imgData, this.confMatrix);
    }

    public void segmentate(int smoothes, boolean multipart) throws IllegalStateException {
        this.siox.segmentate(this.imgData, this.confMatrix, smoothes, multipart ? 4.0 : 0.0);
        this.imagePane.updateImage(this.imgData, this.confMatrix);
    }

    public void subpixelRefine(Area area, boolean add, float thresh) throws IllegalStateException {
        String opName = add ? "add" : "subtract";
        this.siox.subpixelRefine(area, opName, thresh, this.confMatrix);
        this.imagePane.updateImage(this.imgData, this.confMatrix);
    }

    public ImagePane getImagePane() {
        return this.imagePane;
    }

    public void setZoom(int zoomFactor, boolean zoomIn) {
        int vpW = this.viewport.getWidth();
        int vpH = this.viewport.getHeight();
        Point oldOff = this.viewport.getViewPosition();
        int cx = this.imagePane.unzoomX(oldOff.x + vpW / 2);
        int cy = this.imagePane.unzoomY(oldOff.y + vpH / 2);
        this.imagePane.setZoom(zoomFactor, zoomIn);
        double scale = this.imagePane.getZoomScale();
        int maxOffX = this.imagePane.zoomX(this.imagePane.getImageWidth()) - vpW;
        int maxOffY = this.imagePane.zoomY(this.imagePane.getImageHeight()) - vpH;
        int offX = Math.max(0, Math.min(maxOffX, this.imagePane.zoomX(cx) - vpW / 2));
        int offY = Math.max(0, Math.min(maxOffY, this.imagePane.zoomY(cy) - vpH / 2));
        int rulerOffX = (int)(((double)vpW - (double)this.imagePane.getImageWidth() * scale) / 2.0 + 0.5);
        int rulerOffY = (int)(((double)vpH - (double)this.imagePane.getImageHeight() * scale) / 2.0 + 0.5);
        this.viewport.setViewPosition(new Point(offX, offY));
        this.validateRulers();
        this.repaint();
    }

    private void validateRulers() {
        int rm = this.rulerMode;
        JRuler cols = this.colJRuler;
        JRuler rows = this.rowJRuler;
        JRuler iCols = this.innerColJRuler;
        JRuler iRows = this.innerRowJRuler;
        if (rm == -1 || cols == null || rows == null || iCols == null || iRows == null) {
            return;
        }
        double scale = this.imagePane.getZoomScale();
        if (this.imagePane.getInnerXMargin() < iRows.getIconWidth()) {
            rows.setUnit(rm);
            iRows.setUnit(0);
        } else {
            rows.setUnit(0);
            iRows.setUnit(rm);
        }
        if (this.imagePane.getInnerYMargin() < iCols.getIconHeight()) {
            cols.setUnit(rm);
            iCols.setUnit(0);
        } else {
            cols.setUnit(0);
            iCols.setUnit(rm);
        }
    }
}

