/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.generic.sequence;

import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.base.XmlIoEntity;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import org.jdom2.Content;
import org.jdom2.Element;

public class XmlIoBasicViewSetup<T extends BasicViewSetup>
extends XmlIoEntity<T> {
    protected HashMap<String, HashMap<Integer, ? extends Entity>> attributeMap;

    public XmlIoBasicViewSetup(Class<T> klass) {
        super("ViewSetup", klass);
        this.handledTags.add("name");
        this.handledTags.add("size");
        this.handledTags.add("voxelSize");
        this.handledTags.add("attributes");
    }

    public void setAttributeMap(HashMap<String, HashMap<Integer, ? extends Entity>> attributeMap) {
        this.attributeMap = attributeMap;
    }

    @Override
    public Element toXml(T setup) {
        Map<String, Entity> attributes;
        Element elem = super.toXml(setup);
        if (((BasicViewSetup)setup).hasName()) {
            elem.addContent((Content)XmlHelpers.textElement("name", ((BasicViewSetup)setup).getName()));
        }
        if (((BasicViewSetup)setup).hasSize()) {
            elem.addContent((Content)XmlHelpers.dimensionsElement("size", ((BasicViewSetup)setup).getSize()));
        }
        if (((BasicViewSetup)setup).hasVoxelSize()) {
            elem.addContent((Content)XmlIoBasicViewSetup.voxelDimensionsElement("voxelSize", ((BasicViewSetup)setup).getVoxelSize()));
        }
        if (!(attributes = ((BasicViewSetup)setup).getAttributes()).isEmpty()) {
            Element as = new Element("attributes");
            for (Map.Entry<String, Entity> entry : attributes.entrySet()) {
                as.addContent((Content)XmlHelpers.intElement(entry.getKey(), entry.getValue().getId()));
            }
            elem.addContent((Content)as);
        }
        return elem;
    }

    @Override
    public T fromXml(Element elem) throws SpimDataException {
        BasicViewSetup setup = (BasicViewSetup)super.fromXml(elem);
        setup.setName(XmlHelpers.getText(elem, "name", null));
        setup.setSize(XmlHelpers.getDimensions(elem, "size", null));
        setup.setVoxelSize(XmlIoBasicViewSetup.getVoxelDimensions(elem, "voxelSize", null));
        Element as = elem.getChild("attributes");
        HashMap<String, Entity> attributes = new HashMap<String, Entity>();
        if (as != null) {
            for (Element a : as.getChildren()) {
                String name = a.getName();
                int id = Integer.parseInt(a.getTextTrim());
                Entity attribute = this.attributeMap.get(name).get(id);
                attributes.put(name, attribute);
            }
        }
        setup.setAttributes(attributes);
        return (T)setup;
    }

    protected static Element voxelDimensionsElement(String name, VoxelDimensions voxelSize) {
        Element elem = new Element(name);
        double[] array = new double[voxelSize.numDimensions()];
        voxelSize.dimensions(array);
        elem.addContent((Content)XmlHelpers.textElement("unit", voxelSize.unit()));
        elem.addContent((Content)XmlHelpers.doubleArrayElement("size", array));
        return elem;
    }

    protected static VoxelDimensions getVoxelDimensions(Element parent, String name) {
        Element elem = parent.getChild(name);
        String unit = XmlHelpers.getText(elem, "unit");
        double[] size = XmlHelpers.getDoubleArray(elem, "size");
        return new FinalVoxelDimensions(unit, size);
    }

    protected static VoxelDimensions getVoxelDimensions(Element parent, String name, VoxelDimensions defaultValue) {
        return parent.getChild(name) == null ? defaultValue : XmlIoBasicViewSetup.getVoxelDimensions(parent, name);
    }
}

