/*
 * Decompiled with CFR 0.152.
 */
package histogram2;

public class PiecewiseLinearCdf {
    private int K;
    private int[] iArr;
    private double[] pArr;

    public PiecewiseLinearCdf(int K, int[] ik, double[] Pk) {
        this.K = K;
        int N = ik.length;
        this.iArr = new int[N + 2];
        this.pArr = new double[N + 2];
        this.iArr[0] = -1;
        this.pArr[0] = 0.0;
        for (int i = 0; i < N; ++i) {
            this.iArr[i + 1] = ik[i];
            this.pArr[i + 1] = Pk[i];
        }
        this.iArr[N + 1] = K - 1;
        this.pArr[N + 1] = 1.0;
    }

    double getCdf(int i) {
        if (i < 0) {
            return 0.0;
        }
        if (i >= this.K - 1) {
            return 1.0;
        }
        int s = 0;
        int N = this.iArr.length - 1;
        int j = 0;
        while (j <= N && this.iArr[j] <= i) {
            s = j++;
        }
        return this.pArr[s] + (double)(i - this.iArr[s]) * ((this.pArr[s + 1] - this.pArr[s]) / (double)(this.iArr[s + 1] - this.iArr[s]));
    }

    int getInverseCdf(double z) {
        if (z < this.getCdf(0)) {
            return 0;
        }
        if (z >= 1.0) {
            return this.K - 1;
        }
        int r = 0;
        int N = this.iArr.length - 1;
        int j = 0;
        while (j <= N && this.pArr[j] <= z) {
            r = j++;
        }
        return (int)Math.round((double)this.iArr[r] + (z - this.pArr[r]) * ((double)(this.iArr[r + 1] - this.iArr[r]) / (this.pArr[r + 1] - this.pArr[r])));
    }

    public double[] getPdf() {
        double[] prob = new double[this.K];
        prob[0] = this.getCdf(0);
        for (int i = 1; i < this.K; ++i) {
            prob[i] = this.getCdf(i) - this.getCdf(i - 1);
        }
        return prob;
    }
}

