/*
 * Decompiled with CFR 0.152.
 */
package histogram2;

public class Util {
    static int[] makeGaussianHistogram() {
        return Util.makeGaussianHistogram(128.0, 50.0);
    }

    public static int[] makeGaussianHistogram(double mean, double sigma) {
        int[] h = new int[256];
        double sigma2 = 2.0 * sigma * sigma;
        for (int i = 0; i < h.length; ++i) {
            double x = mean - (double)i;
            double g = Math.exp(-(x * x) / sigma2) / sigma;
            h[i] = (int)Math.round(10000.0 * g);
        }
        return h;
    }

    public static double[] normalizeHistogram(double[] h) {
        double max = h[0];
        for (int i = 0; i < h.length; ++i) {
            if (!(h[i] > max)) continue;
            max = h[i];
        }
        if (max == 0.0) {
            return null;
        }
        double[] hn = new double[h.length];
        double s = 1.0 / max;
        for (int i = 0; i < h.length; ++i) {
            hn[i] = s * h[i];
        }
        return hn;
    }

    public static double[] normalizeHistogram(int[] h) {
        int max = h[0];
        for (int i = 0; i < h.length; ++i) {
            if (h[i] <= max) continue;
            max = h[i];
        }
        if (max == 0) {
            return null;
        }
        double[] hn = new double[h.length];
        double s = 1.0 / (double)max;
        for (int i = 0; i < h.length; ++i) {
            hn[i] = s * (double)h[i];
        }
        return hn;
    }

    public static double[] Cdf(int[] h) {
        int K = h.length;
        int n = 0;
        for (int i = 0; i < K; ++i) {
            n += h[i];
        }
        double[] P = new double[K];
        int c = h[0];
        P[0] = (double)c / (double)n;
        for (int i = 1; i < K; ++i) {
            P[i] = (double)(c += h[i]) / (double)n;
        }
        return P;
    }

    static double[] Pdf(int[] h) {
        int K = h.length;
        int n = 0;
        for (int i = 0; i < K; ++i) {
            n += h[i];
        }
        double[] p = new double[K];
        for (int i = 0; i < h.length; ++i) {
            p[i] = (double)h[i] / (double)n;
        }
        return p;
    }
}

