/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.loaders.lw3d;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.scijava.java3d.Behavior;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.internal.J3dUtilsI18N;
import org.scijava.java3d.loaders.IncorrectFormatException;
import org.scijava.java3d.loaders.ParsingErrorException;
import org.scijava.java3d.loaders.lw3d.LwsEnvelopeFrame;
import org.scijava.java3d.loaders.lw3d.TextfileParser;

class LwsEnvelope
extends TextfileParser {
    String name;
    LwsEnvelopeFrame[] frames;
    int numFrames = 0;
    int numChannels;
    boolean loop;
    float totalTime;
    int totalFrames;
    Behavior behaviors;

    LwsEnvelope(StreamTokenizer st, int frames, float time) {
        this.totalTime = time;
        this.totalFrames = frames;
        this.name = this.getName(st);
        this.getEnvelope(st);
    }

    void getEnvelope(StreamTokenizer st) throws IncorrectFormatException, ParsingErrorException {
        this.debugOutputLn(1, "getEnvelope()");
        this.numChannels = (int)this.getNumber(st);
        if (this.numChannels != 1) {
            throw new IncorrectFormatException(J3dUtilsI18N.getString("LwsEnvelope0"));
        }
        this.debugOutputLn(8, "got channels");
        this.numFrames = (int)this.getNumber(st);
        this.frames = new LwsEnvelopeFrame[this.numFrames];
        this.debugOutputLn(2, "got frames" + this.numFrames);
        for (int i = 0; i < this.numFrames; ++i) {
            this.frames[i] = new LwsEnvelopeFrame(st);
        }
        this.debugOutput(8, "got all frames");
        try {
            st.nextToken();
            while (!this.isCurrentToken(st, "EndBehavior")) {
                st.nextToken();
            }
        }
        catch (IOException e) {
            throw new ParsingErrorException(e.getMessage());
        }
        int repeatVal = (int)this.getNumber(st);
        this.loop = repeatVal != 1;
    }

    void createJava3dBehaviors(TransformGroup target) {
        this.behaviors = null;
    }

    Behavior getBehaviors() {
        return this.behaviors;
    }

    LwsEnvelopeFrame getFirstFrame() {
        if (this.numFrames > 0) {
            return this.frames[0];
        }
        return null;
    }

    void printVals() {
        this.debugOutputLn(2, "   name = " + this.name);
        this.debugOutputLn(2, "   numChannels = " + this.numChannels);
        this.debugOutputLn(2, "   numFrames = " + this.numFrames);
        this.debugOutputLn(2, "   loop = " + this.loop);
        for (int i = 0; i < this.numFrames; ++i) {
            this.debugOutputLn(2, "       FRAME " + i);
            this.frames[i].printVals();
        }
    }
}

