/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply.util;

import org.smurn.jply.Element;
import org.smurn.jply.util.Axis;
import org.smurn.jply.util.RectBounds;
import org.smurn.jply.util.TexGenStrategy;

class PlanarTexGenStrategy
implements TexGenStrategy {
    private final Axis uAxis;
    private final Axis vAxis;

    PlanarTexGenStrategy(Axis uAxis, Axis vAxis) {
        if (uAxis == null) {
            throw new NullPointerException("uAxis must not be null.");
        }
        if (vAxis == null) {
            throw new NullPointerException("vAxis must not be null.");
        }
        this.uAxis = uAxis;
        this.vAxis = vAxis;
    }

    @Override
    public void generateCoordinates(Element element, RectBounds bounds) {
        if (element == null || bounds == null) {
            throw new NullPointerException();
        }
        double x = element.getDouble("x");
        double y = element.getDouble("y");
        double z = element.getDouble("z");
        x = (x - bounds.getMinX()) / (bounds.getMaxX() - bounds.getMinX());
        y = (y - bounds.getMinY()) / (bounds.getMaxY() - bounds.getMinY());
        z = (z - bounds.getMinZ()) / (bounds.getMaxZ() - bounds.getMinZ());
        double u = 0.0;
        switch (this.uAxis) {
            case X: {
                u = x;
                break;
            }
            case Y: {
                u = y;
                break;
            }
            case Z: {
                u = z;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid axis.");
            }
        }
        double v = 0.0;
        switch (this.vAxis) {
            case X: {
                v = x;
                break;
            }
            case Y: {
                v = y;
                break;
            }
            case Z: {
                v = z;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid axis.");
            }
        }
        element.setDouble("u", u);
        element.setDouble("v", v);
    }
}

