/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.balloonSegmentation.utils;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import Jama.SingularValueDecomposition;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Polygon;
import java.util.Vector;
import sc.fiji.balloonSegmentation.structure.Balloon;
import sc.fiji.balloonSegmentation.structure.BalloonPopulation;
import sc.fiji.balloonSegmentation.structure.BalloonSequence;
import sc.fiji.balloonSegmentation.utils.RandPermutation;

public class Kinematics {
    BalloonSequence pop_sequence;
    BalloonPopulation[] PopList;
    int Nseq = 0;

    public Kinematics(BalloonSequence seq) {
        this.pop_sequence = seq;
        this.PopList = seq.PopList;
        this.Nseq = seq.N;
    }

    public void KinematicAnalysis() {
        IJ.log((String)"Time \t ID \t n_generation \t id_mother \t area");
        for (int i = 1; i < this.Nseq; ++i) {
            BalloonPopulation pop = this.PopList[i];
            BalloonPopulation pop0 = this.PopList[i - 1];
            if (!(pop.N > 0 & pop0.N > 0)) continue;
            this.lineage(pop0, pop, i);
            this.Kinematics_inertia(pop0, pop);
        }
        this.smooth_straining();
        this.KinematicOutput();
        this.lineageOutput();
    }

    public void smooth_straining() {
        int i;
        int n_balloon = this.PopList[this.Nseq - 1].BallList.size();
        int[][] ball_trajectory = new int[n_balloon *= 3][this.Nseq];
        for (i = 0; i < n_balloon; ++i) {
            for (int j = 0; j < this.Nseq; ++j) {
                int kk = 0;
                boolean add = false;
                for (int k = 0; k < this.PopList[j].BallList.size(); ++k) {
                    kk = (k + i) % this.PopList[j].BallList.size();
                    Balloon bal = this.PopList[j].BallList.get(kk);
                    if (bal.id != i) continue;
                    add = true;
                    break;
                }
                ball_trajectory[i][j] = add ? kk : -1;
            }
        }
        for (i = 0; i < n_balloon; ++i) {
            int t;
            double[] sig_vol = new double[this.Nseq];
            double[] vol = new double[this.Nseq];
            Matrix[] StrainVector = new Matrix[this.Nseq];
            double[] Sxx = new double[this.Nseq];
            double[] Syy = new double[this.Nseq];
            for (t = 0; t < this.Nseq; ++t) {
                if (ball_trajectory[i][t] <= 0) continue;
                Balloon bal = this.PopList[t].BallList.get(ball_trajectory[i][t]);
                sig_vol[t] = bal.sig_vol;
                StrainVector[t] = bal.StrainVector;
                Sxx[t] = bal.StrainValues[0];
                Syy[t] = bal.StrainValues[1];
                vol[t] = bal.area;
            }
            for (t = 1; t < this.Nseq - 1; ++t) {
                if (ball_trajectory[i][t + 1] > -1 & ball_trajectory[i][t] > -1 & vol[t + 1] / vol[t] < 0.75) {
                    Balloon bal0 = this.PopList[t].BallList.get(ball_trajectory[i][t]);
                    Balloon bal1 = this.PopList[t + 1].BallList.get(ball_trajectory[i][t + 1]);
                    bal1.StrainVector = bal0.StrainVector;
                    bal1.StrainValues = bal0.StrainValues;
                    bal1.sig_vol = bal0.sig_vol;
                }
                if (!(ball_trajectory[i][t] > -1 & ball_trajectory[i][t + 1] > -1 & ball_trajectory[i][t - 1] > 0)) continue;
                Balloon balloon = this.PopList[t].BallList.get(ball_trajectory[i][t]);
            }
        }
    }

    public void KinematicOutput() {
        BalloonPopulation pop0 = this.PopList[0];
        ColorProcessor cp = new ColorProcessor(pop0.ipb.getWidth(), pop0.ipb.getHeight());
        ImagePlus imp_kine = new ImagePlus("Kinematics", (ImageProcessor)cp);
        ImageStack stack = imp_kine.createEmptyStack();
        for (int i = 0; i < this.Nseq; ++i) {
            BalloonPopulation pop = this.PopList[i];
            ColorProcessor ip_kine = pop.Draw_kinematics();
            stack.addSlice("", (ImageProcessor)ip_kine);
        }
        imp_kine.setStack(null, stack);
        imp_kine.show();
    }

    public void lineageOutput() {
        BalloonPopulation pop0 = this.PopList[0];
        ColorProcessor cp = new ColorProcessor(pop0.ipb.getWidth(), pop0.ipb.getHeight());
        ImagePlus imp_kine = new ImagePlus("lineage", (ImageProcessor)cp);
        ImageStack stack = imp_kine.createEmptyStack();
        for (int i = 0; i < this.Nseq; ++i) {
            BalloonPopulation pop = this.PopList[i];
            ColorProcessor ip_kine = pop.Draw_lineage(i);
            if (i == this.Nseq - 1) {
                for (int j = 0; j < this.Nseq; ++j) {
                    BalloonPopulation pop_div = this.PopList[j];
                    for (int k = 0; k < pop_div.BallList.size(); ++k) {
                        Balloon bal = pop_div.BallList.get(k);
                        if (bal.id_line != 6) continue;
                        ip_kine.setLineWidth(4);
                        ip_kine.setColor(new Color(0, 250, 0));
                        ip_kine.drawLine(bal.div_x0, bal.div_y0, bal.div_x1, bal.div_y1);
                    }
                }
            }
            stack.addSlice("", (ImageProcessor)ip_kine);
        }
        imp_kine.setStack(null, stack);
        imp_kine.show();
    }

    private void lineage(BalloonPopulation BP, BalloonPopulation BP1, int seq) {
        for (int i = 0; i < BP.N; ++i) {
            Balloon Bnew = BP1.BallList.get(i);
            Balloon Bmother = BP.BallList.get(i);
            Bnew.id_mother = Bmother.id_mother;
            Bnew.n_generation = Bmother.n_generation;
            Bnew.id_line = Bmother.id_line;
        }
        if (BP1.N - BP.N > 0) {
            int n_new = BP1.N - BP.N;
            RandPermutation rndPermute = new RandPermutation(n_new);
            int[] IDmothers = new int[n_new];
            int[] final_perm = new int[n_new];
            double score_global = 9999999.0;
            int[] perm = rndPermute.next();
            Matrix final_topo = this.projected_topo(BP, BP1, null, -1, -1, seq);
            int t = 0;
            boolean is_loop = true;
            while (is_loop) {
                ++t;
                double score_candidate_global = 0.0;
                int[] IDmothers_candidate = new int[n_new];
                int[] perm_candidate = rndPermute.next();
                for (int ii = BP.N; ii < BP1.N; ++ii) {
                    int i = BP.N + perm[ii - BP.N];
                    double score = 15.0;
                    Balloon Bnew = BP1.BallList.get(i);
                    int[] new_neighb = BP1.contacts[i];
                    Balloon Bmother = BP.BallList.get(0);
                    for (int j = 0; j < BP.N; ++j) {
                        Balloon Bcandidate = BP.BallList.get(j);
                        int[] candidate_neighb_0 = BP.contacts[j];
                        int[] candidate_neighb_1 = BP1.contacts[j];
                        double score_candidate = 15.0;
                        score_candidate = BP1.topo[Bnew.id][Bcandidate.id] ? this.score_lineage(final_topo, BP, BP1, Bnew.id, Bcandidate.id, seq) : 15.0;
                        if (!(score_candidate < score)) continue;
                        score = score_candidate;
                        Bmother = Bcandidate;
                    }
                    Balloon Bpair = BP1.BallList.get(Bmother.id);
                    final_topo = this.projected_topo(BP, BP1, final_topo, Bnew.id, Bpair.id, seq);
                    IDmothers_candidate[i - BP.N] = Bmother.id;
                    score_candidate_global += 1.0;
                }
                if (score_candidate_global < score_global) {
                    score_global = score_candidate_global;
                    IDmothers = IDmothers_candidate;
                    perm = perm_candidate;
                }
                if (t <= 5) continue;
                is_loop = false;
            }
            for (int i = 0; i < n_new; ++i) {
                Balloon Bmother = BP.BallList.get(IDmothers[i]);
                Balloon Bpair = BP1.BallList.get(IDmothers[i]);
                Balloon Bnew = BP1.BallList.get(BP.N + i);
                Bpair.n_generation = Bnew.n_generation = Bmother.n_generation + 1;
                Bnew.id_mother = Bmother.id;
                Bpair.id_mother = Bmother.id;
                this.find_divisionplane(Bnew, Bpair, BP, BP1);
                Bnew.id_line = Bmother.id_line;
                Bpair.id_line = Bmother.id_line;
            }
        }
    }

    private Matrix projected_topo(BalloonPopulation BP0, BalloonPopulation BP1, Matrix current_topo, int new_id, int candidate_id, int seq) {
        int n_topo0 = BP0.topo.length;
        Matrix updated_topo = new Matrix(n_topo0, n_topo0, 0.0);
        if (current_topo == null | new_id < 0 | candidate_id < 0) {
            BP1.ref_topo = new Matrix(n_topo0, n_topo0, 0.0);
            for (int i = 0; i < n_topo0; ++i) {
                for (int j = 0; j < i; ++j) {
                    double ref_entry = 0.0;
                    if (BP0.topo[i][j]) {
                        BP1.ref_topo.set(i, j, ref_entry);
                        BP1.ref_topo.set(j, i, ref_entry);
                    }
                    double entry0 = 0.0;
                    if (!BP1.topo[i][j]) continue;
                    updated_topo.set(i, j, entry0);
                    updated_topo.set(j, i, entry0);
                }
            }
        } else {
            for (int i = 0; i < n_topo0; ++i) {
                double entry2 = 0.0;
                if (BP1.topo[new_id][i]) {
                    entry2 = 1.0;
                }
                for (int j = 0; j < i; ++j) {
                    double entry1 = 0.0;
                    if (BP0.topo[i][j]) {
                        entry1 = 1.0;
                    }
                    BP1.ref_topo.set(i, j, entry1);
                    BP1.ref_topo.set(j, i, entry1);
                    updated_topo.set(i, j, current_topo.get(i, j) + updated_topo.get(i, j));
                    updated_topo.set(j, i, current_topo.get(i, j) + updated_topo.get(i, j));
                }
                if (i == candidate_id) continue;
                updated_topo.set(candidate_id, i, Math.max(entry2, updated_topo.get(candidate_id, i)));
                updated_topo.set(i, candidate_id, Math.max(entry2, updated_topo.get(candidate_id, i)));
            }
        }
        return updated_topo;
    }

    private double score_lineage(Matrix current_topo, BalloonPopulation BP0, BalloonPopulation BP1, int new_id, int candidate_id, int seq) {
        int n_topo0 = BP0.topo.length;
        Matrix candidate_topo = this.projected_topo(BP0, BP1, current_topo, new_id, candidate_id, seq);
        double norm0 = BP1.ref_topo.normF();
        double dist = BP1.ref_topo.minus(candidate_topo).normF();
        double score = Math.sqrt(dist / norm0);
        Balloon Bnew = BP1.BallList.get(new_id);
        Balloon Bpair = BP1.BallList.get(candidate_id);
        Balloon Bmother = BP0.BallList.get(candidate_id);
        double delta_volume = (Bnew.area + Bpair.area - Bmother.area) / Bmother.area;
        if (delta_volume < -0.15 | delta_volume > 0.25) {
            score += 2.0;
        }
        return score;
    }

    private void find_divisionplane(Balloon bal1, Balloon bal2, BalloonPopulation BP0, BalloonPopulation BP1) {
        double alpha;
        boolean start = false;
        double x0 = 0.0;
        double y0 = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double x = 0.0;
        double y = 0.0;
        double xm = 0.0;
        double ym = 0.0;
        Vector<double[]> div_plan = new Vector<double[]>();
        for (int j = 0; j < bal1.n0; ++j) {
            if (BP1.contacts[bal1.id][j] != bal2.id) continue;
            double dist = 100000.0;
            x0 = bal1.XX[j];
            y0 = bal1.YY[j];
            for (int k = 0; k < bal2.n0; ++k) {
                if (!(Math.sqrt((x0 - bal2.XX[k]) * (x0 - bal2.XX[k]) + (y0 - bal2.YY[k]) * (y0 - bal2.YY[k])) < dist)) continue;
                x1 = bal2.XX[k];
                y1 = bal2.YY[k];
                dist = Math.sqrt((x0 - bal2.XX[k]) * (x0 - bal2.XX[k]) + (y0 - bal2.YY[k]) * (y0 - bal2.YY[k]));
            }
            double[] xy = new double[]{(x0 + x1) / 2.0, (y0 + y1) / 2.0};
            xm += (x0 + x1) / 2.0;
            ym += (y0 + y1) / 2.0;
            Balloon bal_mother = BP0.BallList.get(bal1.id_mother);
            div_plan.addElement(xy);
        }
        int n = div_plan.size();
        Matrix X = new Matrix(n, 2, 1.0);
        Matrix Y = new Matrix(n, 1, 0.0);
        xm /= (double)n;
        ym /= (double)n;
        Balloon Bmother = BP0.BallList.get(bal1.id_mother);
        for (int j = 0; j < div_plan.size(); ++j) {
            double[] xy = (double[])div_plan.get(j);
            X.set(j, 0, xy[0]);
            Y.set(j, 0, xy[1]);
        }
        boolean is_loop = true;
        if (X.rank() > 1) {
            Matrix coeff = X.solve(Y);
            alpha = Math.atan(coeff.get(0, 0));
        } else {
            alpha = (bal1.y0 - bal2.y0) / (bal2.x0 - bal1.x0);
        }
        int i = 1;
        int[] CX = new int[Bmother.XX.length];
        int[] CY = new int[Bmother.XX.length];
        for (int k = 0; k < CX.length; ++k) {
            CX[k] = (int)Bmother.XX[k];
            CY[k] = (int)Bmother.YY[k];
        }
        Polygon cell = new Polygon(CX, CY, CX.length);
        while (is_loop) {
            x0 = (int)(xm - (double)i * Math.cos(alpha));
            y0 = (int)(ym - (double)i * Math.sin(alpha));
            is_loop = cell.contains(x0, y0);
            ++i;
        }
        Bmother.div_x0 = (int)(xm - (double)i * Math.cos(alpha) * 0.5);
        Bmother.div_y0 = (int)(ym - (double)i * Math.sin(alpha) * 0.5);
        is_loop = true;
        while (is_loop) {
            x1 = (int)(xm + (double)i * Math.cos(alpha));
            y1 = (int)(ym + (double)i * Math.sin(alpha));
            is_loop = cell.contains(x1, y1);
            ++i;
        }
        Bmother.div_x1 = (int)(xm + (double)i * Math.cos(alpha) * 0.5);
        Bmother.div_y1 = (int)(ym + (double)i * Math.sin(alpha) * 0.5);
    }

    private void Kinematics_inertia(BalloonPopulation BP, BalloonPopulation BP1) {
        BP1.mass_Geometry();
        int w = BP1.ipb.getWidth();
        int h = BP1.ipb.getHeight();
        ColorProcessor cp = new ColorProcessor(w, h);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int pix;
                int red = pix = BP1.ipb.getPixel(x, y);
                int green = pix;
                int blue = pix;
                cp.putPixel(x, y, ((red & 0xFF) << 16) + ((green & 0xFF) << 8) + (blue & 0xFF));
            }
        }
        ImagePlus imp = new ImagePlus("Disps", (ImageProcessor)cp);
        ImageProcessor ip = imp.getProcessor();
        for (int i = 0; i < BP.N; ++i) {
            int j;
            Balloon B0 = BP.BallList.get(i);
            Balloon B1 = BP1.BallList.get(i);
            int[] neig_list = new int[BP.N];
            for (j = 0; j < BP.N; ++j) {
                neig_list[j] = 0;
            }
            for (j = 0; j < B0.n0; ++j) {
                if (BP.contacts[i][j] <= 0) continue;
                neig_list[BP.contacts[i][j]] = 1;
            }
            boolean n = false;
            Vector<double[]> V = new Vector<double[]>();
            Vector<double[]> PXY = new Vector<double[]>();
            for (int j2 = -1; j2 < BP.N; ++j2) {
                if (j2 == -1) {
                    double[] u = new double[]{B1.x0 - B0.x0, B1.y0 - B0.y0};
                    double[] xy = new double[]{B0.x0, B0.y0};
                    V.addElement(u);
                    PXY.addElement(xy);
                    continue;
                }
                if (!BP1.topo[i][j2]) continue;
                Balloon B0n = BP.BallList.get(j2);
                Balloon B1n = BP1.BallList.get(j2);
                double[] u = new double[]{B1n.x0 - B0n.x0, B1n.y0 - B0n.y0};
                double[] xy = new double[]{B0n.x0, B0n.y0};
                V.addElement(u);
                PXY.addElement(xy);
            }
            double[][] X = new double[V.size()][3];
            double[][] Yx = new double[V.size()][1];
            double[][] Yy = new double[V.size()][1];
            for (int k = 0; k < V.size(); ++k) {
                double[] M = (double[])V.get(k);
                double[] xy2 = (double[])PXY.get(k);
                X[k][0] = xy2[0];
                X[k][1] = xy2[1];
                X[k][2] = 1.0;
                Yx[k][0] = M[0];
                Yy[k][0] = M[1];
            }
            if (V.size() <= 2) continue;
            Matrix MX = new Matrix(X);
            Matrix MYx = new Matrix(Yx);
            Matrix MYy = new Matrix(Yy);
            Matrix COEFx = MX.solve(MYx);
            Matrix COEFy = MX.solve(MYy);
            double[][] DispCoeff = new double[][]{{COEFx.get(0, 0), COEFx.get(1, 0)}, {COEFy.get(0, 0), COEFy.get(1, 0)}};
            Matrix DispField = new Matrix((double[][])DispCoeff);
            SingularValueDecomposition SVD = new SingularValueDecomposition(DispField);
            Matrix U = SVD.getU().times(SVD.getV().transpose());
            double[][] xyg = new double[][]{{B0.x0}, {B0.y0}};
            Matrix XYg = new Matrix((double[][])xyg);
            Matrix DispG = DispField.times(XYg);
            ip.setColor(new Color(0, 0, 250));
            ip.drawLine(B1.x0, B1.y0, B1.x0 + (int)(DispG.get(0, 0) + COEFx.get(2, 0)) * 10, B1.y0 + (int)(DispG.get(1, 0) + COEFy.get(2, 0)) * 10);
            ip.setColor(new Color(0, 0, 250));
            ip.drawLine(B1.x0 - 1, B1.y0 - 1, B1.x0 + 1, B1.y0 + 1);
            ip.setColor(new Color(0, 250, 0));
            ip.drawLine(B1.x0, B1.y0, B1.x0 + (int)U.get(0, 0) * 10, B1.y0 + (int)U.get(1, 0) * 10);
            ip.setColor(new Color(250, 0, 0));
            ip.drawLine(B1.x0, B1.y0, B1.x0 + (int)U.get(0, 1) * 10, B1.y0 + (int)U.get(1, 1) * 10);
            double Ixx = B0.Ixx;
            double Iyy = B0.Iyy;
            double Ixy = B0.Ixy;
            double[][] I2_array = new double[][]{{B1.Ixx, B1.Ixy}, {B1.Ixy, B1.Iyy}};
            Matrix I2 = new Matrix((double[][])I2_array);
            double dIxx = I2.get(0, 0) - Ixx;
            double dIxy = I2.get(0, 1) - Ixy;
            double dIyy = I2.get(1, 1) - Iyy;
            double[][] dI = new double[][]{{dIxx}, {dIxy}, {dIyy}};
            double[][] M = new double[][]{{3.0 * Ixx, 2.0 * Ixy, Iyy}, {2.0 * Ixy, Ixx + Iyy, 2.0 * Ixy}, {Iyy, 2.0 * Ixy, 3.0 * Iyy}};
            Matrix SYS = new Matrix((double[][])M);
            try {
                Matrix eigVectors;
                Matrix Solution = SYS.solve(new Matrix((double[][])dI));
                double[][] Strain = new double[][]{{Solution.get(0, 0), Solution.get(1, 0)}, {Solution.get(1, 0), Solution.get(2, 0)}};
                Matrix StrainTensor = new Matrix((double[][])Strain);
                EigenvalueDecomposition eig = StrainTensor.eig();
                double[] eigValues = eig.getRealEigenvalues();
                B1.StrainVector = eigVectors = eig.getV();
                B1.StrainValues = eigValues;
                B1.sig_vol = (B1.area - B0.area) / B0.area;
                B1.StrainTensor = StrainTensor;
                continue;
            }
            catch (Exception err) {
                IJ.log((String)("Unable to find the principal axis of deformation " + B0.id + " : " + B0.Ixx + " , " + B0.Iyy));
                SYS.print(3, 3);
                err.printStackTrace();
            }
        }
    }
}

