/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.IPyramidStore;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.Compression;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FillRule;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.FontFamily;
import ome.xml.model.enums.FontStyle;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.Marker;
import ome.xml.model.enums.Medium;
import ome.xml.model.enums.MicrobeamManipulationType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.enums.handlers.AcquisitionModeEnumHandler;
import ome.xml.model.enums.handlers.ArcTypeEnumHandler;
import ome.xml.model.enums.handlers.BinningEnumHandler;
import ome.xml.model.enums.handlers.CompressionEnumHandler;
import ome.xml.model.enums.handlers.ContrastMethodEnumHandler;
import ome.xml.model.enums.handlers.CorrectionEnumHandler;
import ome.xml.model.enums.handlers.DetectorTypeEnumHandler;
import ome.xml.model.enums.handlers.DimensionOrderEnumHandler;
import ome.xml.model.enums.handlers.ExperimentTypeEnumHandler;
import ome.xml.model.enums.handlers.FilamentTypeEnumHandler;
import ome.xml.model.enums.handlers.FillRuleEnumHandler;
import ome.xml.model.enums.handlers.FilterTypeEnumHandler;
import ome.xml.model.enums.handlers.FontFamilyEnumHandler;
import ome.xml.model.enums.handlers.FontStyleEnumHandler;
import ome.xml.model.enums.handlers.IlluminationTypeEnumHandler;
import ome.xml.model.enums.handlers.ImmersionEnumHandler;
import ome.xml.model.enums.handlers.LaserMediumEnumHandler;
import ome.xml.model.enums.handlers.LaserTypeEnumHandler;
import ome.xml.model.enums.handlers.MarkerEnumHandler;
import ome.xml.model.enums.handlers.MediumEnumHandler;
import ome.xml.model.enums.handlers.MicrobeamManipulationTypeEnumHandler;
import ome.xml.model.enums.handlers.MicroscopeTypeEnumHandler;
import ome.xml.model.enums.handlers.NamingConventionEnumHandler;
import ome.xml.model.enums.handlers.PixelTypeEnumHandler;
import ome.xml.model.enums.handlers.PulseEnumHandler;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataTools.class);
    private static boolean defaultDateEnabled = false;

    private MetadataTools() {
    }

    public static void populatePixels(MetadataStore store, IFormatReader r) {
        MetadataTools.populatePixels(store, r, false, true);
    }

    public static void populatePixels(MetadataStore store, IFormatReader r, boolean doPlane) {
        MetadataTools.populatePixels(store, r, doPlane, true);
    }

    public static void populatePixels(MetadataStore store, IFormatReader r, boolean doPlane, boolean doImageName) {
        if (store == null || r == null) {
            return;
        }
        int oldSeries = r.getSeries();
        for (int i = 0; i < r.getSeriesCount(); ++i) {
            block12: {
                r.setSeries(i);
                String imageName = null;
                if (doImageName) {
                    Location f = new Location(r.getCurrentFile());
                    imageName = f.getName();
                    if (r.getSeriesCount() > 1) {
                        imageName = imageName + " #" + (i + 1);
                    }
                }
                String pixelType = FormatTools.getPixelTypeString(r.getPixelType());
                MetadataTools.populateMetadata(store, r.getCurrentFile(), i, imageName, r.isLittleEndian(), r.getDimensionOrder(), pixelType, r.getSizeX(), r.getSizeY(), r.getSizeZ(), r.getSizeC(), r.getSizeT(), r.getRGBChannelCount());
                store.setPixelsInterleaved(r.isInterleaved(), i);
                store.setPixelsSignificantBits(new PositiveInteger(Integer.valueOf(r.getBitsPerPixel())), i);
                if (store instanceof IPyramidStore) {
                    for (int res = 1; res < r.getResolutionCount(); ++res) {
                        r.setResolution(res);
                        ((IPyramidStore)((Object)store)).setResolutionSizeX(new PositiveInteger(Integer.valueOf(r.getSizeX())), i, res);
                        ((IPyramidStore)((Object)store)).setResolutionSizeY(new PositiveInteger(Integer.valueOf(r.getSizeY())), i, res);
                    }
                    r.setResolution(0);
                }
                try {
                    MetadataStore baseStore;
                    OMEXMLService service = new ServiceFactory().getInstance(OMEXMLService.class);
                    if (!service.isOMEXMLRoot(store.getRoot()) || !service.isOMEXMLMetadata(baseStore = r.getMetadataStore())) break block12;
                    try {
                        OMEXMLMetadata omeMeta = service.getOMEMetadata(service.asRetrieve(baseStore));
                        if (omeMeta.getTiffDataCount(i) == 0 && omeMeta.getPixelsBinDataCount(i) == 0) {
                            service.addMetadataOnly(omeMeta, i, i == 0);
                        }
                    }
                    catch (ServiceException e) {
                        LOGGER.warn("Failed to add MetadataOnly", (Throwable)e);
                    }
                }
                catch (DependencyException exc) {
                    LOGGER.warn("Failed to add MetadataOnly", (Throwable)exc);
                }
            }
            if (!doPlane) continue;
            for (int q = 0; q < r.getImageCount(); ++q) {
                int[] coords = r.getZCTCoords(q);
                store.setPlaneTheZ(new NonNegativeInteger(Integer.valueOf(coords[0])), i, q);
                store.setPlaneTheC(new NonNegativeInteger(Integer.valueOf(coords[1])), i, q);
                store.setPlaneTheT(new NonNegativeInteger(Integer.valueOf(coords[2])), i, q);
            }
        }
        r.setSeries(oldSeries);
    }

    public static void populateMetadata(MetadataStore store, int series, String imageName, CoreMetadata coreMeta) {
        String pixelType = FormatTools.getPixelTypeString(coreMeta.pixelType);
        int effSizeC = coreMeta.imageCount / coreMeta.sizeZ / coreMeta.sizeT;
        int samplesPerPixel = coreMeta.sizeC / effSizeC;
        MetadataTools.populateMetadata(store, null, series, imageName, coreMeta.littleEndian, coreMeta.dimensionOrder, pixelType, coreMeta.sizeX, coreMeta.sizeY, coreMeta.sizeZ, coreMeta.sizeC, coreMeta.sizeT, samplesPerPixel);
    }

    public static void populateMetadata(MetadataStore store, int series, String imageName, boolean littleEndian, String dimensionOrder, String pixelType, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, int samplesPerPixel) {
        MetadataTools.populateMetadata(store, null, series, imageName, littleEndian, dimensionOrder, pixelType, sizeX, sizeY, sizeZ, sizeC, sizeT, samplesPerPixel);
    }

    public static void populateMetadata(MetadataStore store, String file, int series, String imageName, boolean littleEndian, String dimensionOrder, String pixelType, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, int samplesPerPixel) {
        store.setImageID(MetadataTools.createLSID("Image", series), series);
        MetadataTools.setDefaultCreationDate(store, file, series);
        if (imageName != null) {
            store.setImageName(imageName, series);
        }
        MetadataTools.populatePixelsOnly(store, series, littleEndian, dimensionOrder, pixelType, sizeX, sizeY, sizeZ, sizeC, sizeT, samplesPerPixel);
    }

    public static void populatePixelsOnly(MetadataStore store, IFormatReader r) {
        int oldSeries = r.getSeries();
        for (int i = 0; i < r.getSeriesCount(); ++i) {
            r.setSeries(i);
            String pixelType = FormatTools.getPixelTypeString(r.getPixelType());
            MetadataTools.populatePixelsOnly(store, i, r.isLittleEndian(), r.getDimensionOrder(), pixelType, r.getSizeX(), r.getSizeY(), r.getSizeZ(), r.getSizeC(), r.getSizeT(), r.getRGBChannelCount());
            if (!(store instanceof IPyramidStore)) continue;
            for (int res = 1; res < r.getResolutionCount(); ++res) {
                r.setResolution(res);
                ((IPyramidStore)((Object)store)).setResolutionSizeX(new PositiveInteger(Integer.valueOf(r.getSizeX())), i, res);
                ((IPyramidStore)((Object)store)).setResolutionSizeY(new PositiveInteger(Integer.valueOf(r.getSizeY())), i, res);
            }
            r.setResolution(0);
        }
        r.setSeries(oldSeries);
    }

    public static void populatePixelsOnly(MetadataStore store, int series, boolean littleEndian, String dimensionOrder, String pixelType, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, int samplesPerPixel) {
        store.setPixelsID(MetadataTools.createLSID("Pixels", series), series);
        store.setPixelsBigEndian(!littleEndian, series);
        try {
            store.setPixelsDimensionOrder(DimensionOrder.fromString((String)dimensionOrder), series);
        }
        catch (EnumerationException e) {
            LOGGER.warn("Invalid dimension order: " + dimensionOrder, (Throwable)e);
        }
        try {
            store.setPixelsType(PixelType.fromString((String)pixelType), series);
        }
        catch (EnumerationException e) {
            LOGGER.warn("Invalid pixel type: " + pixelType, (Throwable)e);
        }
        store.setPixelsSizeX(new PositiveInteger(Integer.valueOf(sizeX)), series);
        store.setPixelsSizeY(new PositiveInteger(Integer.valueOf(sizeY)), series);
        store.setPixelsSizeZ(new PositiveInteger(Integer.valueOf(sizeZ)), series);
        store.setPixelsSizeC(new PositiveInteger(Integer.valueOf(sizeC)), series);
        store.setPixelsSizeT(new PositiveInteger(Integer.valueOf(sizeT)), series);
        int effSizeC = sizeC / samplesPerPixel;
        for (int i = 0; i < effSizeC; ++i) {
            store.setChannelID(MetadataTools.createLSID("Channel", series, i), series, i);
            store.setChannelSamplesPerPixel(new PositiveInteger(Integer.valueOf(samplesPerPixel)), series, i);
        }
    }

    public static String createLSID(String type, int ... indices) {
        StringBuffer lsid = new StringBuffer(type);
        for (int index : indices) {
            lsid.append(":");
            lsid.append(index);
        }
        return lsid.toString();
    }

    public static void verifyMinimumPopulated(MetadataRetrieve src) throws FormatException {
        MetadataTools.verifyMinimumPopulated(src, 0);
    }

    public static void verifyMinimumPopulated(MetadataRetrieve src, int n) throws FormatException {
        if (src == null) {
            throw new FormatException("Metadata object is null; call IFormatWriter.setMetadataRetrieve() first");
        }
        if (src instanceof MetadataStore && ((MetadataStore)((Object)src)).getRoot() == null) {
            throw new FormatException("Metadata object has null root; call IMetadata.createRoot() first");
        }
        if (src.getImageID(n) == null) {
            throw new FormatException("Image ID #" + n + " is null");
        }
        if (src.getPixelsID(n) == null) {
            throw new FormatException("Pixels ID #" + n + " is null");
        }
        for (int i = 0; i < src.getChannelCount(n); ++i) {
            if (src.getChannelID(n, i) != null) continue;
            throw new FormatException("Channel ID #" + i + " in Image #" + n + " is null");
        }
        if (src.getPixelsBigEndian(n) == null && (src.getPixelsBinDataCount(n) == 0 || src.getPixelsBinDataBigEndian(n, 0) == null)) {
            throw new FormatException("BigEndian #" + n + " is null");
        }
        if (src.getPixelsDimensionOrder(n) == null) {
            throw new FormatException("DimensionOrder #" + n + " is null");
        }
        if (src.getPixelsType(n) == null) {
            throw new FormatException("PixelType #" + n + " is null");
        }
        if (src.getPixelsSizeC(n) == null) {
            throw new FormatException("SizeC #" + n + " is null");
        }
        if (src.getPixelsSizeT(n) == null) {
            throw new FormatException("SizeT #" + n + " is null");
        }
        if (src.getPixelsSizeX(n) == null) {
            throw new FormatException("SizeX #" + n + " is null");
        }
        if (src.getPixelsSizeY(n) == null) {
            throw new FormatException("SizeY #" + n + " is null");
        }
        if (src.getPixelsSizeZ(n) == null) {
            throw new FormatException("SizeZ #" + n + " is null");
        }
    }

    public static void setDefaultDateEnabled(boolean enabled) {
        defaultDateEnabled = enabled;
    }

    public static void setDefaultCreationDate(MetadataStore store, String id, int series) {
        if (!defaultDateEnabled) {
            return;
        }
        Location file = id == null ? null : new Location(id).getAbsoluteFile();
        long time = System.currentTimeMillis();
        if (file != null && file.exists()) {
            time = file.lastModified();
        }
        store.setImageAcquisitionDate(new Timestamp(DateTools.convertDate(time, 0)), series);
    }

    public static String makeSaneDimensionOrder(String dimensionOrder) {
        String[] axes;
        String order = dimensionOrder.toUpperCase();
        order = order.replaceAll("[^XYZCT]", "");
        for (String axis : axes = new String[]{"X", "Y", "C", "Z", "T"}) {
            if (order.indexOf(axis) == -1) {
                order = order + axis;
            }
            while (order.indexOf(axis) != order.lastIndexOf(axis)) {
                order = order.replaceFirst(axis, "");
            }
        }
        return order;
    }

    public static String[] keys(Hashtable<String, Object> meta) {
        Object[] keys = new String[meta.size()];
        meta.keySet().toArray(keys);
        Arrays.sort(keys);
        return keys;
    }

    public static void merge(Map<String, Object> src, Map<String, Object> dest, String prefix) {
        for (String key : src.keySet()) {
            dest.put(prefix + key, src.get(key));
        }
    }

    public static IMetadata createOMEXMLMetadata() {
        try {
            OMEXMLService service = new ServiceFactory().getInstance(OMEXMLService.class);
            if (service == null) {
                return null;
            }
            return service.createOMEXMLMetadata();
        }
        catch (DependencyException exc) {
            return null;
        }
        catch (ServiceException exc) {
            return null;
        }
    }

    public static AcquisitionMode getAcquisitionMode(String value) throws FormatException {
        AcquisitionModeEnumHandler handler = new AcquisitionModeEnumHandler();
        try {
            return (AcquisitionMode)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("AcquisitionMode creation failed", e);
        }
    }

    public static ArcType getArcType(String value) throws FormatException {
        ArcTypeEnumHandler handler = new ArcTypeEnumHandler();
        try {
            return (ArcType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("ArcType creation failed", e);
        }
    }

    public static Binning getBinning(String value) throws FormatException {
        BinningEnumHandler handler = new BinningEnumHandler();
        try {
            return (Binning)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Binning creation failed", e);
        }
    }

    public static Compression getCompression(String value) throws FormatException {
        CompressionEnumHandler handler = new CompressionEnumHandler();
        try {
            return (Compression)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Compression creation failed", e);
        }
    }

    public static ContrastMethod getContrastMethod(String value) throws FormatException {
        ContrastMethodEnumHandler handler = new ContrastMethodEnumHandler();
        try {
            return (ContrastMethod)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("ContrastMethod creation failed", e);
        }
    }

    public static Correction getCorrection(String value) throws FormatException {
        CorrectionEnumHandler handler = new CorrectionEnumHandler();
        try {
            return (Correction)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Correction creation failed", e);
        }
    }

    public static DetectorType getDetectorType(String value) throws FormatException {
        DetectorTypeEnumHandler handler = new DetectorTypeEnumHandler();
        try {
            return (DetectorType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("DetectorType creation failed", e);
        }
    }

    public static DimensionOrder getDimensionOrder(String value) throws FormatException {
        DimensionOrderEnumHandler handler = new DimensionOrderEnumHandler();
        try {
            return (DimensionOrder)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("DimensionOrder creation failed", e);
        }
    }

    public static ExperimentType getExperimentType(String value) throws FormatException {
        ExperimentTypeEnumHandler handler = new ExperimentTypeEnumHandler();
        try {
            return (ExperimentType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("ExperimentType creation failed", e);
        }
    }

    public static FilamentType getFilamentType(String value) throws FormatException {
        FilamentTypeEnumHandler handler = new FilamentTypeEnumHandler();
        try {
            return (FilamentType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("FilamentType creation failed", e);
        }
    }

    public static FillRule getFillRule(String value) throws FormatException {
        FillRuleEnumHandler handler = new FillRuleEnumHandler();
        try {
            return (FillRule)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("FillRule creation failed", e);
        }
    }

    public static FilterType getFilterType(String value) throws FormatException {
        FilterTypeEnumHandler handler = new FilterTypeEnumHandler();
        try {
            return (FilterType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("FilterType creation failed", e);
        }
    }

    public static FontFamily getFontFamily(String value) throws FormatException {
        FontFamilyEnumHandler handler = new FontFamilyEnumHandler();
        try {
            return (FontFamily)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("FontFamily creation failed", e);
        }
    }

    public static FontStyle getFontStyle(String value) throws FormatException {
        FontStyleEnumHandler handler = new FontStyleEnumHandler();
        try {
            return (FontStyle)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("FontStyle creation failed", e);
        }
    }

    public static IlluminationType getIlluminationType(String value) throws FormatException {
        IlluminationTypeEnumHandler handler = new IlluminationTypeEnumHandler();
        try {
            return (IlluminationType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("IlluminationType creation failed", e);
        }
    }

    public static Immersion getImmersion(String value) throws FormatException {
        ImmersionEnumHandler handler = new ImmersionEnumHandler();
        try {
            return (Immersion)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Immersion creation failed", e);
        }
    }

    public static LaserMedium getLaserMedium(String value) throws FormatException {
        LaserMediumEnumHandler handler = new LaserMediumEnumHandler();
        try {
            return (LaserMedium)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("LaserMedium creation failed", e);
        }
    }

    public static LaserType getLaserType(String value) throws FormatException {
        LaserTypeEnumHandler handler = new LaserTypeEnumHandler();
        try {
            return (LaserType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("LaserType creation failed", e);
        }
    }

    public static Marker getMarker(String value) throws FormatException {
        MarkerEnumHandler handler = new MarkerEnumHandler();
        try {
            return (Marker)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Marker creation failed", e);
        }
    }

    public static Medium getMedium(String value) throws FormatException {
        MediumEnumHandler handler = new MediumEnumHandler();
        try {
            return (Medium)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Medium creation failed", e);
        }
    }

    public static MicrobeamManipulationType getMicrobeamManipulationType(String value) throws FormatException {
        MicrobeamManipulationTypeEnumHandler handler = new MicrobeamManipulationTypeEnumHandler();
        try {
            return (MicrobeamManipulationType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("MicrobeamManipulationType creation failed", e);
        }
    }

    public static MicroscopeType getMicroscopeType(String value) throws FormatException {
        MicroscopeTypeEnumHandler handler = new MicroscopeTypeEnumHandler();
        try {
            return (MicroscopeType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("MicroscopeType creation failed", e);
        }
    }

    public static NamingConvention getNamingConvention(String value) throws FormatException {
        NamingConventionEnumHandler handler = new NamingConventionEnumHandler();
        try {
            return (NamingConvention)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("NamingConvention creation failed", e);
        }
    }

    public static PixelType getPixelType(String value) throws FormatException {
        PixelTypeEnumHandler handler = new PixelTypeEnumHandler();
        try {
            return (PixelType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("PixelType creation failed", e);
        }
    }

    public static Pulse getPulse(String value) throws FormatException {
        PulseEnumHandler handler = new PulseEnumHandler();
        try {
            return (Pulse)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Pulse creation failed", e);
        }
    }
}

