/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.io.RandomAccessStream;
import ij.plugin.PlugIn;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import java.io.IOException;
import java.io.RandomAccessFile;

public class IPLab_Reader
extends ImagePlus
implements PlugIn {
    boolean littleEndian;
    RandomAccessStream f;
    boolean isColor48;
    int nextBlock;
    int itag;

    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open IPLab...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        IJ.showStatus((String)("Opening: " + directory + name));
        this.open(directory, name, arg);
    }

    void open(String directory, String name, String arg) {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(directory, name);
        }
        catch (IOException e) {
            IJ.showStatus((String)"");
            String error = e.getMessage();
            if (error == null || error.equals("")) {
                error = "" + e;
            }
            IJ.showMessage((String)"IPLab Reader", (String)("" + error));
            return;
        }
        if (fi != null) {
            FileOpener fo = new FileOpener(fi);
            ImagePlus imp = fo.open(false);
            if (imp == null) {
                return;
            }
            if (this.isColor48 && imp.getBitDepth() == 16 && imp.getStackSize() == 3) {
                this.handleColor48Image(imp);
            }
            this.setStack(name, imp.getStack());
            this.setCalibration(imp.getCalibration());
            if (arg.equals("")) {
                this.show();
            }
        }
    }

    void handleColor48Image(ImagePlus imp) {
        ImageStack stack = imp.getStack();
        stack.setSliceLabel("Red", 1);
        stack.setSliceLabel("Green", 2);
        stack.setSliceLabel("Blue", 3);
        this.convertColor48ToRGB(imp);
    }

    void convertColor48ToRGB(ImagePlus imp) {
        ImageProcessor ip2;
        int width = imp.getWidth();
        int height = imp.getHeight();
        ImageStack stack1 = imp.getStack();
        ImageStack stack2 = new ImageStack(width, height);
        for (int i = 1; i <= stack1.getSize(); ++i) {
            ImageProcessor ip = stack1.getProcessor(i);
            ip2 = ip.duplicate();
            stack2.addSlice(null, ip2);
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack("RGB of " + imp.getTitle(), stack2);
        ip2 = imp2.getProcessor();
        StackConverter sc = new StackConverter(imp2);
        sc.convertToGray8();
        ImageConverter ic = new ImageConverter(imp2);
        ic.convertRGBStackToRGB();
        imp2.show();
    }

    FileInfo getFileInfo(String directory, String name) throws IOException {
        FileInfo fi = new FileInfo();
        this.f = new RandomAccessStream(new RandomAccessFile(directory + name, "r"));
        int b0 = this.getByte();
        int b1 = this.getByte();
        int b2 = this.getByte();
        int b3 = this.getByte();
        if (b0 == 105 && b1 == 105 && b2 == 105 && b3 == 105) {
            this.littleEndian = true;
        } else if (b0 == 109 && b1 == 109 && b2 == 109 && b3 == 109) {
            this.littleEndian = false;
        } else {
            throw new IOException("This does not appear to be an IPLab/Windows (.IPL) file.");
        }
        this.f.skip(8L);
        if (this.getByte() != 100 || this.getByte() != 97 || this.getByte() != 116 || this.getByte() != 97) {
            throw new IOException("This does not appear to be an IPLab/Windows (.IPL) file.");
        }
        int blockSize = this.getInt();
        this.nextBlock = 16 + blockSize;
        fi.width = this.getInt();
        fi.height = this.getInt();
        int nChannels = this.getInt();
        int zPlanes = this.getInt();
        int tVolumes = this.getInt();
        int dataType = this.getInt();
        fi.fileFormat = 1;
        fi.fileName = name;
        fi.directory = directory;
        fi.nImages = zPlanes * tVolumes;
        fi.intelByteOrder = this.littleEndian;
        fi.offset = 44;
        switch (dataType) {
            case 0: {
                if (nChannels == 3) {
                    fi.fileType = 7;
                    break;
                }
                fi.fileType = 0;
                break;
            }
            case 1: {
                fi.fileType = 1;
                break;
            }
            case 2: {
                fi.fileType = 2;
                if (fi.nImages == 1) {
                    fi.nImages = nChannels;
                }
                this.isColor48 = nChannels == 3;
                break;
            }
            case 3: {
                fi.fileType = 3;
                break;
            }
            case 4: {
                fi.fileType = 4;
            }
        }
        String tag = null;
        while ((tag = this.getNextBlock()) != null) {
            if (tag.equals("unit")) {
                this.getUnits(fi);
            } else if (this.itag == 759547126) {
                this.decodeAcquireTag(fi);
            }
            if (tag != null) continue;
        }
        this.f.close();
        return fi;
    }

    String getNextBlock() throws IOException {
        this.f.seek(this.nextBlock);
        String tag = this.getString();
        int blockSize = this.getInt();
        this.nextBlock = this.nextBlock + 8 + blockSize;
        if (blockSize == 0) {
            return null;
        }
        return tag;
    }

    void getUnits(FileInfo fi) throws IOException {
        float[] unitsPerPixel = new float[5];
        int[] unit = new int[5];
        for (int i = 0; i < 4; ++i) {
            this.getInt();
            unitsPerPixel[i] = this.getFloat();
            unit[i] = this.getShort();
            this.getShort();
        }
        if ((double)unitsPerPixel[0] != 0.0) {
            fi.pixelHeight = fi.pixelWidth = 1.0 / (double)unitsPerPixel[0];
        }
        switch (unit[0]) {
            case 1: {
                fi.unit = "um";
                break;
            }
            case 2: {
                fi.unit = "mm";
                break;
            }
            case 3: {
                fi.unit = "cm";
                break;
            }
            case 4: {
                fi.unit = "m";
                break;
            }
            case 5: {
                fi.unit = "inch";
                break;
            }
            case 6: {
                fi.unit = "ft";
            }
        }
    }

    void decodeAcquireTag(FileInfo fi) throws IOException {
        this.f.skip(1276L);
        double zSpacing = this.getFloat();
        if (zSpacing > 0.0) {
            fi.pixelDepth = zSpacing;
        }
    }

    int getByte() throws IOException {
        int b = this.f.read();
        if (b == -1) {
            throw new IOException("unexpected EOF");
        }
        return b;
    }

    int getShort() throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        if (this.littleEndian) {
            return (b1 << 8) + b0;
        }
        return (b0 << 8) + b1;
    }

    final int getInt() throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        int b2 = this.getByte();
        int b3 = this.getByte();
        if (this.littleEndian) {
            return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
        }
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    float getFloat() throws IOException {
        return Float.intBitsToFloat(this.getInt());
    }

    String getString() throws IOException {
        byte[] list = new byte[4];
        this.f.read(list);
        this.itag = this.littleEndian ? (list[0] << 24) + (list[1] << 16) + (list[2] << 8) + list[3] : (list[3] << 24) + (list[2] << 16) + (list[1] << 8) + list[0];
        return new String(list);
    }
}

