/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.cellCounter;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.scijava.Context;
import org.scijava.command.CommandService;
import sc.fiji.cellCounter.CellCntrImageCanvas;
import sc.fiji.cellCounter.CellCntrMarker;
import sc.fiji.cellCounter.CellCntrMarkerVector;
import sc.fiji.cellCounter.CellCounterOptions;
import sc.fiji.cellCounter.ReadXML;
import sc.fiji.cellCounter.WriteXML;

public class CellCounter
extends JFrame
implements ActionListener,
ItemListener {
    private static final String ADD = "Add";
    private static final String REMOVE = "Remove";
    private static final String RENAME = "Rename";
    private static final String INITIALIZE = "Initialize";
    private static final String OPTIONS = "Options";
    private static final String RESULTS = "Results";
    private static final String DELETE = "Delete";
    private static final String DELMODE = "Delete Mode";
    private static final String KEEPORIGINAL = "Keep Original";
    private static final String SHOWNUMBERS = "Show Numbers";
    private static final String SHOWALL = "Show All";
    private static final String RESET = "Reset";
    private static final String EXPORTMARKERS = "Save Markers";
    private static final String LOADMARKERS = "Load Markers";
    private static final String EXPORTIMG = "Export Image";
    private static final String MEASURE = "Measure...";
    private static final String TYPE_COMMAND_PREFIX = "type";
    private Vector<CellCntrMarkerVector> typeVector;
    private Vector<JRadioButton> dynRadioVector;
    private final Vector<JTextField> txtFieldVector;
    private CellCntrMarkerVector markerVector;
    private CellCntrMarkerVector currentMarkerVector;
    private int currentMarkerIndex;
    private Map<String, String> metaData = new HashMap<String, String>();
    private JPanel dynPanel;
    private JPanel dynButtonPanel;
    private JPanel statButtonPanel;
    private JPanel dynTxtPanel;
    private JCheckBox delCheck;
    private JCheckBox newCheck;
    private JCheckBox numbersCheck;
    private JCheckBox showAllCheck;
    private ButtonGroup radioGrp;
    private JSeparator separator;
    private JButton addButton;
    private JButton removeButton;
    private JButton renameButton;
    private JButton initializeButton;
    private JButton optionsButton;
    private JButton resultsButton;
    private JButton deleteButton;
    private JButton resetButton;
    private JButton exportButton;
    private JButton loadButton;
    private JButton exportimgButton;
    private JButton measureButton;
    private boolean keepOriginal = false;
    private CellCntrImageCanvas ic;
    private ImagePlus img;
    private ImagePlus counterImg;
    private GridLayout dynGrid;
    static CellCounter instance;
    public static final int SAVE = 1;
    public static final int OPEN = 0;

    public CellCounter() {
        super("Cell Counter");
        this.setResizable(false);
        this.typeVector = new Vector();
        this.txtFieldVector = new Vector();
        this.dynRadioVector = new Vector();
        this.initGUI();
        this.populateTxtFields();
        instance = this;
    }

    private void initGUI() {
        this.setDefaultCloseOperation(2);
        GridBagLayout gb = new GridBagLayout();
        this.getContentPane().setLayout(gb);
        this.radioGrp = new ButtonGroup();
        this.dynGrid = new GridLayout(8, 1);
        this.dynGrid.setVgap(2);
        this.dynPanel = new JPanel();
        this.dynPanel.setBorder(BorderFactory.createTitledBorder("Counters"));
        this.dynPanel.setLayout(gb);
        this.dynButtonPanel = new JPanel();
        this.dynButtonPanel.setLayout(this.dynGrid);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.ipadx = 5;
        gb.setConstraints(this.dynButtonPanel, gbc);
        this.dynPanel.add(this.dynButtonPanel);
        this.dynTxtPanel = new JPanel();
        this.dynTxtPanel.setLayout(this.dynGrid);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.ipadx = 5;
        gb.setConstraints(this.dynTxtPanel, gbc);
        this.dynPanel.add(this.dynTxtPanel);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.ipadx = 5;
        gb.setConstraints(this.dynPanel, gbc);
        this.getContentPane().add(this.dynPanel);
        this.dynButtonPanel.add(this.makeDynRadioButton(1));
        this.dynButtonPanel.add(this.makeDynRadioButton(2));
        this.dynButtonPanel.add(this.makeDynRadioButton(3));
        this.dynButtonPanel.add(this.makeDynRadioButton(4));
        this.dynButtonPanel.add(this.makeDynRadioButton(5));
        this.dynButtonPanel.add(this.makeDynRadioButton(6));
        this.dynButtonPanel.add(this.makeDynRadioButton(7));
        this.dynButtonPanel.add(this.makeDynRadioButton(8));
        this.statButtonPanel = new JPanel();
        this.statButtonPanel.setBorder(BorderFactory.createTitledBorder("Actions"));
        this.statButtonPanel.setLayout(gb);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.newCheck = new JCheckBox(KEEPORIGINAL);
        this.newCheck.setToolTipText("Keep original");
        this.newCheck.setSelected(false);
        this.newCheck.addItemListener(this);
        gb.setConstraints(this.newCheck, gbc);
        this.statButtonPanel.add(this.newCheck);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.initializeButton = this.makeButton(INITIALIZE, "Initialize image to count");
        gb.setConstraints(this.initializeButton, gbc);
        this.statButtonPanel.add(this.initializeButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(3, 0, 3, 0);
        this.separator = new JSeparator(0);
        this.separator.setPreferredSize(new Dimension(1, 1));
        gb.setConstraints(this.separator, gbc);
        this.statButtonPanel.add(this.separator);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.addButton = this.makeButton(ADD, "add a counter type");
        gb.setConstraints(this.addButton, gbc);
        this.statButtonPanel.add(this.addButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.removeButton = this.makeButton(REMOVE, "remove last counter type");
        gb.setConstraints(this.removeButton, gbc);
        this.statButtonPanel.add(this.removeButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.renameButton = this.makeButton(RENAME, "rename selected counter type");
        this.renameButton.setEnabled(false);
        gb.setConstraints(this.renameButton, gbc);
        this.statButtonPanel.add(this.renameButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.insets = new Insets(3, 0, 3, 0);
        gbc.gridwidth = 0;
        this.separator = new JSeparator(0);
        this.separator.setPreferredSize(new Dimension(1, 1));
        gb.setConstraints(this.separator, gbc);
        this.statButtonPanel.add(this.separator);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.deleteButton = this.makeButton(DELETE, "delete last marker");
        this.deleteButton.setEnabled(false);
        gb.setConstraints(this.deleteButton, gbc);
        this.statButtonPanel.add(this.deleteButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.delCheck = new JCheckBox(DELMODE);
        this.delCheck.setToolTipText("When selected\nclick on the marker\nyou want to remove");
        this.delCheck.setSelected(false);
        this.delCheck.addItemListener(this);
        this.delCheck.setEnabled(false);
        gb.setConstraints(this.delCheck, gbc);
        this.statButtonPanel.add(this.delCheck);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(3, 0, 3, 0);
        this.separator = new JSeparator(0);
        this.separator.setPreferredSize(new Dimension(1, 1));
        gb.setConstraints(this.separator, gbc);
        this.statButtonPanel.add(this.separator);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        gbc.gridwidth = 0;
        this.optionsButton = this.makeButton(OPTIONS, "show options dialog");
        gb.setConstraints(this.optionsButton, gbc);
        this.statButtonPanel.add(this.optionsButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        gbc.gridwidth = 0;
        this.resultsButton = this.makeButton(RESULTS, "show results in results table");
        this.resultsButton.setEnabled(false);
        gb.setConstraints(this.resultsButton, gbc);
        this.statButtonPanel.add(this.resultsButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.resetButton = this.makeButton(RESET, "reset all counters");
        this.resetButton.setEnabled(false);
        gb.setConstraints(this.resetButton, gbc);
        this.statButtonPanel.add(this.resetButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(3, 0, 3, 0);
        this.separator = new JSeparator(0);
        this.separator.setPreferredSize(new Dimension(1, 1));
        gb.setConstraints(this.separator, gbc);
        this.statButtonPanel.add(this.separator);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.numbersCheck = new JCheckBox(SHOWNUMBERS);
        this.numbersCheck.setToolTipText("When selected, numbers are shown");
        this.numbersCheck.setSelected(true);
        this.numbersCheck.setEnabled(false);
        this.numbersCheck.addItemListener(this);
        gb.setConstraints(this.numbersCheck, gbc);
        this.statButtonPanel.add(this.numbersCheck);
        this.showAllCheck = new JCheckBox(SHOWALL);
        this.showAllCheck.setToolTipText("When selected, all stack markers are shown");
        this.showAllCheck.setSelected(false);
        this.showAllCheck.setEnabled(false);
        this.showAllCheck.addItemListener(this);
        gb.setConstraints(this.showAllCheck, gbc);
        this.statButtonPanel.add(this.showAllCheck);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.exportButton = this.makeButton(EXPORTMARKERS, "Save markers to file");
        this.exportButton.setEnabled(false);
        gb.setConstraints(this.exportButton, gbc);
        this.statButtonPanel.add(this.exportButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.loadButton = this.makeButton(LOADMARKERS, "Load markers from file");
        gb.setConstraints(this.loadButton, gbc);
        this.statButtonPanel.add(this.loadButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.exportimgButton = this.makeButton(EXPORTIMG, "Export image with markers");
        this.exportimgButton.setEnabled(false);
        gb.setConstraints(this.exportimgButton, gbc);
        this.statButtonPanel.add(this.exportimgButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(3, 0, 3, 0);
        this.separator = new JSeparator(0);
        this.separator.setPreferredSize(new Dimension(1, 1));
        gb.setConstraints(this.separator, gbc);
        this.statButtonPanel.add(this.separator);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.measureButton = this.makeButton(MEASURE, "Measure pixel intensity of marker points");
        this.measureButton.setEnabled(false);
        gb.setConstraints(this.measureButton, gbc);
        this.statButtonPanel.add(this.measureButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.ipadx = 5;
        gb.setConstraints(this.statButtonPanel, gbc);
        this.getContentPane().add(this.statButtonPanel);
        GUIShower runner = new GUIShower(this);
        EventQueue.invokeLater(runner);
    }

    private JTextField makeDynamicTextArea() {
        JTextField txtFld = new JTextField();
        txtFld.setHorizontalAlignment(0);
        txtFld.setBorder(BorderFactory.createEtchedBorder(1));
        txtFld.setEditable(false);
        txtFld.setText("0");
        this.txtFieldVector.add(txtFld);
        return txtFld;
    }

    void populateTxtFields() {
        ListIterator<CellCntrMarkerVector> it = this.typeVector.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            if (this.txtFieldVector.size() <= index) continue;
            CellCntrMarkerVector markerVector = it.next();
            int count = markerVector.size();
            JTextField tArea = this.txtFieldVector.get(index);
            tArea.setText("" + count);
        }
        this.validateLayout();
    }

    private JRadioButton makeDynRadioButton(int id) {
        JRadioButton jrButton = new JRadioButton("Type " + id);
        jrButton.setActionCommand(TYPE_COMMAND_PREFIX + id);
        jrButton.addActionListener(this);
        this.dynRadioVector.add(jrButton);
        this.radioGrp.add(jrButton);
        String markerName = "Type " + id;
        this.markerVector = new CellCntrMarkerVector(id, markerName);
        this.typeVector.add(this.markerVector);
        this.dynTxtPanel.add(this.makeDynamicTextArea());
        return jrButton;
    }

    private JButton makeButton(String name, String tooltip) {
        JButton jButton = new JButton(name);
        jButton.setToolTipText(tooltip);
        jButton.addActionListener(this);
        return jButton;
    }

    private void initializeImage() {
        boolean v139t;
        this.reset();
        this.img = WindowManager.getCurrentImage();
        boolean bl = v139t = IJ.getVersion().compareTo("1.39t") >= 0;
        if (this.img == null) {
            IJ.noImage();
        } else if (this.img.getStackSize() == 1) {
            ImageProcessor ip = this.img.getProcessor();
            ip.resetRoi();
            if (this.keepOriginal) {
                ip = ip.crop();
            }
            this.counterImg = new ImagePlus("Counter Window - " + this.img.getTitle(), ip);
            Vector displayList = v139t ? this.img.getCanvas().getDisplayList() : null;
            this.ic = new CellCntrImageCanvas(this.counterImg, this.typeVector, this, displayList);
            new ImageWindow(this.counterImg, (ImageCanvas)this.ic);
        } else if (this.img.getStackSize() > 1) {
            ImageStack stack = this.img.getStack();
            int size = stack.getSize();
            ImageStack counterStack = this.img.createEmptyStack();
            for (int i = 1; i <= size; ++i) {
                ImageProcessor ip = stack.getProcessor(i);
                if (this.keepOriginal) {
                    ip = ip.crop();
                }
                counterStack.addSlice(stack.getSliceLabel(i), ip);
            }
            this.counterImg = new ImagePlus("Counter Window - " + this.img.getTitle(), counterStack);
            this.counterImg.setDimensions(this.img.getNChannels(), this.img.getNSlices(), this.img.getNFrames());
            if (this.img.isComposite()) {
                this.counterImg = new CompositeImage(this.counterImg, ((CompositeImage)this.img).getMode());
                ((CompositeImage)this.counterImg).copyLuts(this.img);
            }
            this.counterImg.setOpenAsHyperStack(this.img.isHyperStack());
            Vector displayList = v139t ? this.img.getCanvas().getDisplayList() : null;
            this.ic = new CellCntrImageCanvas(this.counterImg, this.typeVector, this, displayList);
            new StackWindow(this.counterImg, (ImageCanvas)this.ic);
        }
        Calibration cal = this.img.getCalibration();
        this.counterImg.setCalibration(cal);
        this.metaData.put("X_Calibration", "" + cal.pixelWidth);
        this.metaData.put("Y_Calibration", "" + cal.pixelHeight);
        this.metaData.put("Z_Calibration", "" + cal.pixelDepth);
        this.metaData.put("Calibration_Unit", "" + cal.getUnit());
        if (!this.keepOriginal) {
            this.img.changes = false;
            this.img.close();
        }
        this.delCheck.setEnabled(true);
        this.numbersCheck.setEnabled(true);
        this.showAllCheck.setSelected(false);
        if (this.counterImg.getStackSize() > 1) {
            this.showAllCheck.setEnabled(true);
        }
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        this.renameButton.setEnabled(true);
        this.resultsButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
        this.resetButton.setEnabled(true);
        this.exportButton.setEnabled(true);
        this.exportimgButton.setEnabled(true);
        this.measureButton.setEnabled(true);
    }

    void validateLayout() {
        this.dynPanel.validate();
        this.dynButtonPanel.validate();
        this.dynTxtPanel.validate();
        this.statButtonPanel.validate();
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(ADD)) {
            int i = this.dynRadioVector.size() + 1;
            this.dynGrid.setRows(i);
            this.dynButtonPanel.add(this.makeDynRadioButton(i));
            this.validateLayout();
            if (this.ic != null) {
                this.ic.setTypeVector(this.typeVector);
            }
        } else if (command.equals(REMOVE)) {
            if (this.dynRadioVector.size() > 1) {
                JRadioButton rbutton = this.dynRadioVector.lastElement();
                this.dynButtonPanel.remove(rbutton);
                this.radioGrp.remove(rbutton);
                this.dynRadioVector.removeElementAt(this.dynRadioVector.size() - 1);
                this.dynGrid.setRows(this.dynRadioVector.size());
            }
            if (this.txtFieldVector.size() > 1) {
                JTextField field = this.txtFieldVector.lastElement();
                this.dynTxtPanel.remove(field);
                this.txtFieldVector.removeElementAt(this.txtFieldVector.size() - 1);
            }
            if (this.typeVector.size() > 1) {
                this.typeVector.removeElementAt(this.typeVector.size() - 1);
            }
            this.validateLayout();
            if (this.ic != null) {
                this.ic.setTypeVector(this.typeVector);
            }
        } else if (command.equals(RENAME)) {
            if (this.currentMarkerIndex < 0) {
                return;
            }
            JRadioButton button = this.dynRadioVector.get(this.currentMarkerIndex);
            String name = IJ.getString((String)"Enter new counter name", (String)button.getText());
            if (name == null || name.isEmpty()) {
                return;
            }
            this.radioGrp.remove(button);
            button.setText(name);
            this.radioGrp.add(button);
            this.currentMarkerVector.setName(name);
        } else if (command.equals(INITIALIZE)) {
            this.initializeImage();
        } else if (command.startsWith(TYPE_COMMAND_PREFIX)) {
            this.currentMarkerIndex = Integer.parseInt(command.substring(TYPE_COMMAND_PREFIX.length())) - 1;
            if (this.ic == null) {
                IJ.error((String)"You need to initialize first");
                return;
            }
            this.currentMarkerVector = this.typeVector.get(this.currentMarkerIndex);
            this.ic.setCurrentMarkerVector(this.currentMarkerVector);
        } else if (command.equals(DELETE)) {
            this.ic.removeLastMarker();
        } else if (command.equals(RESET)) {
            this.reset();
        } else if (command.equals(OPTIONS)) {
            this.options();
        } else if (command.equals(RESULTS)) {
            this.report();
        } else if (command.equals(EXPORTMARKERS)) {
            this.exportMarkers();
        } else if (command.equals(LOADMARKERS)) {
            if (this.ic == null) {
                this.initializeImage();
            }
            this.loadMarkers();
            this.validateLayout();
        } else if (command.equals(EXPORTIMG)) {
            this.ic.imageWithMarkers().show();
        } else if (command.equals(MEASURE)) {
            this.measure();
        }
        if (this.ic != null) {
            this.ic.repaint();
        }
        this.populateTxtFields();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItem().equals(this.delCheck)) {
            if (e.getStateChange() == 1) {
                this.ic.setDelmode(true);
            } else {
                this.ic.setDelmode(false);
            }
        } else if (e.getItem().equals(this.newCheck)) {
            this.keepOriginal = e.getStateChange() == 1;
        } else if (e.getItem().equals(this.numbersCheck)) {
            if (e.getStateChange() == 1) {
                this.ic.setShowNumbers(true);
            } else {
                this.ic.setShowNumbers(false);
            }
            this.ic.repaint();
        } else if (e.getItem().equals(this.showAllCheck)) {
            if (e.getStateChange() == 1) {
                this.ic.setShowAll(true);
            } else {
                this.ic.setShowAll(false);
            }
            this.ic.repaint();
        }
    }

    public void measure() {
        this.ic.measure();
    }

    public void reset() {
        if (this.typeVector.size() < 1) {
            return;
        }
        ListIterator<CellCntrMarkerVector> mit = this.typeVector.listIterator();
        while (mit.hasNext()) {
            CellCntrMarkerVector mv = mit.next();
            mv.clear();
        }
        if (this.ic != null) {
            this.ic.repaint();
        }
    }

    public void options() {
        Context c = (Context)IJ.runPlugIn((String)"org.scijava.Context", (String)"");
        CommandService commandService = (CommandService)c.service(CommandService.class);
        commandService.run(CellCounterOptions.class, true, new Object[0]);
    }

    public void report() {
        String labels = "Slice\t";
        boolean isStack = this.counterImg.getStackSize() > 1;
        ListIterator<JRadioButton> it = this.dynRadioVector.listIterator();
        while (it.hasNext()) {
            JRadioButton button = it.next();
            String str = button.getText();
            labels = labels.concat(str + "\t");
        }
        labels = labels.concat("\tC-pos\tZ-pos\tT-pos\t");
        IJ.setColumnHeadings((String)labels);
        String results = "";
        if (isStack) {
            for (int slice = 1; slice <= this.counterImg.getStackSize(); ++slice) {
                int[] realPosArray = this.counterImg.convertIndexToPosition(slice);
                int channel = realPosArray[0];
                int zPos = realPosArray[1];
                int frame = realPosArray[2];
                results = "";
                ListIterator<CellCntrMarkerVector> mit = this.typeVector.listIterator();
                int types = this.typeVector.size();
                int[] typeTotals = new int[types];
                while (mit.hasNext()) {
                    int type = mit.nextIndex();
                    CellCntrMarkerVector mv = mit.next();
                    ListIterator tit = mv.listIterator();
                    while (tit.hasNext()) {
                        CellCntrMarker m = (CellCntrMarker)tit.next();
                        if (m.getZ() != slice) continue;
                        int n = type;
                        typeTotals[n] = typeTotals[n] + 1;
                    }
                }
                results = results.concat(slice + "\t");
                for (int i = 0; i < typeTotals.length; ++i) {
                    results = results.concat(typeTotals[i] + "\t");
                }
                String cztPosition = String.format("%d\t%d\t%d\t", channel, zPos, frame);
                results = results.concat(cztPosition);
                IJ.write((String)results);
            }
            IJ.write((String)"");
        }
        results = "Total\t";
        ListIterator<CellCntrMarkerVector> mit = this.typeVector.listIterator();
        while (mit.hasNext()) {
            CellCntrMarkerVector mv = mit.next();
            int count = mv.size();
            results = results.concat(count + "\t");
        }
        IJ.write((String)results);
    }

    public void loadMarkers() {
        String filePath = this.getFilePath(new JFrame(), "Select Marker File", 0);
        ReadXML rxml = new ReadXML(filePath);
        String storedfilename = rxml.readImgProperties(0);
        if (storedfilename.equals(this.img.getTitle())) {
            Vector<CellCntrMarkerVector> loadedvector = rxml.readMarkerData();
            this.typeVector = loadedvector;
            this.ic.setTypeVector(this.typeVector);
            int index = Integer.parseInt(rxml.readImgProperties(1));
            this.currentMarkerVector = this.typeVector.get(index);
            this.ic.setCurrentMarkerVector(this.currentMarkerVector);
            while (this.dynRadioVector.size() > this.typeVector.size()) {
                if (this.dynRadioVector.size() > 1) {
                    JRadioButton rbutton = this.dynRadioVector.lastElement();
                    this.dynButtonPanel.remove(rbutton);
                    this.radioGrp.remove(rbutton);
                    this.dynRadioVector.removeElementAt(this.dynRadioVector.size() - 1);
                    this.dynGrid.setRows(this.dynRadioVector.size());
                }
                if (this.txtFieldVector.size() <= 1) continue;
                JTextField field = this.txtFieldVector.lastElement();
                this.dynTxtPanel.remove(field);
                this.txtFieldVector.removeElementAt(this.txtFieldVector.size() - 1);
            }
            while (this.dynRadioVector.size() < this.typeVector.size()) {
                int i = this.dynRadioVector.size() + 1;
                this.dynGrid.setRows(i);
                JRadioButton jrButton = new JRadioButton("Type " + i);
                jrButton.setActionCommand(TYPE_COMMAND_PREFIX + i);
                jrButton.addActionListener(this);
                this.dynRadioVector.add(jrButton);
                this.radioGrp.add(jrButton);
                this.dynTxtPanel.add(this.makeDynamicTextArea());
                this.dynButtonPanel.add(jrButton);
                this.typeVector.get(index);
                this.validateLayout();
            }
            ListIterator<CellCntrMarkerVector> it = this.typeVector.listIterator();
            while (it.hasNext()) {
                int i = it.nextIndex();
                CellCntrMarkerVector markerVector = it.next();
                String name = markerVector.getName();
                JRadioButton button = this.dynRadioVector.get(i);
                this.radioGrp.remove(button);
                button.setText(name);
                this.radioGrp.add(button);
            }
            JRadioButton butt = this.dynRadioVector.get(index);
            butt.setSelected(true);
        } else {
            IJ.error((String)"These Markers do not belong to the current image");
        }
    }

    public void exportMarkers() {
        String filePath = this.getFilePath(new JFrame(), "Save Marker File (.xml)", 1);
        if (!filePath.endsWith(".xml")) {
            filePath = filePath + ".xml";
        }
        WriteXML wxml = new WriteXML(filePath);
        wxml.writeXML(this.img.getTitle(), this.typeVector, this.typeVector.indexOf(this.currentMarkerVector), this.metaData);
    }

    private String getFilePath(JFrame parent, String dialogMessage, int dialogType) {
        switch (dialogType) {
            case 1: {
                dialogMessage = "Save " + dialogMessage;
                break;
            }
            case 0: {
                dialogMessage = "Open " + dialogMessage;
            }
        }
        String[] filePathComponents = new String[2];
        boolean PATH = false;
        boolean FILE = true;
        FileDialog fd = new FileDialog((Frame)parent, dialogMessage, dialogType);
        switch (dialogType) {
            case 1: {
                String filename = this.img.getTitle();
                fd.setFile("CellCounter_" + filename.substring(0, filename.lastIndexOf(".") + 1) + "xml");
            }
        }
        fd.setVisible(true);
        filePathComponents[0] = fd.getDirectory();
        filePathComponents[1] = fd.getFile();
        return filePathComponents[0] + filePathComponents[1];
    }

    public Vector<JRadioButton> getButtonVector() {
        return this.dynRadioVector;
    }

    public void setButtonVector(Vector<JRadioButton> buttonVector) {
        this.dynRadioVector = buttonVector;
    }

    public CellCntrMarkerVector getCurrentMarkerVector() {
        return this.currentMarkerVector;
    }

    public void setCurrentMarkerVector(CellCntrMarkerVector currentMarkerVector) {
        this.currentMarkerVector = currentMarkerVector;
    }

    public static void setType(String type) {
        if (instance == null || CellCounter.instance.ic == null || type == null) {
            return;
        }
        int index = Integer.parseInt(type) - 1;
        int buttons = CellCounter.instance.dynRadioVector.size();
        if (index < 0 || index >= buttons) {
            return;
        }
        JRadioButton rbutton = CellCounter.instance.dynRadioVector.elementAt(index);
        CellCounter.instance.radioGrp.setSelected(rbutton.getModel(), true);
        CellCounter.instance.currentMarkerVector = CellCounter.instance.typeVector.get(index);
        CellCounter.instance.ic.setCurrentMarkerVector(CellCounter.instance.currentMarkerVector);
    }

    private static class GUIShower
    implements Runnable {
        final JFrame jFrame;

        public GUIShower(JFrame jFrame) {
            this.jFrame = jFrame;
        }

        @Override
        public void run() {
            this.jFrame.pack();
            this.jFrame.setLocation(1000, 200);
            this.jFrame.setVisible(true);
        }
    }
}

