/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.LocalOrientFilter;
import edu.mines.jtk.util.ArrayMath;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LocalOrientFilterTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(LocalOrientFilterTest.class);
        TestRunner.run((Test)suite);
    }

    public void test2() {
        float[] dips;
        double sigma = 8.0;
        int n1 = 1 + 4 * (int)(3.0 * sigma);
        int n2 = n1 + 2;
        LocalOrientFilter lof = new LocalOrientFilter(sigma);
        float pi = (float)Math.PI;
        for (float dip : dips = new float[]{-0.49f * pi, -0.2f * pi, -0.01f, 0.01f, 0.2f * pi, 0.49f * pi}) {
            float k = 0.3f;
            float c = k * ArrayMath.cos(dip);
            float s = k * ArrayMath.sin(dip);
            float[][] x = ArrayMath.sin(ArrayMath.rampfloat(0.0f, c, s, n1, n2));
            float[][] theta = new float[n2][n1];
            float[][] u1 = new float[n2][n1];
            float[][] u2 = new float[n2][n1];
            float[][] v1 = new float[n2][n1];
            float[][] v2 = new float[n2][n1];
            float[][] eu = new float[n2][n1];
            float[][] ev = new float[n2][n1];
            float[][] el = new float[n2][n1];
            lof.apply(x, theta, u1, u2, v1, v2, eu, ev, el);
            LocalOrientFilterTest.assertEqual((double)dip, theta, 0.01);
            LocalOrientFilterTest.assertEqual((double)ArrayMath.cos(dip), u1, 0.01);
            LocalOrientFilterTest.assertEqual((double)ArrayMath.sin(dip), u2, 0.01);
            LocalOrientFilterTest.assertEqual((double)(-ArrayMath.sin(dip)), v1, 0.01);
            LocalOrientFilterTest.assertEqual((double)ArrayMath.cos(dip), v2, 0.01);
            LocalOrientFilterTest.assertEqual(1.0, el, 0.01);
        }
    }

    public void test3Planar() {
        double sigma = 6.0;
        int n1 = 1 + 2 * (int)(3.0 * sigma);
        int n2 = n1 + 2;
        int n3 = n2 + 2;
        LocalOrientFilter lof = new LocalOrientFilter(sigma);
        float pi = (float)Math.PI;
        float[] azis = new float[]{-0.5f * pi, 0.25f * pi, 0.99f * pi};
        float[] dips = new float[]{0.01f * pi, 0.2f * pi, 0.49f * pi};
        for (float azi : azis) {
            for (float dip : dips) {
                float k = 0.3f;
                float ku1 = k * ArrayMath.cos(dip);
                float ku2 = k * ArrayMath.sin(dip) * ArrayMath.cos(azi);
                float ku3 = k * ArrayMath.sin(dip) * ArrayMath.sin(azi);
                float[][][] x = ArrayMath.sin(ArrayMath.rampfloat(0.0f, ku1, ku2, ku3, n1, n2, n3));
                float[][][] theta = new float[n3][n2][n1];
                float[][][] phi = new float[n3][n2][n1];
                float[][][] u1 = new float[n3][n2][n1];
                float[][][] u2 = new float[n3][n2][n1];
                float[][][] u3 = new float[n3][n2][n1];
                float[][][] v1 = new float[n3][n2][n1];
                float[][][] v2 = new float[n3][n2][n1];
                float[][][] v3 = new float[n3][n2][n1];
                float[][][] w1 = new float[n3][n2][n1];
                float[][][] w2 = new float[n3][n2][n1];
                float[][][] w3 = new float[n3][n2][n1];
                float[][][] eu = new float[n3][n2][n1];
                float[][][] ev = new float[n3][n2][n1];
                float[][][] ew = new float[n3][n2][n1];
                float[][][] ep = new float[n3][n2][n1];
                float[][][] el = new float[n3][n2][n1];
                lof.apply(x, theta, phi, u1, u2, u3, v1, v2, v3, w1, w2, w3, eu, ev, ew, ep, el);
                LocalOrientFilterTest.assertEqual((double)dip, theta, 0.02);
                LocalOrientFilterTest.assertEqual((double)azi, phi, 0.02);
                LocalOrientFilterTest.assertEqual((double)ArrayMath.cos(dip), u1, 0.02);
                LocalOrientFilterTest.assertEqual((double)(ArrayMath.sin(dip) * ArrayMath.cos(azi)), u2, 0.02);
                LocalOrientFilterTest.assertEqual((double)(ArrayMath.sin(dip) * ArrayMath.sin(azi)), u3, 0.02);
                LocalOrientFilterTest.assertEqual(1.0, ep, 0.02);
                LocalOrientFilterTest.assertEqual(0.0, el, 0.02);
            }
        }
    }

    public void test3Linear() {
        double sigma = 6.0;
        int n1 = 1 + 2 * (int)(3.0 * sigma);
        int n2 = n1 + 2;
        int n3 = n2 + 2;
        LocalOrientFilter lof = new LocalOrientFilter(sigma);
        float pi = (float)Math.PI;
        float[] azis = new float[]{-0.5f * pi, 0.25f * pi, 0.99f * pi};
        float[] dips = new float[]{0.01f * pi, 0.2f * pi, 0.49f * pi};
        for (float azi : azis) {
            for (float dip : dips) {
                float a1 = (n1 - 1) / 2;
                float a2 = (n2 - 1) / 2;
                float a3 = (n3 - 1) / 2;
                float b1 = ArrayMath.cos(dip);
                float b2 = ArrayMath.sin(dip) * ArrayMath.cos(azi);
                float b3 = ArrayMath.sin(dip) * ArrayMath.sin(azi);
                float[][][] x = new float[n3][n2][n1];
                for (int i3 = 0; i3 < n3; ++i3) {
                    float x3 = (float)i3 - a3;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        float x2 = (float)i2 - a2;
                        for (int i1 = 0; i1 < n1; ++i1) {
                            float x1 = (float)i1 - a1;
                            float t = x1 * b1 + x2 * b2 + x3 * b3;
                            float d1 = x1 - t * b1;
                            float d2 = x2 - t * b2;
                            float d3 = x3 - t * b3;
                            x[i3][i2][i1] = ArrayMath.exp(-0.125f * (d1 * d1 + d2 * d2 + d3 * d3));
                        }
                    }
                }
                float[][][] theta = new float[n3][n2][n1];
                float[][][] phi = new float[n3][n2][n1];
                float[][][] u1 = new float[n3][n2][n1];
                float[][][] u2 = new float[n3][n2][n1];
                float[][][] u3 = new float[n3][n2][n1];
                float[][][] v1 = new float[n3][n2][n1];
                float[][][] v2 = new float[n3][n2][n1];
                float[][][] v3 = new float[n3][n2][n1];
                float[][][] w1 = new float[n3][n2][n1];
                float[][][] w2 = new float[n3][n2][n1];
                float[][][] w3 = new float[n3][n2][n1];
                float[][][] eu = new float[n3][n2][n1];
                float[][][] ev = new float[n3][n2][n1];
                float[][][] ew = new float[n3][n2][n1];
                float[][][] ep = new float[n3][n2][n1];
                float[][][] el = new float[n3][n2][n1];
                lof.apply(x, theta, phi, u1, u2, u3, v1, v2, v3, w1, w2, w3, eu, ev, ew, ep, el);
                LocalOrientFilterTest.assertAbsEqual(ArrayMath.cos(dip), w1, 0.1);
                LocalOrientFilterTest.assertAbsEqual(ArrayMath.sin(dip) * ArrayMath.cos(azi), w2, 0.1);
                LocalOrientFilterTest.assertAbsEqual(ArrayMath.sin(dip) * ArrayMath.sin(azi), w3, 0.1);
                LocalOrientFilterTest.assertEqual(0.0, ep, 0.2);
                LocalOrientFilterTest.assertEqual(1.0, el, 0.2);
            }
        }
    }

    private static void assertEqual(double e, float[][] a, double tol) {
        int n1 = a[0].length;
        int n2 = a.length;
        LocalOrientFilterTest.assertEquals((double)e, (double)a[n2 / 2][n1 / 2], (double)tol);
    }

    private static void assertEqual(double e, float[][][] a, double tol) {
        int n1 = a[0][0].length;
        int n2 = a[0].length;
        int n3 = a.length;
        LocalOrientFilterTest.assertEquals((double)e, (double)a[n3 / 2][n2 / 2][n1 / 2], (double)tol);
    }

    private static void assertAbsEqual(double e, float[][][] a, double tol) {
        int n1 = a[0][0].length;
        int n2 = a[0].length;
        int n3 = a.length;
        LocalOrientFilterTest.assertEquals((double)ArrayMath.abs(e), (double)ArrayMath.abs(a[n3 / 2][n2 / 2][n1 / 2]), (double)tol);
    }
}

