/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import edu.mines.jtk.dsp.RecursiveGaussianFilter;
import edu.mines.jtk.dsp.SincInterpolator;
import edu.mines.jtk.util.ArrayMath;

public class SteerablePyramid {
    private static final double THETA0 = 0.0;
    private static final double THETA1 = 1.0471975511965976;
    private static final double THETA2 = 2.0943951023931953;
    private static final double ONE_THIRD = 0.3333333333333333;
    private static final float TWO_THIRDS = 0.6666667f;
    private static final double SQRT3 = ArrayMath.sqrt(3.0);
    private static final int NDIR2 = 3;
    private static final int NDIR3 = 6;
    private static final double ABC_SMALL = 0.01;
    private static final double DET_SMALL = 1.0E-40;
    private static final double COS_PIO3 = ArrayMath.cos(1.0471975511965976);
    private static final double SIN_PIO3 = ArrayMath.sin(1.0471975511965976);
    private int nlev;
    private int nx1;
    private int nx2;
    private int nx3;
    private int n1;
    private int n2;
    private int n3;
    private boolean statelinear;
    double ka;
    double kb;

    public SteerablePyramid() {
        this.ka = 0.6;
        this.kb = 1.0;
    }

    public SteerablePyramid(double ka, double kb) {
        this.ka = ka;
        this.kb = kb;
    }

    public float[][][][] makePyramid(float[][] x) {
        this.nx2 = x.length;
        this.nx1 = x[0].length;
        this.nlev = 1;
        int nlev2 = 1;
        this.n1 = 9;
        this.n2 = 9;
        while (this.nx1 > this.n1) {
            this.n1 = (this.n1 - 1) * 2 + 1;
            ++this.nlev;
        }
        while (this.nx2 > this.n2) {
            this.n2 = (this.n2 - 1) * 2 + 1;
            ++nlev2;
        }
        if (this.nlev > nlev2) {
            this.nlev = nlev2;
        }
        float[][][][] spyr = new float[this.nlev + 1][1][1][1];
        for (int lev = 0; lev < this.nlev; ++lev) {
            int lfactor = (int)ArrayMath.pow(2.0, (double)lev);
            int nl2 = (this.n2 - 1) / lfactor + 1;
            int nl1 = (this.n1 - 1) / lfactor + 1;
            spyr[lev] = ArrayMath.zerofloat(nl1, nl2, 3);
        }
        int lfactor = (int)ArrayMath.pow(2.0, (double)this.nlev);
        int nl2 = (this.n2 - 1) / lfactor + 1;
        int nl1 = (this.n1 - 1) / lfactor + 1;
        spyr[this.nlev] = ArrayMath.zerofloat(nl1, nl2, 1);
        float[][] cf = this.ftForward(0, x);
        this.applyRadial(this.ka, this.kb, cf);
        for (int lev = 0; lev < this.nlev; ++lev) {
            if (lev > 0) {
                cf = this.ftForward(lev, spyr[lev][0]);
            }
            this.makePyramidLevel(lev, cf, spyr);
        }
        return spyr;
    }

    public float[][][][][] makePyramid(float[][][] x) {
        this.nx3 = x.length;
        this.nx2 = x[0].length;
        this.nx1 = x[0][0].length;
        this.nlev = 1;
        int nlev2 = 1;
        int nlev3 = 1;
        this.n1 = 9;
        this.n2 = 9;
        this.n3 = 9;
        while (this.nx1 > this.n1) {
            this.n1 = (this.n1 - 1) * 2 + 1;
            ++this.nlev;
        }
        while (this.nx2 > this.n2) {
            this.n2 = (this.n2 - 1) * 2 + 1;
            ++nlev2;
        }
        while (this.nx3 > this.n3) {
            this.n3 = (this.n3 - 1) * 2 + 1;
            ++nlev3;
        }
        if (this.nlev > nlev2) {
            this.nlev = nlev2;
        }
        if (this.nlev > nlev3) {
            this.nlev = nlev3;
        }
        float[][][][][] spyr = new float[this.nlev + 1][1][1][1][1];
        for (int lev = 0; lev < this.nlev; ++lev) {
            int lfactor = (int)ArrayMath.pow(2.0, (double)lev);
            int nl3 = (this.n3 - 1) / lfactor + 1;
            int nl2 = (this.n2 - 1) / lfactor + 1;
            int nl1 = (this.n1 - 1) / lfactor + 1;
            spyr[lev] = new float[6][1][1][1];
            for (int dir = 0; dir < 6; ++dir) {
                spyr[lev][dir] = ArrayMath.zerofloat(nl1, nl2, nl3);
            }
        }
        int lfactor = (int)ArrayMath.pow(2.0, (double)this.nlev);
        int nl3 = (this.n3 - 1) / lfactor + 1;
        int nl2 = (this.n2 - 1) / lfactor + 1;
        int nl1 = (this.n1 - 1) / lfactor + 1;
        spyr[this.nlev][0] = ArrayMath.zerofloat(nl1, nl2, nl3);
        float[][][] cf = this.ftForward(0, x);
        this.applyRadial(this.ka, this.kb, cf);
        for (int lev = 0; lev < this.nlev; ++lev) {
            if (lev > 0) {
                cf = this.ftForward(lev, spyr[lev][0]);
            }
            this.makePyramidLevel(lev, cf, spyr);
        }
        return spyr;
    }

    public float[][] sumPyramid(boolean keeplow, float[][][][] spyr) {
        if (!keeplow) {
            ArrayMath.zero(spyr[this.nlev][0]);
        }
        int lfactor = (int)ArrayMath.pow(2.0, (double)(this.nlev - 1));
        int nl2 = (this.n2 - 1) / lfactor + 1;
        int nl1 = (this.n1 - 1) / lfactor + 1;
        for (int i = 0; i < this.nlev; ++i) {
            int lev = this.nlev - i - 1;
            for (int dir = 1; dir < 3; ++dir) {
                ArrayMath.add(spyr[lev][0], spyr[lev][dir], spyr[lev][0]);
            }
            int m2 = (nl2 - 1) / 2 + 1;
            int m1 = (nl1 - 1) / 2 + 1;
            SincInterpolator si = new SincInterpolator();
            si.setExtrapolation(SincInterpolator.Extrapolation.CONSTANT);
            for (int i2 = 0; i2 < nl2; ++i2) {
                for (int i1 = 0; i1 < nl1; ++i1) {
                    float[] fArray = spyr[lev][0][i2];
                    int n = i1;
                    fArray[n] = fArray[n] + si.interpolate(m1, 2.0, 0.0, m2, 2.0, 0.0, spyr[lev + 1][0], i1, i2);
                }
            }
            nl2 = (nl2 - 1) * 2 + 1;
            nl1 = (nl1 - 1) * 2 + 1;
        }
        float[][] y = ArrayMath.zerofloat(this.nx1, this.nx2);
        ArrayMath.copy(this.nx1, this.nx2, spyr[0][0], y);
        return y;
    }

    public float[][][] sumPyramid(boolean keeplow, float[][][][][] spyr) {
        if (!keeplow) {
            ArrayMath.zero(spyr[this.nlev][0]);
        }
        int lfactor = (int)ArrayMath.pow(2.0, (double)(this.nlev - 1));
        int nl3 = (this.n3 - 1) / lfactor + 1;
        int nl2 = (this.n2 - 1) / lfactor + 1;
        int nl1 = (this.n1 - 1) / lfactor + 1;
        for (int i = 0; i < this.nlev; ++i) {
            int i1;
            int j2;
            int j3;
            int i3;
            int lev = this.nlev - i - 1;
            for (int dir = 1; dir < 6; ++dir) {
                ArrayMath.add(spyr[lev][0], spyr[lev][dir], spyr[lev][0]);
            }
            int m3 = (nl3 - 1) / 2 + 1;
            int m2 = (nl2 - 1) / 2 + 1;
            int m1 = (nl1 - 1) / 2 + 1;
            float[] lo11 = ArrayMath.zerofloat(m1);
            float[] lo12 = ArrayMath.zerofloat(m2);
            float[] lo13 = ArrayMath.zerofloat(m3);
            SincInterpolator si = SincInterpolator.fromErrorAndFrequency(0.001, 0.4);
            si.setExtrapolation(SincInterpolator.Extrapolation.CONSTANT);
            for (i3 = 0; i3 < nl3; i3 += 2) {
                j3 = i3 / 2;
                for (int i2 = 0; i2 < nl2; i2 += 2) {
                    int i12;
                    j2 = i2 / 2;
                    for (i12 = 0; i12 < nl1; i12 += 2) {
                        int j1 = i12 / 2;
                        lo11[j1] = spyr[lev + 1][0][j3][j2][j1];
                        spyr[lev][1][i3][i2][i12] = lo11[j1];
                    }
                    for (i12 = 1; i12 < nl1; i12 += 2) {
                        spyr[lev][1][i3][i2][i12] = si.interpolate(m1, 2.0, 0.0, lo11, (double)i12);
                    }
                }
            }
            for (i3 = 0; i3 < nl3; i3 += 2) {
                for (i1 = 0; i1 < nl1; ++i1) {
                    int i2;
                    for (i2 = 0; i2 < nl2; i2 += 2) {
                        j2 = i2 / 2;
                        lo12[j2] = spyr[lev][1][i3][i2][i1];
                    }
                    for (i2 = 1; i2 < nl2; i2 += 2) {
                        spyr[lev][1][i3][i2][i1] = si.interpolate(m2, 2.0, 0.0, lo12, (double)i2);
                    }
                }
            }
            for (int i2 = 0; i2 < nl2; ++i2) {
                for (i1 = 0; i1 < nl1; ++i1) {
                    int i32;
                    for (i32 = 0; i32 < nl3; i32 += 2) {
                        j3 = i32 / 2;
                        lo13[j3] = spyr[lev][1][i32][i2][i1];
                    }
                    for (i32 = 1; i32 < nl3; i32 += 2) {
                        spyr[lev][1][i32][i2][i1] = si.interpolate(m3, 2.0, 0.0, lo13, (double)i32);
                    }
                }
            }
            ArrayMath.add(spyr[lev][0], spyr[lev][1], spyr[lev][0]);
            nl3 = (nl3 - 1) * 2 + 1;
            nl2 = (nl2 - 1) * 2 + 1;
            nl1 = (nl1 - 1) * 2 + 1;
        }
        float[][][] y = ArrayMath.zerofloat(this.nx1, this.nx2, this.nx3);
        ArrayMath.copy(this.nx1, this.nx2, this.nx3, spyr[0][0], y);
        return y;
    }

    public float[][][][] estimateAttributes(double sigma, float[][][][] spyr) {
        double sigmaa = 2.0 * sigma;
        double sigmac = 0.5 * sigma;
        float[][][][] attr = new float[this.nlev][2][1][1];
        for (int lev = 0; lev < this.nlev; ++lev) {
            int lfactor = (int)ArrayMath.pow(2.0, (double)lev);
            int nl2 = (this.n2 - 1) / lfactor + 1;
            int nl1 = (this.n1 - 1) / lfactor + 1;
            for (int j = 0; j < 2; ++j) {
                attr[lev][j] = ArrayMath.zerofloat(nl1, nl2);
            }
        }
        for (int levb = 0; levb < this.nlev; ++levb) {
            int j;
            int i1b;
            int i2b;
            float[][][] pqja;
            int leva = levb - 1;
            int levc = levb + 1;
            float[][][] pqjb = this.pqjShiftSmooth(sigma, levb, spyr);
            int nl2 = pqjb[0].length;
            int nl1 = pqjb[0][0].length;
            if (leva >= 0) {
                pqja = this.pqjShiftSmooth(sigmaa, leva, spyr);
                for (i2b = 0; i2b < nl2; ++i2b) {
                    for (i1b = 0; i1b < nl1; ++i1b) {
                        int i1a = 2 * i1b;
                        int i2a = 2 * i2b;
                        for (j = 0; j < 3; ++j) {
                            float[] fArray = pqjb[j][i2b];
                            int n = i1b;
                            fArray[n] = fArray[n] + pqja[j][i2a][i1a];
                        }
                    }
                }
            }
            if (levc < this.nlev) {
                pqja = this.pqjShiftSmooth(sigmac, levc, spyr);
                for (i2b = 0; i2b < nl2; ++i2b) {
                    for (i1b = 0; i1b < nl1; ++i1b) {
                        int i1c = (int)((double)ArrayMath.round((double)i1b) * 0.5);
                        int i2c = (int)((double)ArrayMath.round((double)i2b) * 0.5);
                        for (j = 0; j < 3; ++j) {
                            float[] fArray = pqjb[j][i2b];
                            int n = i1b;
                            fArray[n] = fArray[n] + pqja[j][i2c][i1c];
                        }
                    }
                }
            }
            for (int i2b2 = 0; i2b2 < nl2; ++i2b2) {
                for (int i1b2 = 0; i1b2 < nl1; ++i1b2) {
                    double a0 = pqjb[0][i2b2][i1b2];
                    double a1 = pqjb[1][i2b2][i1b2];
                    double a2 = pqjb[2][i2b2][i1b2];
                    double[][] feout = SteerablePyramid.findExtrema(a0, a1, a2);
                    attr[levb][0][i2b2][i1b2] = (float)feout[0][0];
                    double e0 = SteerablePyramid.eval0(a0, a1, a2, feout[0][0]);
                    double e1 = SteerablePyramid.eval0(a0, a1, a2, feout[1][0]);
                    attr[levb][1][i2b2][i1b2] = (float)((e0 - e1) / e0);
                }
            }
        }
        return attr;
    }

    public float[][][][][] estimateAttributes(boolean forlinear, double sigma, float[][][][][] spyr) {
        double sigmaa = 2.0 * sigma;
        double sigmac = 0.5 * sigma;
        double[] f = ArrayMath.zerodouble(6);
        double[][] abcf = ArrayMath.zerodouble(4, 3);
        int abcindx = 2;
        int e0indx = 2;
        int e1indx = 1;
        this.statelinear = forlinear;
        if (forlinear) {
            abcindx = 0;
            e0indx = 1;
            e1indx = 0;
        }
        float[][][][][] attr = new float[this.nlev][4][1][1][1];
        for (int lev = 0; lev < this.nlev; ++lev) {
            int lfactor = (int)ArrayMath.pow(2.0, (double)lev);
            int nl3 = (this.n3 - 1) / lfactor + 1;
            int nl2 = (this.n2 - 1) / lfactor + 1;
            int nl1 = (this.n1 - 1) / lfactor + 1;
            for (int j = 0; j < 4; ++j) {
                attr[lev][j] = ArrayMath.zerofloat(nl1, nl2, nl3);
            }
        }
        for (int levb = 0; levb < this.nlev; ++levb) {
            int j;
            int i1b;
            int i2b;
            int i3b;
            float[][][][] pqja;
            int leva = levb - 1;
            int levc = levb + 1;
            float[][][][] pqjb = this.pqjShiftSmooth(sigma, levb, spyr);
            int nl3 = pqjb[0].length;
            int nl2 = pqjb[0][0].length;
            int nl1 = pqjb[0][0][0].length;
            if (leva >= 0) {
                pqja = this.pqjShiftSmooth(sigmaa, leva, spyr);
                for (i3b = 0; i3b < nl3; ++i3b) {
                    for (i2b = 0; i2b < nl2; ++i2b) {
                        for (i1b = 0; i1b < nl1; ++i1b) {
                            int i3a = 2 * i3b;
                            int i2a = 2 * i2b;
                            int i1a = 2 * i1b;
                            for (j = 0; j < 6; ++j) {
                                float[] fArray = pqjb[j][i3b][i2b];
                                int n = i1b;
                                fArray[n] = fArray[n] + pqja[j][i3a][i2a][i1a];
                            }
                        }
                    }
                }
            }
            if (levc < this.nlev) {
                pqja = this.pqjShiftSmooth(sigmac, levc, spyr);
                for (i3b = 0; i3b < nl3; ++i3b) {
                    for (i2b = 0; i2b < nl2; ++i2b) {
                        for (i1b = 0; i1b < nl1; ++i1b) {
                            int i3c = (int)((double)ArrayMath.round((double)i3b) * 0.5);
                            int i2c = (int)((double)ArrayMath.round((double)i2b) * 0.5);
                            int i1c = (int)((double)ArrayMath.round((double)i1b) * 0.5);
                            for (j = 0; j < 6; ++j) {
                                float[] fArray = pqjb[j][i3b][i2b];
                                int n = i1b;
                                fArray[n] = fArray[n] + pqja[j][i3c][i2c][i1c];
                            }
                        }
                    }
                }
            }
            for (int i3b2 = 0; i3b2 < nl3; ++i3b2) {
                for (int i2b2 = 0; i2b2 < nl2; ++i2b2) {
                    for (int i1b2 = 0; i1b2 < nl1; ++i1b2) {
                        for (int j2 = 0; j2 < 6; ++j2) {
                            f[j2] = pqjb[j2][i3b2][i2b2][i1b2];
                        }
                        SteerablePyramid.findCriticalPoints(f, abcf);
                        attr[levb][0][i3b2][i2b2][i1b2] = (float)abcf[abcindx][0];
                        attr[levb][1][i3b2][i2b2][i1b2] = (float)abcf[abcindx][1];
                        attr[levb][2][i3b2][i2b2][i1b2] = (float)abcf[abcindx][2];
                        attr[levb][3][i3b2][i2b2][i1b2] = (float)((abcf[e0indx][3] - abcf[e1indx][3]) / abcf[2][3]);
                    }
                }
            }
        }
        return attr;
    }

    public void steerScale(boolean forlinear, int linpowr, float k, float thresh, float[][][][][] attr, float[][][][][] spyr) {
        float scal = 0.0f;
        int j0 = 0;
        int j1 = 0;
        int j2 = 0;
        float signb = 1.0f;
        for (int lev = 0; lev < this.nlev; ++lev) {
            int lfactor = (int)ArrayMath.pow(2.0, (double)lev);
            int nl3 = (this.n3 - 1) / lfactor + 1;
            int nl2 = (this.n2 - 1) / lfactor + 1;
            int nl1 = (this.n1 - 1) / lfactor + 1;
            if (this.statelinear) {
                int dir;
                float[][][] p = ArrayMath.add(spyr[lev][0], spyr[lev][1]);
                for (dir = 2; dir < 6; ++dir) {
                    ArrayMath.add(p, spyr[lev][dir], p);
                }
                ArrayMath.mul(p, 0.5f, p);
                for (dir = 0; dir < 6; ++dir) {
                    ArrayMath.sub(p, spyr[lev][dir], spyr[lev][dir]);
                }
            }
            for (int dir = 0; dir < 6; ++dir) {
                if (dir == 0) {
                    j0 = 0;
                    j1 = 1;
                    j2 = 2;
                    signb = 1.0f;
                } else if (dir == 1) {
                    j0 = 0;
                    j1 = 1;
                    j2 = 2;
                    signb = -1.0f;
                } else if (dir == 2) {
                    j0 = 2;
                    j1 = 0;
                    j2 = 1;
                    signb = 1.0f;
                } else if (dir == 3) {
                    j0 = 2;
                    j1 = 0;
                    j2 = 1;
                    signb = -1.0f;
                } else if (dir == 4) {
                    j0 = 1;
                    j1 = 2;
                    j2 = 0;
                    signb = 1.0f;
                } else if (dir == 5) {
                    j0 = 1;
                    j1 = 2;
                    j2 = 0;
                    signb = -1.0f;
                }
                for (int i3 = 0; i3 < nl3; ++i3) {
                    for (int i2 = 0; i2 < nl2; ++i2) {
                        int i1 = 0;
                        while (i1 < nl1) {
                            float ai = attr[lev][j0][i3][i2][i1];
                            float bi = attr[lev][j1][i3][i2][i1] * signb;
                            float ci = attr[lev][j2][i3][i2][i1];
                            float wi = (ai + bi) * (ai + bi) - ci * ci;
                            if (linpowr == 0) {
                                scal = 1.0f;
                            } else if (linpowr == 1) {
                                scal = attr[lev][3][i3][i2][i1];
                            } else if (linpowr > 1 && linpowr < 99) {
                                scal = ArrayMath.pow(attr[lev][3][i3][i2][i1], (float)linpowr);
                            } else if (linpowr == 99) {
                                scal = 1.0f / (1.0f + ArrayMath.exp(k * (thresh - attr[lev][3][i3][i2][i1])));
                            }
                            float[] fArray = spyr[lev][dir][i3][i2];
                            int n = i1++;
                            fArray[n] = fArray[n] * (scal * wi);
                        }
                    }
                }
            }
        }
    }

    public void steerScale(int linpowr, float k, float thresh, float[][][][] attr, float[][][][] spyr) {
        float scal = 0.0f;
        for (int lev = 0; lev < this.nlev; ++lev) {
            int nl2 = spyr[lev][0].length;
            int nl1 = spyr[lev][0][0].length;
            for (int i2 = 0; i2 < nl2; ++i2) {
                int i1 = 0;
                while (i1 < nl1) {
                    double theta = attr[lev][0][i2][i1];
                    float w0 = 0.5f * (float)(1.0 + 2.0 * ArrayMath.cos(2.0 * (theta - 0.0)));
                    float w1 = 0.5f * (float)(1.0 + 2.0 * ArrayMath.cos(2.0 * (theta - 1.0471975511965976)));
                    float w2 = 0.5f * (float)(1.0 + 2.0 * ArrayMath.cos(2.0 * (theta - 2.0943951023931953)));
                    if (linpowr == 0) {
                        scal = 1.0f;
                    } else if (linpowr == 1) {
                        scal = attr[lev][1][i2][i1];
                    } else if (linpowr > 1 && linpowr < 99) {
                        scal = ArrayMath.pow(attr[lev][1][i2][i1], (float)linpowr);
                    } else if (linpowr == 99) {
                        scal = 1.0f / (1.0f + ArrayMath.exp(k * (thresh - attr[lev][1][i2][i1])));
                    }
                    float[] fArray = spyr[lev][0][i2];
                    int n = i1;
                    fArray[n] = fArray[n] * (scal * w0);
                    float[] fArray2 = spyr[lev][1][i2];
                    int n2 = i1;
                    fArray2[n2] = fArray2[n2] * (scal * w1);
                    float[] fArray3 = spyr[lev][2][i2];
                    int n3 = i1++;
                    fArray3[n3] = fArray3[n3] * (scal * w2);
                }
            }
        }
    }

    private void makePyramidLevel(int lev, float[][] cf, float[][][][] spyr) {
        int lfactor = (int)ArrayMath.pow(2.0, (double)lev);
        int nl2 = (this.n2 - 1) / lfactor + 1;
        int nl1 = (this.n1 - 1) / lfactor + 1;
        float[][] clo1 = ArrayMath.copy(cf);
        this.applyRadial(this.ka / 2.0, this.kb / 2.0, clo1);
        ArrayMath.sub(cf, clo1, cf);
        this.ftInverse(lev, 0, clo1, spyr);
        int ml2 = (nl2 - 1) / 2 + 1;
        int ml1 = (nl1 - 1) / 2 + 1;
        ArrayMath.copy(ml1, ml2, 0, 0, 2, 2, spyr[lev][0], 0, 0, 1, 1, spyr[lev + 1][0]);
        for (int dir = 0; dir < 3; ++dir) {
            this.applySteerableFilter(dir, cf, clo1);
            this.ftInverse(lev, dir, clo1, spyr);
        }
    }

    private void makePyramidLevel(int lev, float[][][] cf, float[][][][][] spyr) {
        int lfactor = (int)ArrayMath.pow(2.0, (double)lev);
        int nl3 = (this.n3 - 1) / lfactor + 1;
        int nl2 = (this.n2 - 1) / lfactor + 1;
        int nl1 = (this.n1 - 1) / lfactor + 1;
        float[][][] clo1 = ArrayMath.copy(cf);
        this.applyRadial(this.ka / 2.0, this.kb / 2.0, clo1);
        ArrayMath.sub(cf, clo1, cf);
        this.ftInverse(lev, 0, clo1, spyr);
        int ml3 = (nl3 - 1) / 2 + 1;
        int ml2 = (nl2 - 1) / 2 + 1;
        int ml1 = (nl1 - 1) / 2 + 1;
        ArrayMath.copy(ml1, ml2, ml3, 0, 0, 0, 2, 2, 2, spyr[lev][0], 0, 0, 0, 1, 1, 1, spyr[lev + 1][0]);
        for (int dir = 0; dir < 6; ++dir) {
            this.applySteerableFilter(dir, cf, clo1);
            this.ftInverse(lev, dir, clo1, spyr);
        }
    }

    private void applyRadial(double k1, double k2, float[][] cf) {
        int nf2 = cf.length;
        int nf1 = cf[0].length / 2;
        double m1 = nf1 - 1;
        double m2 = (double)(nf2 - 1) / 2.0;
        double mf1 = 1.0 / m1;
        double mf2 = 1.0 / m2;
        double denom = 1.0 / (k2 - k1);
        for (int i2 = 0; i2 < nf2; ++i2) {
            for (int i1 = 0; i1 < nf1; ++i1) {
                double w1 = (double)i1 * mf1;
                double w2 = ((double)i2 - m2) * mf2;
                double wd = ArrayMath.sqrt(w1 * w1 + w2 * w2);
                int ir = 2 * i1;
                int ii = ir + 1;
                if (wd > k2) {
                    cf[i2][ir] = 0.0f;
                    cf[i2][ii] = 0.0f;
                    continue;
                }
                if (!(wd > k1) || !(wd < k2)) continue;
                double a = (wd - k1) * denom * Math.PI;
                float b = (float)(0.5 * (1.0 + ArrayMath.cos(a)));
                float[] fArray = cf[i2];
                int n = ir;
                fArray[n] = fArray[n] * b;
                float[] fArray2 = cf[i2];
                int n2 = ii;
                fArray2[n2] = fArray2[n2] * b;
            }
        }
    }

    private void applyRadial(double k1, double k2, float[][][] cf) {
        int nf3 = cf.length;
        int nf2 = cf[0].length;
        int nf1 = cf[0][0].length / 2;
        double m1 = nf1 - 1;
        double m2 = (double)(nf2 - 1) / 2.0;
        double m3 = (double)(nf3 - 1) / 2.0;
        double mf1 = 1.0 / m1;
        double mf2 = 1.0 / m2;
        double mf3 = 1.0 / m3;
        double denom = 1.0 / (k2 - k1);
        for (int i3 = 0; i3 < nf3; ++i3) {
            for (int i2 = 0; i2 < nf2; ++i2) {
                for (int i1 = 0; i1 < nf1; ++i1) {
                    double w1 = (double)i1 * mf1;
                    double w2 = ((double)i2 - m2) * mf2;
                    double w3 = ((double)i3 - m3) * mf3;
                    double wd = Math.sqrt(w1 * w1 + w2 * w2 + w3 * w3);
                    int ir = 2 * i1;
                    int ii = ir + 1;
                    if (wd >= k2) {
                        cf[i3][i2][ir] = 0.0f;
                        cf[i3][i2][ii] = 0.0f;
                        continue;
                    }
                    if (!(wd > k1) || !(wd < k2)) continue;
                    double a = (wd - k1) * denom * Math.PI;
                    float b = (float)(0.5 * (1.0 + ArrayMath.cos(a)));
                    float[] fArray = cf[i3][i2];
                    int n = ir;
                    fArray[n] = fArray[n] * b;
                    float[] fArray2 = cf[i3][i2];
                    int n2 = ii;
                    fArray2[n2] = fArray2[n2] * b;
                }
            }
        }
    }

    private void applySteerableFilter(int dir, float[][] cfin, float[][] cfout) {
        int nf2 = cfin.length;
        int nf1 = cfin[0].length / 2;
        int m1 = nf1 - 1;
        int m2 = (nf2 - 1) / 2;
        double mf1 = 1.0 / (double)m1;
        double mf2 = 1.0 / (double)m2;
        double thetan = (double)dir * 0.3333333333333333 * Math.PI;
        for (int i2 = 0; i2 < nf2; ++i2) {
            for (int i1 = 0; i1 < nf1; ++i1) {
                int ir = 2 * i1;
                int ii = ir + 1;
                double w1 = (double)i1 * mf1;
                double w2 = (double)(i2 - m2) * mf2;
                double theta = ArrayMath.atan2(w1, w2);
                float c = (float)ArrayMath.cos(theta - thetan);
                c = 0.6666667f * c * c;
                cfout[i2][ir] = c * cfin[i2][ir];
                cfout[i2][ii] = c * cfin[i2][ii];
            }
        }
    }

    private void applySteerableFilter(int dir, float[][][] cfin, float[][][] cfout) {
        int ii;
        int ir;
        int nf3 = cfin.length;
        int nf2 = cfin[0].length;
        int nf1 = cfin[0][0].length / 2;
        double m2 = (double)(nf2 - 1) / 2.0;
        double m3 = (double)(nf3 - 1) / 2.0;
        double v1 = 0.0;
        double v2 = 0.0;
        double v3 = 0.0;
        double s = 1.0;
        double s2 = 1.0 + s * s;
        if (dir == 0) {
            v1 = 0.0;
            v2 = 1.0;
            v3 = s;
        } else if (dir == 1) {
            v1 = 0.0;
            v2 = 1.0;
            v3 = -s;
        } else if (dir == 2) {
            v1 = 1.0;
            v2 = s;
            v3 = 0.0;
        } else if (dir == 3) {
            v1 = 1.0;
            v2 = -s;
            v3 = 0.0;
        } else if (dir == 4) {
            v1 = s;
            v2 = 0.0;
            v3 = 1.0;
        } else if (dir == 5) {
            v1 = -s;
            v2 = 0.0;
            v3 = 1.0;
        }
        for (int i3 = 0; i3 < nf3; ++i3) {
            for (int i2 = 0; i2 < nf2; ++i2) {
                for (int i1 = 0; i1 < nf1; ++i1) {
                    double w1 = i1;
                    double w2 = (double)i2 - m2;
                    double w3 = (double)i3 - m3;
                    ir = 2 * i1;
                    ii = ir + 1;
                    double flt1 = w1 * v1 + w2 * v2 + w3 * v3;
                    flt1 *= flt1;
                    double flt2 = (w1 * w1 + w2 * w2 + w3 * w3) * 2.0 * s2;
                    cfout[i3][i2][ir] = cfin[i3][i2][ir] * (float)(flt1 /= flt2);
                    cfout[i3][i2][ii] = cfin[i3][i2][ii] * (float)flt1;
                }
            }
        }
        if ((int)m2 * 2 == nf2 && (int)m3 * 2 == nf3) {
            ir = 0;
            ii = ir + 1;
            cfout[(int)m3][(int)m2][ir] = 0.0f;
            cfout[(int)m3][(int)m2][ii] = 0.0f;
        }
    }

    private float[][][] pqjShiftSmooth(double sigma, int lev, float[][][][] spyr) {
        RecursiveGaussianFilter rcg = new RecursiveGaussianFilter(sigma);
        float[] test = ArrayMath.zerofloat(3);
        float[][][] pq = ArrayMath.zerofloat(1, 1, 3);
        pq[0] = ArrayMath.add(spyr[lev][0], spyr[lev][1]);
        ArrayMath.add(pq[0], spyr[lev][2], pq[0]);
        pq[1] = ArrayMath.mul(pq[0], spyr[lev][1]);
        pq[2] = ArrayMath.mul(pq[0], spyr[lev][2]);
        ArrayMath.mul(pq[0], spyr[lev][0], pq[0]);
        int n2 = pq[0].length;
        int n1 = pq[0][0].length;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                test[0] = pq[0][i2][i1];
                test[1] = pq[1][i2][i1];
                test[2] = pq[2][i2][i1];
                float testmin = ArrayMath.min(test);
                if (!(testmin < 0.0f)) continue;
                float[] fArray = pq[0][i2];
                int n = i1;
                fArray[n] = fArray[n] - testmin;
                float[] fArray2 = pq[1][i2];
                int n3 = i1;
                fArray2[n3] = fArray2[n3] - testmin;
                float[] fArray3 = pq[2][i2];
                int n4 = i1;
                fArray3[n4] = fArray3[n4] - testmin;
            }
        }
        rcg.apply00(pq[0], pq[0]);
        rcg.apply00(pq[1], pq[1]);
        rcg.apply00(pq[2], pq[2]);
        return pq;
    }

    private float[][][][] pqjShiftSmooth(double sigma, int lev, float[][][][][] spyr) {
        int dir;
        RecursiveGaussianFilter rcg = new RecursiveGaussianFilter(sigma);
        float[] test = ArrayMath.zerofloat(6);
        float[][][][] pq = new float[6][1][1][1];
        pq[0] = ArrayMath.add(spyr[lev][0], spyr[lev][1]);
        for (dir = 2; dir < 6; ++dir) {
            ArrayMath.add(pq[0], spyr[lev][dir], pq[0]);
        }
        for (dir = 1; dir < 6; ++dir) {
            pq[dir] = ArrayMath.mul(pq[0], spyr[lev][dir]);
        }
        ArrayMath.mul(pq[0], spyr[lev][0], pq[0]);
        int nl3 = pq[0].length;
        int nl2 = pq[0][0].length;
        int nl1 = pq[0][0][0].length;
        for (int i3 = 0; i3 < nl3; ++i3) {
            for (int i2 = 0; i2 < nl2; ++i2) {
                for (int i1 = 0; i1 < nl1; ++i1) {
                    int dir2;
                    for (dir2 = 0; dir2 < 6; ++dir2) {
                        test[dir2] = pq[dir2][i3][i2][i1];
                    }
                    float testmin = ArrayMath.min(test);
                    if (!(testmin < 0.0f)) continue;
                    for (dir2 = 0; dir2 < 6; ++dir2) {
                        float[] fArray = pq[dir2][i3][i2];
                        int n = i1;
                        fArray[n] = fArray[n] - testmin;
                    }
                }
            }
        }
        for (int dir3 = 0; dir3 < 6; ++dir3) {
            rcg.apply000(pq[dir3], pq[dir3]);
        }
        return pq;
    }

    private static double[][] findExtrema(double f0, double f1, double f2) {
        double theta1 = 0.5 * (Math.PI + ArrayMath.atan2(SQRT3 * (f1 - f2), 2.0 * f0 - f1 - f2));
        double value1 = SteerablePyramid.eval0(f0, f1, f2, theta1);
        double theta2 = SteerablePyramid.modPi(theta1 + 1.5707963267948966);
        double value2 = SteerablePyramid.eval0(f0, f1, f2, theta2);
        if (ArrayMath.abs(value1) >= ArrayMath.abs(value2)) {
            return new double[][]{{theta1, value1}, {theta2, value2}};
        }
        return new double[][]{{theta2, value2}, {theta1, value1}};
    }

    private static double modPi(double theta) {
        return theta - ArrayMath.floor(theta / Math.PI) * Math.PI;
    }

    private static double eval0(double f0, double f1, double f2, double theta) {
        double k0 = 0.3333333333333333 * (1.0 + 2.0 * ArrayMath.cos(2.0 * (theta - 0.0)));
        double k1 = 0.3333333333333333 * (1.0 + 2.0 * ArrayMath.cos(2.0 * (theta - 1.0471975511965976)));
        double k2 = 0.3333333333333333 * (1.0 + 2.0 * ArrayMath.cos(2.0 * (theta - 2.0943951023931953)));
        return k0 * f0 + k1 * f1 + k2 * f2;
    }

    private static double[][] findCriticalPoints(double[] f, double[][] abcf) {
        double ft;
        double ct;
        double bt;
        double at;
        double cr;
        double br;
        double ar;
        double c;
        double b;
        double a;
        double fsum = f[0] + f[1] + f[2] + f[3] + f[4] + f[5];
        double fab = f[0] - f[1];
        double fac = f[2] - f[3];
        double fbc = f[4] - f[5];
        double faa = f[4] + f[5];
        double fbb = f[2] + f[3];
        double fcc = f[0] + f[1];
        double hbb = 2.0 * (fbb - faa);
        double hcc = 2.0 * (fcc - faa);
        double hbc = -fbc;
        double da = hbb * hcc - hbc * hbc;
        double dda = da * da;
        double haa = 2.0 * (faa - fbb);
        hcc = 2.0 * (fcc - fbb);
        double hac = -fac;
        double db = haa * hcc - hac * hac;
        double ddb = db * db;
        haa = 2.0 * (faa - fcc);
        hbb = 2.0 * (fbb - fcc);
        double hab = -fab;
        double dc = haa * hbb - hab * hab;
        double ddc = dc * dc;
        if (dda >= ddb && dda >= ddc) {
            a = 1.0;
            b = 0.0;
            c = 0.0;
        } else if (ddb >= ddc) {
            a = 0.0;
            b = 1.0;
            c = 0.0;
        } else {
            a = 0.0;
            b = 0.0;
            c = 1.0;
        }
        for (int niter = 0; niter < 50; ++niter) {
            double ct2;
            double hcc2;
            double gc;
            double at2;
            double dc2;
            double db2;
            double da2;
            double odet;
            double det;
            double haa2;
            double ga;
            double aa = a * a;
            double bb = b * b;
            double cc = c * c;
            if (aa <= cc && bb <= cc) {
                double aoc = a / c;
                double boc = b / c;
                double aocs = aoc * aoc;
                double bocs = boc * boc;
                double faamcc2 = (faa - fcc) * 2.0;
                double fbbmcc2 = (fbb - fcc) * 2.0;
                double aocsp1 = aocs + 1.0;
                double bocsp1 = bocs + 1.0;
                ga = a * (faamcc2 + boc * fbc) - c * (1.0 - aocs) * fac - b * fab;
                double gb = b * (fbbmcc2 + aoc * fac) - c * (1.0 - bocs) * fbc - a * fab;
                haa2 = faamcc2 + boc * aocsp1 * fbc + aoc * (3.0 + aocs) * fac;
                double hbb2 = fbbmcc2 + aoc * bocsp1 * fac + boc * (3.0 + bocs) * fbc;
                double hab2 = boc * aocsp1 * fac + aoc * bocsp1 * fbc - fab;
                det = haa2 * hbb2 - hab2 * hab2;
                if (det <= 1.0E-40 && -det <= 1.0E-40) {
                    det = 1.0E-40;
                }
                odet = 1.0 / det;
                da2 = odet * (hbb2 * ga - hab2 * gb);
                db2 = odet * (haa2 * gb - hab2 * ga);
                dc2 = 0.0;
                at2 = a - da2;
                double bt2 = b - db2;
                while (at2 * at2 + bt2 * bt2 >= 1.0) {
                    at2 = a - (da2 *= 0.5);
                    bt2 = b - (db2 *= 0.5);
                }
                c = c >= 0.0 ? ArrayMath.sqrt(1.0 - a * a - b * b) : -ArrayMath.sqrt(1.0 - (a -= da2) * a - (b -= db2) * b);
            } else if (aa <= bb) {
                double aob = a / b;
                double cob = c / b;
                double aobs = aob * aob;
                double cobs = cob * cob;
                double faambb2 = (faa - fbb) * 2.0;
                double fccmbb2 = (fcc - fbb) * 2.0;
                double aobsp1 = aobs + 1.0;
                double cobsp1 = cobs + 1.0;
                ga = a * (faambb2 + cob * fbc) - b * (1.0 - aobs) * fab - c * fac;
                gc = c * (fccmbb2 + aob * fab) - b * (1.0 - cobs) * fbc - a * fac;
                haa2 = faambb2 + cob * aobsp1 * fbc + aob * (3.0 + aobs) * fab;
                hcc2 = fccmbb2 + aob * cobsp1 * fab + cob * (3.0 + cobs) * fbc;
                double hac2 = cob * aobsp1 * fab + aob * cobsp1 * fbc - fac;
                det = haa2 * hcc2 - hac2 * hac2;
                if (det <= 1.0E-40 && -det <= 1.0E-40) {
                    det = 1.0E-40;
                }
                odet = 1.0 / det;
                da2 = odet * (hcc2 * ga - hac2 * gc);
                db2 = 0.0;
                dc2 = odet * (haa2 * gc - hac2 * ga);
                at2 = a - da2;
                ct2 = c - dc2;
                while (at2 * at2 + ct2 * ct2 >= 1.0) {
                    at2 = a - (da2 *= 0.5);
                    ct2 = c - (dc2 *= 0.5);
                }
                b = b >= 0.0 ? ArrayMath.sqrt(1.0 - a * a - c * c) : -ArrayMath.sqrt(1.0 - (a -= da2) * a - (c -= dc2) * c);
            } else {
                double boa = b / a;
                double coa = c / a;
                double boas = boa * boa;
                double coas = coa * coa;
                double fbbmaa2 = (fbb - faa) * 2.0;
                double fccmaa2 = (fcc - faa) * 2.0;
                double boasp1 = boas + 1.0;
                double coasp1 = coas + 1.0;
                double gb = b * (fbbmaa2 + coa * fac) - a * (1.0 - boas) * fab - c * fbc;
                gc = c * (fccmaa2 + boa * fab) - a * (1.0 - coas) * fac - b * fbc;
                double hbb3 = fbbmaa2 + coa * boasp1 * fac + boa * (3.0 + boas) * fab;
                hcc2 = fccmaa2 + boa * coasp1 * fab + coa * (3.0 + coas) * fac;
                double hbc2 = coa * boasp1 * fab + boa * coasp1 * fac - fbc;
                det = hbb3 * hcc2 - hbc2 * hbc2;
                if (det <= 1.0E-40 && -det <= 1.0E-40) {
                    det = 1.0E-40;
                }
                odet = 1.0 / det;
                da2 = 0.0;
                db2 = odet * (hcc2 * gb - hbc2 * gc);
                dc2 = odet * (hbb3 * gc - hbc2 * gb);
                double bt3 = b - db2;
                ct2 = c - dc2;
                while (bt3 * bt3 + ct2 * ct2 >= 1.0) {
                    bt3 = b - (db2 *= 0.5);
                    ct2 = c - (dc2 *= 0.5);
                }
                double d = a = a >= 0.0 ? ArrayMath.sqrt(1.0 - b * b - c * c) : -ArrayMath.sqrt(1.0 - (b -= db2) * b - (c -= dc2) * c);
            }
            if (da2 < 0.01 && -da2 < 0.01 && db2 < 0.01 && -db2 < 0.01 && dc2 < 0.01 && -dc2 < 0.01) break;
        }
        double a0 = a;
        double b0 = b;
        double c0 = c;
        double aa = a * a;
        double bb = b * b;
        double cc = c * c;
        if (aa <= bb && aa <= cc) {
            ar = 0.0;
            br = c0;
            cr = -b0;
        } else if (bb <= cc) {
            ar = c0;
            br = 0.0;
            cr = -a0;
        } else {
            ar = b0;
            br = -a0;
            cr = 0.0;
        }
        double sr0 = ar * a0 + br * b0 + cr * c0;
        double sr = 1.0 / ArrayMath.sqrt((ar -= sr0 * a0) * ar + (br -= sr0 * b0) * br + (cr -= sr0 * c0) * cr);
        double as = (br *= sr) * c0 - b0 * (cr *= sr);
        double bs = cr * a0 - c0 * (ar *= sr);
        double cs = ar * b0 - a0 * br;
        double a1 = ar;
        double b1 = br;
        double c1 = cr;
        double a2 = COS_PIO3 * ar + SIN_PIO3 * as;
        double b2 = COS_PIO3 * br + SIN_PIO3 * bs;
        double c2 = COS_PIO3 * cr + SIN_PIO3 * cs;
        double a3 = COS_PIO3 * ar - SIN_PIO3 * as;
        double b3 = COS_PIO3 * br - SIN_PIO3 * bs;
        double c3 = COS_PIO3 * cr - SIN_PIO3 * cs;
        double f0 = fab * a0 * b0 + fac * a0 * c0 + fbc * b0 * c0 - faa * a0 * a0 - fbb * b0 * b0 - fcc * c0 * c0;
        double f1 = fab * a1 * b1 + fac * a1 * c1 + fbc * b1 * c1 - faa * a1 * a1 - fbb * b1 * b1 - fcc * c1 * c1;
        double f2 = fab * a2 * b2 + fac * a2 * c2 + fbc * b2 * c2 - faa * a2 * a2 - fbb * b2 * b2 - fcc * c2 * c2;
        double f3 = fab * a3 * b3 + fac * a3 * c3 + fbc * b3 * c3 - faa * a3 * a3 - fbb * b3 * b3 - fcc * c3 * c3;
        double denom = 2.0 * f1 - f2 - f3;
        if (denom < 1.0E-40 && -denom < 1.0E-40) {
            denom = 1.0E-40;
        }
        double theta = 0.5 * ArrayMath.atan(SQRT3 * (f2 - f3) / denom);
        double ctheta = ArrayMath.cos(theta);
        double stheta = ArrayMath.sin(theta);
        a1 = ctheta * ar + stheta * as;
        b1 = ctheta * br + stheta * bs;
        c1 = ctheta * cr + stheta * cs;
        a2 = stheta * ar - ctheta * as;
        b2 = stheta * br - ctheta * bs;
        c2 = stheta * cr - ctheta * cs;
        f1 = fab * a1 * b1 + fac * a1 * c1 + fbc * b1 * c1 - faa * a1 * a1 - fbb * b1 * b1 - fcc * c1 * c1;
        f2 = fab * a2 * b2 + fac * a2 * c2 + fbc * b2 * c2 - faa * a2 * a2 - fbb * b2 * b2 - fcc * c2 * c2;
        f0 = fsum + 2.0 * f0;
        f1 = fsum + 2.0 * f1;
        f2 = fsum + 2.0 * f2;
        if (f0 > f1) {
            at = a0;
            a0 = a1;
            a1 = at;
            bt = b0;
            b0 = b1;
            b1 = bt;
            ct = c0;
            c0 = c1;
            c1 = ct;
            ft = f0;
            f0 = f1;
            f1 = ft;
        }
        if (f1 > f2) {
            at = a1;
            a1 = a2;
            a2 = at;
            bt = b1;
            b1 = b2;
            b2 = bt;
            ct = c1;
            c1 = c2;
            c2 = ct;
            ft = f1;
            f1 = f2;
            f2 = ft;
        }
        if (f0 > f1) {
            at = a0;
            a0 = a1;
            a1 = at;
            bt = b0;
            b0 = b1;
            b1 = bt;
            ct = c0;
            c0 = c1;
            c1 = ct;
            ft = f0;
            f0 = f1;
            f1 = ft;
        }
        if (abcf == null) {
            abcf = new double[3][4];
        }
        abcf[0][0] = a0;
        abcf[0][1] = b0;
        abcf[0][2] = c0;
        abcf[0][3] = f0;
        abcf[1][0] = a1;
        abcf[1][1] = b1;
        abcf[1][2] = c1;
        abcf[1][3] = f1;
        abcf[2][0] = a2;
        abcf[2][1] = b2;
        abcf[2][2] = c2;
        abcf[2][3] = f2;
        return abcf;
    }

    private float[][] ftForward(int level, float[][] x) {
        int ny2 = x.length;
        int ny1 = x[0].length;
        int mpad = ArrayMath.round(20.0f / (1.0f + (float)level));
        int lfactor = (int)ArrayMath.pow(2.0, (double)level);
        int nl2 = (this.n2 - 1) / lfactor + 1;
        int nl1 = (this.n1 - 1) / lfactor + 1;
        int nf1 = FftReal.nfftSmall(nl1 + mpad * 2);
        int nf1c = nf1 / 2 + 1;
        int nf2 = FftComplex.nfftSmall(nl2 + mpad * 2);
        float[][] xr = ArrayMath.zerofloat(nf1, nf2);
        ArrayMath.copy(ny1, ny2, 0, 0, x, mpad, mpad, xr);
        float[][] cx = ArrayMath.czerofloat(nf1c, nf2);
        FftReal fft1 = new FftReal(nf1);
        FftComplex fft2 = new FftComplex(nf2);
        fft1.realToComplex1(1, nf2, xr, cx);
        this.flipSign(2, cx);
        fft2.complexToComplex2(1, nf1c, cx, cx);
        return cx;
    }

    private float[][][] ftForward(int level, float[][][] x) {
        int ny3 = x.length;
        int ny2 = x[0].length;
        int ny1 = x[0][0].length;
        int mpad = ArrayMath.round(20.0f / (1.0f + (float)level));
        int lfactor = (int)ArrayMath.pow(2.0, (double)level);
        int nl3 = (this.n3 - 1) / lfactor + 1;
        int nl2 = (this.n2 - 1) / lfactor + 1;
        int nl1 = (this.n1 - 1) / lfactor + 1;
        int nf3 = FftComplex.nfftSmall(nl3 + mpad * 2);
        int nf2 = FftComplex.nfftSmall(nl2 + mpad * 2);
        int nf1 = FftReal.nfftSmall(nl1 + mpad * 2);
        int nf1c = nf1 / 2 + 1;
        float[][][] xr = ArrayMath.zerofloat(nf1, nf2, nf3);
        ArrayMath.copy(ny1, ny2, ny3, 0, 0, 0, x, mpad, mpad, mpad, xr);
        float[][][] cx = ArrayMath.czerofloat(nf1c, nf2, nf3);
        FftReal fft1 = new FftReal(nf1);
        FftComplex fft2 = new FftComplex(nf2);
        FftComplex fft3 = new FftComplex(nf3);
        fft1.realToComplex1(1, nf2, nf3, xr, cx);
        this.flipSign(2, cx);
        fft2.complexToComplex2(1, nf1c, nf3, cx, cx);
        this.flipSign(3, cx);
        fft3.complexToComplex3(1, nf1c, nf2, cx, cx);
        return cx;
    }

    private void ftInverse(int lev, int dir, float[][] cf, float[][][][] spyr) {
        int nf2 = cf.length;
        int nf1c = cf[0].length / 2;
        int nf1 = (nf1c - 1) * 2;
        int mpad = ArrayMath.round(20.0f / (1.0f + (float)lev));
        int lfactor = (int)ArrayMath.pow(2.0, (double)lev);
        int nl2 = (this.n2 - 1) / lfactor + 1;
        int nl1 = (this.n1 - 1) / lfactor + 1;
        FftReal fft1 = new FftReal(nf1);
        FftComplex fft2 = new FftComplex(nf2);
        fft2.complexToComplex2(-1, nf1c, cf, cf);
        this.flipSign(2, cf);
        fft2.scale(nf1c, nf2, cf);
        fft1.complexToReal1(-1, nf2, cf, cf);
        fft1.scale(nf1, nf2, cf);
        ArrayMath.copy(nl1, nl2, mpad, mpad, 1, 1, cf, 0, 0, 1, 1, spyr[lev][dir]);
    }

    private void ftInverse(int lev, int dir, float[][][] cf, float[][][][][] spyr) {
        int nf3 = cf.length;
        int nf2 = cf[0].length;
        int nf1c = cf[0][0].length / 2;
        int nf1 = (nf1c - 1) * 2;
        int mpad = ArrayMath.round(20.0f / (1.0f + (float)lev));
        int lfactor = (int)ArrayMath.pow(2.0, (double)lev);
        int nl3 = (this.n3 - 1) / lfactor + 1;
        int nl2 = (this.n2 - 1) / lfactor + 1;
        int nl1 = (this.n1 - 1) / lfactor + 1;
        FftReal fft1 = new FftReal(nf1);
        FftComplex fft2 = new FftComplex(nf2);
        FftComplex fft3 = new FftComplex(nf3);
        fft3.complexToComplex3(-1, nf1c, nf2, cf, cf);
        this.flipSign(3, cf);
        fft3.scale(nf1c, nf2, nf3, cf);
        fft2.complexToComplex2(-1, nf1c, nf3, cf, cf);
        this.flipSign(2, cf);
        fft2.scale(nf1c, nf2, nf3, cf);
        fft1.complexToReal1(-1, nf2, nf3, cf, cf);
        fft1.scale(nf1, nf2, nf3, cf);
        ArrayMath.copy(nl1, nl2, nl3, mpad, mpad, mpad, 1, 1, 1, cf, 0, 0, 0, 1, 1, 1, spyr[lev][dir]);
    }

    private void flipSign(int a, float[][] x) {
        block5: {
            int nx1;
            int nx2;
            block4: {
                nx2 = x.length;
                nx1 = x[0].length;
                if (a != 1) break block4;
                for (int i2 = 0; i2 < nx2; ++i2) {
                    for (int i1 = 0; i1 < nx1 / 4; ++i1) {
                        int ir = 4 * i1;
                        int ii = ir + 1;
                        float[] fArray = x[i2];
                        int n = ir;
                        fArray[n] = fArray[n] * -1.0f;
                        float[] fArray2 = x[i2];
                        int n2 = ii;
                        fArray2[n2] = fArray2[n2] * -1.0f;
                    }
                }
                break block5;
            }
            if (a != 2) break block5;
            for (int i2 = 0; i2 < nx2 / 2; ++i2) {
                for (int i1 = 0; i1 < nx1 / 2; ++i1) {
                    int ir = 2 * i1;
                    int ii = ir + 1;
                    float[] fArray = x[2 * i2];
                    int n = ir;
                    fArray[n] = fArray[n] * -1.0f;
                    float[] fArray3 = x[2 * i2];
                    int n3 = ii;
                    fArray3[n3] = fArray3[n3] * -1.0f;
                }
            }
        }
    }

    private void flipSign(int a, float[][][] x) {
        block10: {
            int l1;
            int l2;
            int l3;
            block11: {
                block9: {
                    l3 = x.length;
                    l2 = x[0].length;
                    l1 = x[0][0].length / 2;
                    if (a != 1) break block9;
                    for (int i1 = 0; i1 < (int)Math.floor((double)l1 / 2.0); ++i1) {
                        for (int i3 = 0; i3 < l3; ++i3) {
                            for (int i2 = 0; i2 < l2; ++i2) {
                                int ir = 4 * i1;
                                int ii = ir + 1;
                                float[] fArray = x[i3][i2];
                                int n = ir;
                                fArray[n] = fArray[n] * -1.0f;
                                float[] fArray2 = x[i3][i2];
                                int n2 = ii;
                                fArray2[n2] = fArray2[n2] * -1.0f;
                            }
                        }
                    }
                    break block10;
                }
                if (a != 2) break block11;
                for (int i2 = 0; i2 < (int)Math.floor((double)l2 / 2.0); ++i2) {
                    for (int i3 = 0; i3 < l3; ++i3) {
                        for (int i1 = 0; i1 < l1; ++i1) {
                            int ir = 2 * i1;
                            int ii = ir + 1;
                            int b = 2 * i2;
                            float[] fArray = x[i3][b];
                            int n = ir;
                            fArray[n] = fArray[n] * -1.0f;
                            float[] fArray3 = x[i3][b];
                            int n3 = ii;
                            fArray3[n3] = fArray3[n3] * -1.0f;
                        }
                    }
                }
                break block10;
            }
            if (a != 3) break block10;
            for (int i3 = 0; i3 < (int)Math.floor((double)l3 / 2.0); ++i3) {
                for (int i2 = 0; i2 < l2; ++i2) {
                    for (int i1 = 0; i1 < l1; ++i1) {
                        int ir = 2 * i1;
                        int ii = ir + 1;
                        int b = 2 * i3;
                        float[] fArray = x[b][i2];
                        int n = ir;
                        fArray[n] = fArray[n] * -1.0f;
                        float[] fArray4 = x[b][i2];
                        int n4 = ii;
                        fArray4[n4] = fArray4[n4] * -1.0f;
                    }
                }
            }
        }
    }
}

