/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.la.DMatrix;
import edu.mines.jtk.la.DMatrixQrd;
import edu.mines.jtk.util.Check;

public class PolyTrend2 {
    private int _order;
    private int _n;
    private float[] _f;
    private float[] _x1;
    private float[] _x2;
    private double _x1c;
    private double _x2c;
    private double _f0;
    private double _f1;
    private double _f2;
    private double _f11;
    private double _f12;
    private double _f22;
    private boolean _detrend;

    public PolyTrend2(int order, float[] f, float[] x1, float[] x2) {
        Check.argument(0 <= order, "0<=order");
        Check.argument(order <= 2, "order<=2");
        this._order = order;
        this.setSamples(f, x1, x2);
    }

    public void setSamples(float[] f, float[] x1, float[] x2) {
        this._n = f.length;
        this._f = f;
        this._x1 = x1;
        this._x2 = x2;
        if (this._order > 0) {
            this.initCenter();
        }
        if (this._order == 2 && this._n >= 6) {
            this.initOrder2();
        } else if (this._order == 1 && this._n >= 3) {
            this.initOrder1();
        } else {
            this.initOrder0();
        }
    }

    public void detrend() {
        Check.state(!this._detrend, "trend not yet removed");
        this.detrend(this._f, this._x1, this._x2);
        this._detrend = true;
    }

    public void restore() {
        Check.state(this._detrend, "trend has been removed");
        this.restore(this._f, this._x1, this._x2);
        this._detrend = false;
    }

    public float detrend(float f, float x1, float x2) {
        double fi = (double)f - this._f0;
        if (this._order > 0) {
            double y1 = (double)x1 - this._x1c;
            double y2 = (double)x2 - this._x2c;
            fi -= this._f1 * y1 + this._f2 * y2;
            if (this._order > 1) {
                double y11 = y1 * y1;
                double y12 = y1 * y2;
                double y22 = y2 * y2;
                fi -= this._f11 * y11 + this._f12 * y12 + this._f22 * y22;
            }
        }
        return (float)fi;
    }

    public float restore(float f, float x1, float x2) {
        double fi = (double)f + this._f0;
        if (this._order > 0) {
            double y1 = (double)x1 - this._x1c;
            double y2 = (double)x2 - this._x2c;
            fi += this._f1 * y1 + this._f2 * y2;
            if (this._order > 1) {
                double y11 = y1 * y1;
                double y12 = y1 * y2;
                double y22 = y2 * y2;
                fi += this._f11 * y11 + this._f12 * y12 + this._f22 * y22;
            }
        }
        return (float)fi;
    }

    public void detrend(float[] f, float[] x1, float[] x2) {
        int n = f.length;
        for (int i = 0; i < n; ++i) {
            f[i] = this.detrend(f[i], x1[i], x2[i]);
        }
    }

    public void restore(float[] f, float[] x1, float[] x2) {
        int n = f.length;
        for (int i = 0; i < n; ++i) {
            f[i] = this.restore(f[i], x1[i], x2[i]);
        }
    }

    public void detrend(float[][] f, Sampling s1, Sampling s2) {
        int n2 = f.length;
        int n1 = f[0].length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float x2 = (float)s2.getValue(i2);
            for (int i1 = 0; i1 < n1; ++i1) {
                float x1 = (float)s1.getValue(i1);
                f[i2][i1] = this.detrend(f[i2][i1], x1, x2);
            }
        }
    }

    public void restore(float[][] f, Sampling s1, Sampling s2) {
        int n2 = f.length;
        int n1 = f[0].length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float x2 = (float)s2.getValue(i2);
            for (int i1 = 0; i1 < n1; ++i1) {
                float x1 = (float)s1.getValue(i1);
                f[i2][i1] = this.restore(f[i2][i1], x1, x2);
            }
        }
    }

    private void initCenter() {
        this._x1c = 0.0;
        this._x2c = 0.0;
        for (int i = 0; i < this._n; ++i) {
            this._x1c += (double)this._x1[i];
            this._x2c += (double)this._x2[i];
        }
        this._x1c /= (double)this._n;
        this._x2c /= (double)this._n;
    }

    private void initOrder0() {
        this._f22 = 0.0;
        this._f12 = 0.0;
        this._f11 = 0.0;
        this._f2 = 0.0;
        this._f1 = 0.0;
        this._f0 = 0.0;
        for (int i = 0; i < this._n; ++i) {
            this._f0 += (double)this._f[i];
        }
        this._f0 /= (double)this._n;
    }

    private void initOrder1() {
        this._f22 = 0.0;
        this._f12 = 0.0;
        this._f11 = 0.0;
        DMatrix a = new DMatrix(this._n, 3);
        DMatrix b = new DMatrix(this._n, 1);
        for (int i = 0; i < this._n; ++i) {
            double x1 = (double)this._x1[i] - this._x1c;
            double x2 = (double)this._x2[i] - this._x2c;
            a.set(i, 0, 1.0);
            a.set(i, 1, x1);
            a.set(i, 2, x2);
            b.set(i, 0, this._f[i]);
        }
        DMatrixQrd qrd = new DMatrixQrd(a);
        if (qrd.isFullRank()) {
            DMatrix f = qrd.solve(b);
            this._f0 = f.get(0, 0);
            this._f1 = f.get(1, 0);
            this._f2 = f.get(2, 0);
        } else {
            this.initOrder0();
        }
    }

    private void initOrder2() {
        DMatrix a = new DMatrix(this._n, 6);
        DMatrix b = new DMatrix(this._n, 1);
        for (int i = 0; i < this._n; ++i) {
            double x1 = (double)this._x1[i] - this._x1c;
            double x2 = (double)this._x2[i] - this._x2c;
            a.set(i, 0, 1.0);
            a.set(i, 1, x1);
            a.set(i, 2, x2);
            a.set(i, 3, x1 * x1);
            a.set(i, 4, x1 * x2);
            a.set(i, 5, x2 * x2);
            b.set(i, 0, this._f[i]);
        }
        DMatrixQrd qrd = new DMatrixQrd(a);
        if (qrd.isFullRank()) {
            DMatrix f = qrd.solve(b);
            this._f0 = f.get(0, 0);
            this._f1 = f.get(1, 0);
            this._f2 = f.get(2, 0);
            this._f11 = f.get(3, 0);
            this._f12 = f.get(4, 0);
            this._f22 = f.get(5, 0);
        } else {
            this.initOrder1();
        }
    }
}

