/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.util.Almost;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ScalarVect
implements Vect {
    protected transient double _value = 0.0;
    protected transient double _variance = 1.0;
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");
    private static final long serialVersionUID = 1L;
    private static final int VERSION = 1;

    public ScalarVect(double value, double variance) {
        this.init(value, variance);
    }

    protected ScalarVect() {
        this.init(0.0, 1.0);
    }

    public final void init(double value, double variance) {
        this._value = value;
        this._variance = variance;
    }

    public double get() {
        return this._value;
    }

    public void set(double value) {
        this._value = value;
    }

    @Override
    public ScalarVect clone() {
        try {
            return (ScalarVect)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
    }

    @Override
    public double dot(VectConst other) {
        ScalarVect rhs = (ScalarVect)other;
        return this._value * rhs._value;
    }

    public String toString() {
        return "ScalarVect<" + this._value + ">";
    }

    @Override
    public void dispose() {
        this._value = Double.NaN;
        this._variance = Double.NaN;
    }

    @Override
    public void multiplyInverseCovariance() {
        this._value = Almost.FLOAT.divide(this._value, this._variance, 0.0);
    }

    @Override
    public void constrain() {
    }

    @Override
    public void postCondition() {
    }

    @Override
    public void add(double scaleThis, double scaleOther, VectConst other) {
        ScalarVect rhs = (ScalarVect)other;
        this._value = scaleThis * this._value + scaleOther * rhs._value;
    }

    @Override
    public void project(double scaleThis, double scaleOther, VectConst other) {
        this.add(scaleThis, scaleOther, other);
    }

    @Override
    public double magnitude() {
        return Almost.FLOAT.divide(this.dot(this), this._variance, 0.0);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("value", this._value);
        map.put("variance", this._variance);
        map.put("VERSION", 1);
        out.writeObject(map);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Map map = (Map)in.readObject();
        this._value = (Double)map.get("value");
        this._variance = (Double)map.get("variance");
        int version = (Integer)map.get("VERSION");
        if (version != 1) {
            Logger.getLogger(this.getClass().getName()).warning("Need to convert data from version " + version + " to " + 1);
        }
    }
}

