/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.Parameter;
import edu.mines.jtk.util.ParameterSet;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ParameterSetTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(ParameterSetTest.class);
        TestRunner.run((Test)suite);
    }

    public void testClone() {
        ParameterSet root = new ParameterSet("root");
        String s1 = root.toString();
        ParameterSet foo = root.addParameterSet("foo");
        foo.addParameter("bar");
        try {
            ParameterSet temp = (ParameterSet)root.clone();
            temp.remove("foo");
            root.replaceWith(temp);
            String s2 = root.toString();
            ParameterSetTest.assertTrue((boolean)s1.equals(s2));
        }
        catch (CloneNotSupportedException e) {
            ParameterSetTest.assertTrue((boolean)false);
        }
    }

    public void testSpecialCharacters() {
        ParameterSet root = new ParameterSet("foo<&>\"'\\ bar");
        Parameter foo = root.addParameter("foo");
        String[] sa = new String[]{"foo", "foo<&>\"'\\ bar", "foo\nbar", "foo\\nbar", "foo\tbar", "foo\\tbar", "foo\"bar", "foo\\", "foo \\"};
        foo.setStrings(sa);
        String s1 = root.toString();
        root.fromString(s1);
        String s2 = root.toString();
        ParameterSetTest.assertTrue((boolean)s1.equals(s2));
        foo = root.getParameter("foo");
        String[] sb = foo.getStrings();
        ParameterSetTest.assertTrue((sa.length == sb.length ? 1 : 0) != 0);
        for (int i = 0; i < sa.length; ++i) {
            ParameterSetTest.assertTrue((boolean)sa[i].equals(sb[i]));
        }
    }

    public void testGeneral() {
        ParameterSet psroot = new ParameterSet();
        ParameterSet ss1 = psroot.addParameterSet("ss1");
        Parameter pb1 = ss1.addParameter("pb1");
        pb1.setBoolean(true);
        Parameter pi1 = ss1.addParameter("pi1");
        pi1.setInt(1);
        Parameter pf1 = ss1.addParameter("pf1");
        pf1.setFloat(1.0f);
        Parameter pd1 = ss1.addParameter("pd1");
        pd1.setDouble(1.0);
        Parameter ps1 = ss1.addParameter("ps1");
        ps1.setString("1.0");
        ParameterSet ss2 = ss1.copyTo(psroot, "ss2");
        ss1.remove();
        ss2.moveTo(psroot, "ss1");
        ss1 = psroot.getParameterSet("ss1");
        ss1.setName("ss2");
        ss2 = psroot.getParameterSet("ss2");
        ss2.setName("ss1");
        ss1 = psroot.getParameterSet("ss1");
        Parameter pfind = ss1.getParameter("ps1");
        ParameterSetTest.assertTrue((pfind != null ? 1 : 0) != 0);
        pfind = ss1.getParameter("foo");
        ParameterSetTest.assertTrue((pfind == null ? 1 : 0) != 0);
        boolean b1 = ss1.getParameter("pb1").getBoolean();
        ParameterSetTest.assertTrue((boolean)b1);
        int i1 = ss1.getParameter("pi1").getInt();
        ParameterSetTest.assertTrue((i1 == 1 ? 1 : 0) != 0);
        float f1 = ss1.getParameter("pf1").getFloat();
        ParameterSetTest.assertTrue((f1 == 1.0f ? 1 : 0) != 0);
        double d1 = ss1.getParameter("pd1").getDouble();
        ParameterSetTest.assertTrue((d1 == 1.0 ? 1 : 0) != 0);
        String s1 = ss1.getParameter("ps1").getString();
        ParameterSetTest.assertTrue((boolean)s1.equals("1.0"));
        String str1 = psroot.toString();
        psroot.fromString(str1);
        String str2 = psroot.toString();
        ParameterSetTest.assertTrue((boolean)str1.equals(str2));
        try {
            ParameterSet psrootClone = (ParameterSet)psroot.clone();
            ParameterSetTest.assertTrue((boolean)psroot.equals(psrootClone));
            ParameterSetTest.assertTrue((psroot.hashCode() == psrootClone.hashCode() ? 1 : 0) != 0);
        }
        catch (CloneNotSupportedException e) {
            ParameterSetTest.assertTrue((boolean)false);
        }
    }

    public void testSetGet() {
        ParameterSet ps = new ParameterSet();
        ps.setBoolean("pb", true);
        ps.setInt("pi", 1);
        ps.setLong("pl", 1L);
        ps.setFloat("pf", 1.0f);
        ps.setDouble("pd", 1.0);
        ps.setString("ps", "1.0");
        boolean b = ps.getBoolean("pb", false);
        ParameterSetTest.assertTrue((boolean)b);
        int i = ps.getInt("pi", 0);
        ParameterSetTest.assertTrue((i == 1 ? 1 : 0) != 0);
        long l = ps.getLong("pl", 0L);
        ParameterSetTest.assertTrue((l == 1L ? 1 : 0) != 0);
        float f = ps.getFloat("pf", 0.0f);
        ParameterSetTest.assertTrue((f == 1.0f ? 1 : 0) != 0);
        double d = ps.getDouble("pd", 0.0);
        ParameterSetTest.assertTrue((d == 1.0 ? 1 : 0) != 0);
        String s = ps.getString("ps", "0.0");
        ParameterSetTest.assertTrue((boolean)s.equals("1.0"));
        b = ps.getBoolean("qb", false);
        ParameterSetTest.assertTrue((!b ? 1 : 0) != 0);
        i = ps.getInt("qi", 0);
        ParameterSetTest.assertTrue((i == 0 ? 1 : 0) != 0);
        l = ps.getLong("ql", 0L);
        ParameterSetTest.assertTrue((l == 0L ? 1 : 0) != 0);
        f = ps.getFloat("qf", 0.0f);
        ParameterSetTest.assertTrue((f == 0.0f ? 1 : 0) != 0);
        d = ps.getDouble("qd", 0.0);
        ParameterSetTest.assertTrue((d == 0.0 ? 1 : 0) != 0);
        s = ps.getString("qs", "0.0");
        ParameterSetTest.assertTrue((boolean)s.equals("0.0"));
    }

    public void disable_testFile() {
        FileReader file = null;
        try {
            file = new FileReader("Input_Display.pwflow");
        }
        catch (FileNotFoundException e) {
            System.out.println("ParameterSet.testFile: FileNotFoundException: " + e.getMessage());
            ParameterSetTest.assertTrue((boolean)false);
        }
        BufferedReader input = new BufferedReader(file);
        StringBuffer buffer = new StringBuffer();
        try {
            String s;
            while ((s = input.readLine()) != null) {
                buffer.append(s);
                buffer.append('\n');
            }
            input.close();
        }
        catch (IOException e) {
            System.out.println("ParameterSet.testFile: IOException: " + e.getMessage());
            ParameterSetTest.assertTrue((boolean)false);
        }
        ParameterSet parset = new ParameterSet();
        parset.fromString(buffer.toString());
        System.out.println("parset read from file:\n" + parset.toString());
    }
}

