/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.hdf5;

import ij.IJ;
import java.util.Comparator;

class DataSetInfo {
    public String path;
    public String numericSortablePath;
    public String dimText;
    public String typeText;
    public String element_size_um_text;
    final int numPaddingSize = 10;

    public DataSetInfo(String p, String d, String t, String e) {
        this.setPath(p);
        this.dimText = d;
        this.typeText = t;
        this.element_size_um_text = e;
    }

    public void setPath(String p) {
        this.path = p;
        this.numericSortablePath = "";
        String num = "";
        for (int i = 0; i < p.length(); ++i) {
            if (this.isNum(p.charAt(i))) {
                num = num + p.charAt(i);
                continue;
            }
            if (num != "") {
                for (int j = 0; j < 10 - num.length(); ++j) {
                    this.numericSortablePath = this.numericSortablePath + "0";
                }
                this.numericSortablePath = this.numericSortablePath + num;
                num = "";
            }
            this.numericSortablePath = this.numericSortablePath + p.charAt(i);
        }
        if (num != "") {
            for (int j = 0; j < 10 - num.length(); ++j) {
                this.numericSortablePath = this.numericSortablePath + "0";
            }
            this.numericSortablePath = this.numericSortablePath + num;
        }
        IJ.log((String)this.path);
        IJ.log((String)this.numericSortablePath);
    }

    public static Comparator<DataSetInfo> createComparator() {
        return new DataSetInfoComparator();
    }

    private boolean isNum(char c) {
        return c >= '0' && c <= '9';
    }

    static class DataSetInfoComparator
    implements Comparator<DataSetInfo> {
        DataSetInfoComparator() {
        }

        @Override
        public int compare(DataSetInfo a, DataSetInfo b) {
            return a.numericSortablePath.compareTo(b.numericSortablePath);
        }
    }
}

